/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class DownloadSettings {
    private static final String CONFIG_FILE = "litematic-downloader-settings.json";
    private static DownloadSettings INSTANCE;
    private String downloadPath = "schematics";
    private boolean successToastsEnabled = false;
    private boolean errorToastsEnabled = true;
    private boolean infoToastsEnabled = false;
    private boolean warningToastsEnabled = true;
    private String sortOption = "newest";
    private int itemsPerPage = 20;
    private String tagFilter = "";
    private String excludedVendors = "";
    private int dismissedModMessageId = -1;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    private DownloadSettings() {
        this.load();
    }

    public static DownloadSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DownloadSettings();
        }
        return INSTANCE;
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public String getAbsoluteDownloadPath() {
        Path gamePath = FabricLoader.getInstance().getGameDir();
        return gamePath.resolve(this.downloadPath).toString();
    }

    public String getGameDirectory() {
        return FabricLoader.getInstance().getGameDir().toString();
    }

    public void setDownloadPath(String path) {
        this.downloadPath = path;
        this.save();
    }

    public boolean isSuccessToastsEnabled() {
        return this.successToastsEnabled;
    }

    public void setSuccessToastsEnabled(boolean enabled) {
        this.successToastsEnabled = enabled;
        this.save();
    }

    public boolean isErrorToastsEnabled() {
        return this.errorToastsEnabled;
    }

    public void setErrorToastsEnabled(boolean enabled) {
        this.errorToastsEnabled = enabled;
        this.save();
    }

    public boolean isInfoToastsEnabled() {
        return this.infoToastsEnabled;
    }

    public void setInfoToastsEnabled(boolean enabled) {
        this.infoToastsEnabled = enabled;
        this.save();
    }

    public boolean isWarningToastsEnabled() {
        return this.warningToastsEnabled;
    }

    public void setWarningToastsEnabled(boolean enabled) {
        this.warningToastsEnabled = enabled;
        this.save();
    }

    public String getSortOption() {
        return this.sortOption;
    }

    public void setSortOption(String sortOption) {
        this.sortOption = sortOption;
        this.save();
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        this.save();
    }

    public String getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(String tagFilter) {
        this.tagFilter = tagFilter != null ? tagFilter : "";
        this.save();
    }

    public String getExcludedVendors() {
        return this.excludedVendors;
    }

    public void setExcludedVendors(String excludedVendors) {
        this.excludedVendors = excludedVendors != null ? excludedVendors : "";
        this.save();
    }

    public int getDismissedModMessageId() {
        return this.dismissedModMessageId;
    }

    public void setDismissedModMessageId(int messageId) {
        this.dismissedModMessageId = messageId;
        this.save();
    }

    private File getConfigFile() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        return configDir.resolve(CONFIG_FILE).toFile();
    }

    private void load() {
        File configFile = this.getConfigFile();
        if (!configFile.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            if (json != null && json.has("downloadPath")) {
                this.downloadPath = json.get("downloadPath").getAsString();
            }
            if (json != null && json.has("successToastsEnabled")) {
                this.successToastsEnabled = json.get("successToastsEnabled").getAsBoolean();
            }
            if (json != null && json.has("errorToastsEnabled")) {
                this.errorToastsEnabled = json.get("errorToastsEnabled").getAsBoolean();
            }
            if (json != null && json.has("infoToastsEnabled")) {
                this.infoToastsEnabled = json.get("infoToastsEnabled").getAsBoolean();
            }
            if (json != null && json.has("warningToastsEnabled")) {
                this.warningToastsEnabled = json.get("warningToastsEnabled").getAsBoolean();
            }
            if (json != null && json.has("sortOption")) {
                this.sortOption = json.get("sortOption").getAsString();
            }
            if (json != null && json.has("itemsPerPage")) {
                this.itemsPerPage = json.get("itemsPerPage").getAsInt();
            }
            if (json != null && json.has("tagFilter")) {
                this.tagFilter = json.get("tagFilter").getAsString();
            }
            if (json != null && json.has("excludedVendors")) {
                this.excludedVendors = json.get("excludedVendors").getAsString();
            }
            if (json != null && json.has("dismissedModMessageId")) {
                this.dismissedModMessageId = json.get("dismissedModMessageId").getAsInt();
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load download settings: " + e.getMessage());
        }
    }

    private void save() {
        File configFile = this.getConfigFile();
        try {
            File parentDir = configFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            JsonObject json = new JsonObject();
            json.addProperty("downloadPath", this.downloadPath);
            json.addProperty("successToastsEnabled", Boolean.valueOf(this.successToastsEnabled));
            json.addProperty("errorToastsEnabled", Boolean.valueOf(this.errorToastsEnabled));
            json.addProperty("infoToastsEnabled", Boolean.valueOf(this.infoToastsEnabled));
            json.addProperty("warningToastsEnabled", Boolean.valueOf(this.warningToastsEnabled));
            json.addProperty("sortOption", this.sortOption);
            json.addProperty("itemsPerPage", (Number)this.itemsPerPage);
            json.addProperty("tagFilter", this.tagFilter);
            json.addProperty("excludedVendors", this.excludedVendors);
            json.addProperty("dismissedModMessageId", (Number)this.dismissedModMessageId);
            try (FileWriter writer = new FileWriter(configFile);){
                this.gson.toJson((JsonElement)json, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to save download settings: " + e.getMessage());
        }
    }
}

