/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;

@Environment(value=EnvType.CLIENT)
public class ToastManager {
    private static final List<Toast> toasts = new ArrayList<Toast>();
    private static final int TOAST_DURATION = 3000;
    private static final int TOAST_HEIGHT = 20;
    private static final int TOAST_MARGIN = 10;

    public static void addToast(String message, boolean isError) {
        toasts.add(new Toast(message, isError, System.currentTimeMillis()));
    }

    public static void render(class_332 context, int screenWidth) {
        long currentTime = System.currentTimeMillis();
        Iterator<Toast> iterator = toasts.iterator();
        context.method_51448().method_22903();
        context.method_51448().method_22904(0.0, 0.0, 1000.0);
        int y = 10;
        while (iterator.hasNext()) {
            Toast toast = iterator.next();
            if (currentTime - toast.creationTime > 3000L) {
                iterator.remove();
                continue;
            }
            float alpha = 1.0f;
            long age = currentTime - toast.creationTime;
            if (age > 2500L) {
                alpha = (float)(3000L - age) / 500.0f;
            }
            int width = class_310.method_1551().field_1772.method_1727(toast.message) + 20;
            int x = screenWidth - width - 10;
            int bgColor = toast.isError ? -65536 : -16733696;
            context.method_25294(x, y, x + width, y + 20, bgColor);
            context.method_27535(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)toast.message), x + 10, y + 5, -1);
            y += 25;
        }
        context.method_51448().method_22909();
    }

    @Environment(value=EnvType.CLIENT)
    private static class Toast {
        final String message;
        final boolean isError;
        final long creationTime;

        Toast(String message, boolean isError, long creationTime) {
            this.message = message;
            this.isError = isError;
            this.creationTime = creationTime;
        }
    }
}

