/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.gui.ConfirmationCreateFolderScreen;
import com.choculaterie.gui.ConfirmationDeleteScreen;
import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.RenameItemSceen;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.networking.LitematicHttpClient;
import java.awt.Desktop;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class FileManagerScreen
extends class_437 {
    private final class_437 parentScreen;
    private List<File> displayedFiles = new ArrayList<File>();
    private int scrollOffset = 0;
    private final int itemHeight = 24;
    private final int maxVisibleItems;
    private String schematicsRootPath;
    private File currentDirectory;
    private List<String> breadcrumbParts = new ArrayList<String>();
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private File draggedFile = null;
    private boolean isDragging = false;
    private int dragStartX;
    private int dragStartY;
    private int dragCurrentX;
    private int dragCurrentY;
    private File dropTargetFolder = null;
    private class_342 searchField;
    private String searchTerm = "";
    private List<File> allFiles = new ArrayList<File>();
    private boolean isRecursiveSearch = false;
    private Map<File, String> filePathMap = new HashMap<File, String>();
    private Set<File> filesBeingUploaded = new HashSet<File>();
    private List<BreadcrumbItem> breadcrumbItems = new ArrayList<BreadcrumbItem>();

    public FileManagerScreen(class_437 parentScreen) {
        super((class_2561)class_2561.method_43470((String)""));
        this.parentScreen = parentScreen;
        this.maxVisibleItems = (class_310.method_1551().method_22683().method_4502() - 100) / 24;
        this.initializeRootPath();
    }

    private void initializeRootPath() {
        try {
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                this.schematicsRootPath = new File(gameDir, "schematics").getAbsolutePath();
            } else {
                boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
                String homeDir = System.getProperty("user.home");
                this.schematicsRootPath = isDevelopment ? homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "schematics" : homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "schematics";
            }
            File directory = new File(this.schematicsRootPath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            this.currentDirectory = directory;
            this.updateBreadcrumbs();
            this.loadFilesFromCurrentDirectory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFilesFromCurrentDirectory() {
        try {
            this.allFiles.clear();
            this.displayedFiles.clear();
            File[] files = this.currentDirectory.listFiles();
            if (files != null) {
                Arrays.sort(files, (f1, f2) -> {
                    if (f1.isDirectory() && !f2.isDirectory()) {
                        return -1;
                    }
                    if (!f1.isDirectory() && f2.isDirectory()) {
                        return 1;
                    }
                    return f1.getName().compareToIgnoreCase(f2.getName());
                });
                for (File file : files) {
                    this.allFiles.add(file);
                }
            }
            this.filterFiles();
            if (this.searchTerm.isEmpty()) {
                this.isRecursiveSearch = false;
            }
            this.scrollOffset = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filterFiles() {
        this.displayedFiles.clear();
        this.filePathMap.clear();
        if (this.isRecursiveSearch && !this.searchTerm.isEmpty()) {
            ArrayList<File> searchResults = new ArrayList<File>();
            this.searchAllFiles(new File(this.schematicsRootPath), searchResults, "");
            this.displayedFiles.addAll(searchResults);
        } else {
            for (File file : this.allFiles) {
                if (!this.searchTerm.isEmpty() && !file.getName().toLowerCase().contains(this.searchTerm)) continue;
                this.displayedFiles.add(file);
            }
        }
        this.displayedFiles.sort((f1, f2) -> {
            if (f1.isDirectory() && !f2.isDirectory()) {
                return -1;
            }
            if (!f1.isDirectory() && f2.isDirectory()) {
                return 1;
            }
            return f1.getName().compareToIgnoreCase(f2.getName());
        });
    }

    private void updateBreadcrumbs() {
        this.breadcrumbParts.clear();
        this.breadcrumbItems.clear();
        this.breadcrumbParts.add("schematics");
        this.breadcrumbItems.add(new BreadcrumbItem("schematics", new File(this.schematicsRootPath)));
        if (this.currentDirectory.getAbsolutePath().equals(this.schematicsRootPath)) {
            return;
        }
        String relativePath = this.currentDirectory.getAbsolutePath().substring(this.schematicsRootPath.length());
        if (relativePath.startsWith(File.separator)) {
            relativePath = relativePath.substring(1);
        }
        if (!relativePath.isEmpty()) {
            String[] parts = relativePath.split(File.separator.replace("\\", "\\\\"));
            StringBuilder pathBuilder = new StringBuilder(this.schematicsRootPath);
            for (String part : parts) {
                if (part.isEmpty()) continue;
                this.breadcrumbParts.add(part);
                pathBuilder.append(File.separator).append(part);
                this.breadcrumbItems.add(new BreadcrumbItem(part, new File(pathBuilder.toString())));
            }
        }
    }

    private void navigateToFolder(File folder) {
        if (folder.isDirectory() && folder.exists()) {
            this.currentDirectory = folder;
            this.updateBreadcrumbs();
            this.loadFilesFromCurrentDirectory();
            this.updateScrollbarDimensions();
        }
    }

    private void navigateUp() {
        File parent = this.currentDirectory.getParentFile();
        if (parent != null && this.currentDirectory.getAbsolutePath().startsWith(this.schematicsRootPath)) {
            if (parent.getAbsolutePath().startsWith(this.schematicsRootPath)) {
                this.navigateToFolder(parent);
            } else {
                this.navigateToFolder(new File(this.schematicsRootPath));
            }
        }
    }

    private void navigateToBreadcrumb(int index) {
        if (index < 0 || index >= this.breadcrumbParts.size()) {
            return;
        }
        StringBuilder path = new StringBuilder(this.schematicsRootPath);
        for (int i = 1; i <= index; ++i) {
            path.append(File.separator).append(this.breadcrumbParts.get(i));
        }
        this.navigateToFolder(new File(path.toString()));
    }

    protected void method_25426() {
        int buttonWidth = 20;
        int buttonHeight = 20;
        int backButtonX = 10;
        int backButtonY = 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(backButtonX, backButtonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), button -> {
            this.loadFilesFromCurrentDirectory();
            this.updateScrollbarDimensions();
        }).method_46434(this.field_22789 - 40, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2191"), button -> this.navigateUp()).method_46434(this.field_22789 - 65, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1+"), button -> this.showCreateFolderScreen()).method_46434(this.field_22789 - 90, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc2"), button -> this.openFolderInOS(this.currentDirectory)).method_46434(this.field_22789 - 115, 10, 20, 20).method_46431());
        int searchFieldWidth = 200;
        this.searchField = new class_342(this.field_22793, (this.field_22789 - searchFieldWidth) / 2, 10, searchFieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_1880(50);
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search files..."));
        this.searchField.method_1852(this.searchTerm);
        this.searchField.method_1863(this::onSearchChanged);
        this.method_25429((class_364)this.searchField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> {
            this.searchField.method_1852("");
            this.onSearchChanged("");
        }).method_46434((this.field_22789 + searchFieldWidth) / 2 + 5, 10, 20, 20).method_46431());
        this.updateScrollbarDimensions();
    }

    private void onSearchChanged(String newSearchTerm) {
        this.searchTerm = newSearchTerm.toLowerCase().trim();
        if (this.searchTerm.isEmpty()) {
            this.isRecursiveSearch = false;
            this.loadFilesFromCurrentDirectory();
        } else {
            this.isRecursiveSearch = true;
            this.filterFiles();
        }
        this.scrollOffset = 0;
        this.updateScrollbarDimensions();
    }

    private void searchAllFiles(File directory, List<File> results, String relativePath) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                String currentPath;
                String string = currentPath = relativePath.isEmpty() ? file.getName() : relativePath + "/" + file.getName();
                if (file.isDirectory()) {
                    this.searchAllFiles(file, results, currentPath);
                    continue;
                }
                if (!file.isFile() || !file.getName().toLowerCase().contains(this.searchTerm)) continue;
                results.add(file);
                String filePath = "schematics/" + relativePath;
                this.filePathMap.put(file, filePath);
            }
        }
    }

    private void openFolderInOS(File folder) {
        try {
            if (folder.exists()) {
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    Desktop.getDesktop().open(folder);
                } else {
                    String os = System.getProperty("os.name").toLowerCase();
                    ProcessBuilder builder = new ProcessBuilder(new String[0]);
                    if (os.contains("win")) {
                        builder.command("explorer.exe", folder.getAbsolutePath());
                    } else if (os.contains("mac") || os.contains("darwin")) {
                        builder.command("open", folder.getAbsolutePath());
                    } else if (os.contains("nix") || os.contains("nux")) {
                        builder.command("xdg-open", folder.getAbsolutePath());
                    } else {
                        System.out.println("Cannot open folder: Unsupported OS");
                        return;
                    }
                    builder.start();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showCreateFolderScreen() {
        class_310.method_1551().method_1507((class_437)new ConfirmationCreateFolderScreen(this, this.currentDirectory, success -> {
            if (success.booleanValue()) {
                this.loadFilesFromCurrentDirectory();
                this.updateScrollbarDimensions();
            }
        }));
    }

    private void startRenaming(File file) {
        class_310.method_1551().method_1507((class_437)new RenameItemSceen(this, file, success -> {
            if (success.booleanValue()) {
                this.loadFilesFromCurrentDirectory();
                this.updateScrollbarDimensions();
            }
        }));
    }

    private void updateScrollbarDimensions() {
        int contentWidth = Math.min(600, this.field_22789 - 80);
        this.scrollAreaX = (this.field_22789 - contentWidth) / 2;
        this.scrollAreaY = 60;
        this.scrollAreaWidth = contentWidth;
        this.scrollAreaHeight = this.field_22790 - this.scrollAreaY - 10;
        this.totalContentHeight = this.displayedFiles.size() * 24;
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.min(this.scrollOffset, this.totalContentHeight - this.scrollAreaHeight);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), this.searchField.method_46426() - 15, this.searchField.method_46427() + 5, 0xAAAAAA);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        int breadcrumbY = 40;
        int pathColor = 0xCCCCCC;
        int separatorColor = 0x999999;
        int totalBreadcrumbWidth = 0;
        for (int i = 0; i < this.breadcrumbParts.size(); ++i) {
            totalBreadcrumbWidth += this.field_22793.method_1727(this.breadcrumbParts.get(i));
            if (i >= this.breadcrumbParts.size() - 1) continue;
            totalBreadcrumbWidth += this.field_22793.method_1727(" > ");
        }
        int breadcrumbX = (this.field_22789 - totalBreadcrumbWidth) / 2;
        for (int i = 0; i < this.breadcrumbParts.size(); ++i) {
            String part = this.breadcrumbParts.get(i);
            boolean isClickable = true;
            BreadcrumbItem item = this.breadcrumbItems.get(i);
            item.x = breadcrumbX;
            item.width = this.field_22793.method_1727(part);
            int color = isClickable ? pathColor : separatorColor;
            boolean isHovering = false;
            if (isClickable) {
                int textWidth = item.width;
                isHovering = mouseX >= breadcrumbX && mouseX <= breadcrumbX + textWidth && mouseY >= breadcrumbY && mouseY <= breadcrumbY + 10;
                int n = color = isHovering ? 0xFFFFFF : pathColor;
                if (this.isDragging && this.draggedFile != null && mouseX >= breadcrumbX && mouseX <= breadcrumbX + textWidth && mouseY >= breadcrumbY - 5 && mouseY <= breadcrumbY + 15) {
                    context.method_25294(breadcrumbX - 2, breadcrumbY - 2, breadcrumbX + textWidth + 2, breadcrumbY + 12, 0x3300FF00);
                }
            }
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)part), breadcrumbX, breadcrumbY, color);
            breadcrumbX += item.width;
            if (i >= this.breadcrumbParts.size() - 1) continue;
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)" > "), breadcrumbX, breadcrumbY, separatorColor);
            breadcrumbX += this.field_22793.method_1727(" > ");
        }
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        if (this.displayedFiles.isEmpty()) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No files found"), this.field_22789 / 2, this.scrollAreaY + 20, 0xCCCCCC);
        } else {
            int y = this.scrollAreaY - this.scrollOffset;
            for (int i = 0; i < this.displayedFiles.size(); ++i) {
                boolean hasPath;
                File file = this.displayedFiles.get(i);
                int currentItemHeight = 24;
                boolean bl = hasPath = this.isRecursiveSearch && this.filePathMap.containsKey(file) && !this.filePathMap.get(file).isEmpty();
                if (hasPath) {
                    currentItemHeight = 34;
                }
                if (y + currentItemHeight >= this.scrollAreaY && y <= this.scrollAreaY + this.scrollAreaHeight) {
                    String icon = file.isDirectory() ? "\ud83d\udcc1 " : "\ud83d\udcc4 ";
                    context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)(icon + file.getName())), this.scrollAreaX + 10, y + 4, 0xFFFFFF);
                    if (hasPath) {
                        String path = this.filePathMap.get(file);
                        String pathText = "\ud83d\udcc2 " + path;
                        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)pathText), this.scrollAreaX + 10, y + 16, 0xAAAAAA);
                    }
                    if (!file.isDirectory()) {
                        long fileSizeKB = file.length() / 1024L;
                        String sizeText = fileSizeKB + " KB";
                        int sizeWidth = this.field_22793.method_1727(sizeText);
                        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)sizeText), this.scrollAreaX + this.scrollAreaWidth - sizeWidth - 35, y + 4, 0xCCCCCC);
                    }
                    int deleteX = this.scrollAreaX + this.scrollAreaWidth - 15;
                    int deleteY = y + 5;
                    boolean isDeleteHovered = mouseX >= deleteX - 2 && mouseX <= deleteX + 8 && mouseY >= deleteY && mouseY <= deleteY + 10;
                    int deleteColor = isDeleteHovered ? 0xFF5555 : 0xAA5555;
                    context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2715"), deleteX, deleteY - 1, deleteColor);
                    if (file.getName().toLowerCase().endsWith(".litematic")) {
                        int uploadX = this.scrollAreaX + this.scrollAreaWidth - 29;
                        int uploadY = y + 5;
                        boolean isUploadHovered = mouseX >= uploadX - 2 && mouseX <= uploadX + 12 && mouseY >= uploadY && mouseY <= uploadY + 10;
                        String uploadIcon = this.filesBeingUploaded.contains(file) ? "\u23f3" : "\ud83d\udce4";
                        int uploadColor = isUploadHovered ? 0x55AAFF : 0x5555AA;
                        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)uploadIcon), uploadX, uploadY - 1, uploadColor);
                    }
                    int separatorY = y + currentItemHeight - 5;
                    context.method_25294(this.scrollAreaX, separatorY, this.scrollAreaX + this.scrollAreaWidth - 10, separatorY + 1, 0x22FFFFFF);
                }
                y += currentItemHeight;
            }
            if (this.isDragging && this.draggedFile != null) {
                int targetIndex;
                if (this.dropTargetFolder != null && (targetIndex = this.displayedFiles.indexOf(this.dropTargetFolder)) >= 0) {
                    int targetY = this.scrollAreaY - this.scrollOffset + targetIndex * 24;
                    context.method_25294(this.scrollAreaX, targetY, this.scrollAreaX + this.scrollAreaWidth - 8, targetY + 24 - 5, 0x3300FF00);
                }
                String dragText = (this.draggedFile.isDirectory() ? "\ud83d\udcc1 " : "\ud83d\udcc4 ") + this.draggedFile.getName();
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)dragText), this.dragCurrentX + 10, this.dragCurrentY - 5, 0xFFFFFF);
            }
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        ToastManager.render(context, this.field_22789);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int index;
        int i;
        if (this.searchField.method_25370() && (mouseX < (double)this.searchField.method_46426() || mouseX > (double)(this.searchField.method_46426() + this.searchField.method_25368()) || mouseY < (double)this.searchField.method_46427() || mouseY > (double)(this.searchField.method_46427() + this.searchField.method_25364()))) {
            this.searchField.method_25365(false);
        }
        if (button == 0 && mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
            int y = this.scrollAreaY - this.scrollOffset;
            for (i = 0; i < this.displayedFiles.size(); ++i) {
                boolean hasPath;
                File file = this.displayedFiles.get(i);
                int currentItemHeight = 24;
                boolean bl = hasPath = this.isRecursiveSearch && this.filePathMap.containsKey(file) && !this.filePathMap.get(file).isEmpty();
                if (hasPath) {
                    currentItemHeight = 34;
                }
                if (mouseY >= (double)y && mouseY < (double)(y + currentItemHeight)) {
                    if (file.getName().toLowerCase().endsWith(".litematic")) {
                        int uploadX = this.scrollAreaX + this.scrollAreaWidth - 28;
                        int uploadY = y + 5;
                        if (mouseX >= (double)(uploadX - 2) && mouseX <= (double)(uploadX + 12) && mouseY >= (double)uploadY && mouseY <= (double)(uploadY + 10)) {
                            if (!this.filesBeingUploaded.contains(file)) {
                                this.uploadLitematicFile(file);
                            }
                            return true;
                        }
                    }
                    int deleteX = this.scrollAreaX + this.scrollAreaWidth - 15;
                    int deleteY = y + 5;
                    if (mouseX >= (double)(deleteX - 2) && mouseX <= (double)(deleteX + 8) && mouseY >= (double)deleteY && mouseY <= (double)(deleteY + 10)) {
                        this.handleDeleteRequest(file);
                        return true;
                    }
                    if (file.isDirectory()) {
                        this.navigateToFolder(file);
                    }
                    return true;
                }
                y += currentItemHeight;
            }
        }
        if (button == 1 && mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && (index = (int)((mouseY - (double)this.scrollAreaY + (double)this.scrollOffset) / 24.0)) >= 0 && index < this.displayedFiles.size()) {
            File clickedFile = this.displayedFiles.get(index);
            this.startRenaming(clickedFile);
            return true;
        }
        if (button == 0 && mouseY >= 40.0 && mouseY <= 50.0) {
            int totalBreadcrumbWidth = 0;
            for (i = 0; i < this.breadcrumbParts.size(); ++i) {
                totalBreadcrumbWidth += this.field_22793.method_1727(this.breadcrumbParts.get(i));
                if (i >= this.breadcrumbParts.size() - 1) continue;
                totalBreadcrumbWidth += this.field_22793.method_1727(" > ");
            }
            int x = (this.field_22789 - totalBreadcrumbWidth) / 2;
            for (int i2 = 0; i2 < this.breadcrumbParts.size(); ++i2) {
                String part = this.breadcrumbParts.get(i2);
                int textWidth = this.field_22793.method_1727(part);
                if (mouseX >= (double)x && mouseX <= (double)(x + textWidth)) {
                    this.navigateToBreadcrumb(i2);
                    return true;
                }
                x += textWidth;
                if (i2 >= this.breadcrumbParts.size() - 1) continue;
                x += this.field_22793.method_1727(" > ");
            }
        }
        if (button == 0 && mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && (index = (int)((mouseY - (double)this.scrollAreaY + (double)this.scrollOffset) / 24.0)) >= 0 && index < this.displayedFiles.size()) {
            File clickedFile = this.displayedFiles.get(index);
            int deleteX = this.scrollAreaX + this.scrollAreaWidth - 15;
            int lineY = this.scrollAreaY - this.scrollOffset + index * 24;
            if (mouseX >= (double)(deleteX - 2) && mouseX <= (double)(deleteX + 8) && mouseY >= (double)lineY && mouseY <= (double)(lineY + 10)) {
                this.handleDeleteRequest(clickedFile);
                return true;
            }
            if (clickedFile.getName().toLowerCase().endsWith(".litematic")) {
                int uploadX = this.scrollAreaX + this.scrollAreaWidth - 40;
                int uploadY = lineY + 5;
                if (mouseX >= (double)(uploadX - 2) && mouseX <= (double)(uploadX + 12) && mouseY >= (double)uploadY && mouseY <= (double)(uploadY + 10)) {
                    if (!this.filesBeingUploaded.contains(clickedFile)) {
                        this.uploadLitematicFile(clickedFile);
                    }
                    return true;
                }
            }
            if (clickedFile.isDirectory()) {
                this.navigateToFolder(clickedFile);
                return true;
            }
            if (this.isRecursiveSearch && this.filePathMap.containsKey(clickedFile)) {
                this.navigateToFolder(clickedFile.getParentFile());
                return true;
            }
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void uploadLitematicFile(final File file) {
        this.filesBeingUploaded.add(file);
        LitematicHttpClient.uploadLitematicFile(file, new LitematicHttpClient.UploadCallback(){

            @Override
            public void onSuccess(String url) {
                ToastManager.addToast("URL copied to clipboard!", false);
                FileManagerScreen.this.filesBeingUploaded.remove(file);
            }

            @Override
            public void onError(String message) {
                ToastManager.addToast(message, true);
                FileManagerScreen.this.filesBeingUploaded.remove(file);
            }
        });
    }

    private void handleDeleteRequest(File fileToDelete) {
        if (fileToDelete.isDirectory()) {
            this.showCascadeDeleteConfirmation(fileToDelete);
        } else {
            class_310.method_1551().method_1507((class_437)new ConfirmationScreen((class_2561)class_2561.method_43470((String)"Confirm Delete"), (class_2561)class_2561.method_43470((String)("Are you sure you want to delete " + fileToDelete.getName() + "?")), confirmed -> {
                boolean success;
                if (confirmed.booleanValue() && (success = this.deleteFile(fileToDelete))) {
                    this.loadFilesFromCurrentDirectory();
                    this.updateScrollbarDimensions();
                }
                class_310.method_1551().method_1507((class_437)this);
            }));
        }
    }

    private void showCascadeDeleteConfirmation(File directory) {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        this.collectFilesToDelete(directory, filesToDelete);
        class_310.method_1551().method_1507((class_437)new ConfirmationDeleteScreen(directory.getName(), filesToDelete, confirmed -> {
            if (confirmed.booleanValue()) {
                boolean allDeleted = true;
                for (int i = filesToDelete.size() - 1; i >= 0; --i) {
                    boolean success = this.deleteFile((File)filesToDelete.get(i));
                    if (success) continue;
                    allDeleted = false;
                }
                this.loadFilesFromCurrentDirectory();
                this.updateScrollbarDimensions();
            }
            class_310.method_1551().method_1507((class_437)this);
        }));
    }

    private void collectFilesToDelete(File root, List<File> filesToDelete) {
        File[] files;
        if (root.isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                this.collectFilesToDelete(file, filesToDelete);
            }
        }
        filesToDelete.add(root);
    }

    private boolean deleteFile(File file) {
        try {
            File[] contents;
            if (file.isDirectory() && (contents = file.listFiles()) != null && contents.length > 0) {
                for (File f : contents) {
                    this.deleteFile(f);
                }
            }
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            if (mouseY != (double)this.lastMouseY) {
                float dragPercentage = (float)(mouseY - (double)this.lastMouseY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
                int scrollAmount = (int)(dragPercentage * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
                this.lastMouseY = (int)mouseY;
            }
            return true;
        }
        if (this.isDragging && this.draggedFile != null) {
            this.dragCurrentX = (int)mouseX;
            this.dragCurrentY = (int)mouseY;
            this.dropTargetFolder = this.findDropTarget((int)mouseX, (int)mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        if (button == 0 && this.isDragging && this.draggedFile != null) {
            File targetFolder = this.findDropTarget((int)mouseX, (int)mouseY);
            if (targetFolder != null && targetFolder.isDirectory() && !this.isSubdirectory(targetFolder, this.draggedFile)) {
                this.moveFile(this.draggedFile, targetFolder);
            } else {
                this.loadFilesFromCurrentDirectory();
                this.updateScrollbarDimensions();
            }
            this.isDragging = false;
            this.draggedFile = null;
            this.dropTargetFolder = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private File findDropTarget(int mouseX, int mouseY) {
        File potentialTarget;
        int index;
        int breadcrumbY = 40;
        for (BreadcrumbItem item : this.breadcrumbItems) {
            if (mouseX < item.x || mouseX > item.x + item.width || mouseY < breadcrumbY - 5 || mouseY > breadcrumbY + 15) continue;
            return item.directory;
        }
        if (mouseX >= this.scrollAreaX && mouseX <= this.scrollAreaX + this.scrollAreaWidth && mouseY >= this.scrollAreaY && mouseY <= this.scrollAreaY + this.scrollAreaHeight && (index = (mouseY - this.scrollAreaY + this.scrollOffset) / 24) >= 0 && index < this.displayedFiles.size() && (potentialTarget = this.displayedFiles.get(index)).isDirectory() && !potentialTarget.equals(this.draggedFile)) {
            return potentialTarget;
        }
        return null;
    }

    private boolean isSubdirectory(File potentialParent, File potentialChild) {
        if (potentialChild.isDirectory()) {
            File parent = potentialChild;
            while ((parent = parent.getParentFile()) != null) {
                if (!parent.equals(potentialParent)) continue;
                return true;
            }
        }
        return false;
    }

    private void moveFile(File sourceFile, File targetFolder) {
        try {
            File destFile = new File(targetFolder, sourceFile.getName());
            if (sourceFile.getParentFile().equals(targetFolder)) {
                return;
            }
            if (destFile.exists()) {
                return;
            }
            this.performMove(sourceFile, destFile);
            this.loadFilesFromCurrentDirectory();
            this.updateScrollbarDimensions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.loadFilesFromCurrentDirectory();
            this.updateScrollbarDimensions();
        }
    }

    private boolean performMove(File sourceFile, File destFile) {
        try {
            boolean success = false;
            success = sourceFile.isDirectory() ? sourceFile.renameTo(destFile) : sourceFile.renameTo(destFile);
            return success;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
            if (this.totalContentHeight > this.scrollAreaHeight) {
                int scrollAmount = (int)(-verticalAmount * 20.0);
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
                return true;
            }
        } else if (this.searchField.method_1885() && !this.searchField.method_25370() && mouseX >= (double)this.searchField.method_46426() && mouseX <= (double)(this.searchField.method_46426() + this.searchField.method_25368()) && mouseY >= (double)this.searchField.method_46427() && mouseY <= (double)(this.searchField.method_46427() + this.searchField.method_25364()) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(-verticalAmount * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    @Environment(value=EnvType.CLIENT)
    private static class BreadcrumbItem {
        final String name;
        final File directory;
        int x;
        int width;

        BreadcrumbItem(String name, File directory) {
            this.name = name;
            this.directory = directory;
        }
    }
}

