/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.networking;

import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class LitematicHttpClient {
    private static final String API_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetAll";
    private static final Gson gson = new Gson();
    private static final HttpClient client;

    public static List<SchematicInfo> fetchSchematicList() {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematics: " + response.statusCode());
            }
            JsonArray jsonArray = (JsonArray)gson.fromJson(response.body(), JsonArray.class);
            ArrayList<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject json = jsonArray.get(i).getAsJsonObject();
                SchematicInfo schematic = new SchematicInfo(json.get("id").getAsString(), json.get("name").getAsString(), json.get("description").isJsonNull() ? "" : json.get("description").getAsString(), json.get("viewCount").getAsInt(), json.get("downloadCount").getAsInt(), json.get("username").getAsString());
                schematics.add(schematic);
            }
            return schematics;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<SchematicInfo>();
        }
    }

    public static SchematicDetailInfo fetchSchematicDetail(String id) {
        try {
            String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/Getbyid/" + id;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic details: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            return new SchematicDetailInfo(json.get("id").getAsString(), json.get("name").getAsString(), json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.get("viewCount").getAsInt(), json.get("downloadCount").getAsInt(), json.has("coverPicture") && !json.get("coverPicture").isJsonNull() ? json.get("coverPicture").getAsString() : "", json.get("username").getAsString(), json.get("publishDate").getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to fetch schematic detail", e);
        }
    }

    public static String downloadSchematic(String base64Data, String fileName) {
        try {
            String savePath;
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                savePath = new File(gameDir, "schematics").getAbsolutePath() + File.separator;
            } else {
                boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
                String homeDir = System.getProperty("user.home");
                savePath = isDevelopment ? homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "schematics" + File.separator : homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "schematics" + File.separator;
            }
            File directory = new File(savePath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String filePath = savePath + fileName + ".litematic";
            byte[] decodedData = Base64.getDecoder().decode(base64Data);
            try (FileOutputStream fos = new FileOutputStream(filePath);){
                fos.write(decodedData);
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static String fetchAndDownloadSchematic(String id, String fileName) {
        try {
            String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetLitematicFiles/" + id;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic file: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            if (json.has("files") && json.getAsJsonArray("files").size() > 0) {
                String base64Data = json.getAsJsonArray("files").get(0).getAsString();
                return LitematicHttpClient.downloadSchematic(base64Data, fileName);
            }
            throw new RuntimeException("No schematic file found");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static void uploadLitematicFile(File file, UploadCallback callback) {
        new Thread(() -> {
            try {
                String boundary = "Boundary-" + System.currentTimeMillis();
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(("--" + boundary + "\r\n").getBytes());
                baos.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
                baos.write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
                baos.write(fileBytes);
                baos.write("\r\n".getBytes());
                baos.write(("--" + boundary + "--\r\n").getBytes());
                byte[] requestBody = baos.toByteArray();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/upload")).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                    String fileUrl = json.get("fileUrl").getAsString();
                    String viewerUrl = json.get("viewerUrl").getAsString();
                    class_310.method_1551().execute(() -> {
                        class_310.method_1551().field_1774.method_1455(viewerUrl);
                        callback.onSuccess(viewerUrl);
                    });
                } else {
                    class_310.method_1551().execute(() -> callback.onError("Upload failed: " + response.statusCode() + " " + (String)response.body()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                class_310.method_1551().execute(() -> callback.onError("Upload failed: " + e.getMessage()));
            }
        }).start();
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            client = HttpClient.newBuilder().sslContext(sslContext).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize HttpClient with custom SSL context", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface UploadCallback {
        public void onSuccess(String var1);

        public void onError(String var1);
    }
}

