/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.DetailScreen;
import com.choculaterie.gui.FileManagerScreen;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.SchematicInfo;
import com.choculaterie.networking.LitematicHttpClient;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class LitematicDownloaderScreen
extends class_437 {
    private List<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
    private List<SchematicInfo> filteredSchematics = new ArrayList<SchematicInfo>();
    private class_342 searchField;
    private String searchTerm = "";
    private int scrollOffset = 0;
    private final int itemHeight = 40;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private int scrollDragOffset = 0;
    private String statusMessage = null;
    private int statusColor = 0xFFFFFF;
    private long statusMessageDisplayTime = 0L;
    private static final long STATUS_MESSAGE_DURATION = 3000L;
    private int lastClickedIndex = -1;
    private long lastClickTime = 0L;
    private boolean isLoading = false;
    private long loadingStartTime = 0L;

    public LitematicDownloaderScreen() {
        super((class_2561)class_2561.method_43470((String)""));
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), button -> class_310.method_1551().method_1507((class_437)new FileManagerScreen(this))).method_46434(this.field_22789 - 65, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), button -> this.loadSchematics()).method_46434(this.field_22789 - 40, 10, 20, 20).method_46431());
        int contentWidth = Math.min(600, this.field_22789 - 80);
        this.scrollAreaX = (this.field_22789 - contentWidth) / 2;
        this.scrollAreaY = 35;
        this.scrollAreaWidth = contentWidth;
        this.scrollAreaHeight = this.field_22790 - this.scrollAreaY - 10;
        int searchFieldWidth = 200;
        this.searchField = new class_342(this.field_22793, (this.field_22789 - searchFieldWidth) / 2, 10, searchFieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_1880(50);
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_1863(this::onSearchChanged);
        this.method_25429((class_364)this.searchField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> {
            this.searchField.method_1852("");
            this.onSearchChanged("");
        }).method_46434((this.field_22789 + searchFieldWidth) / 2 + 5, 10, 20, 20).method_46431());
        this.updateScrollbarDimensions();
        this.loadSchematics();
    }

    private void onSearchChanged(String searchText) {
        this.searchTerm = searchText.toLowerCase();
        this.filterSchematics();
        this.scrollOffset = 0;
        this.updateScrollbarDimensions();
    }

    private void filterSchematics() {
        if (this.searchTerm.isEmpty()) {
            this.filteredSchematics = new ArrayList<SchematicInfo>(this.schematics);
            return;
        }
        this.filteredSchematics = this.schematics.stream().filter(schematic -> schematic.getName().toLowerCase().contains(this.searchTerm) || schematic.getDescription().toLowerCase().contains(this.searchTerm) || schematic.getUsername().toLowerCase().contains(this.searchTerm)).toList();
    }

    private void updateScrollbarDimensions() {
        this.totalContentHeight = this.filteredSchematics.size() * 40;
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.min(this.scrollOffset, this.totalContentHeight - this.scrollAreaHeight);
    }

    private void loadSchematics() {
        this.schematics = new ArrayList<SchematicInfo>();
        this.filteredSchematics = new ArrayList<SchematicInfo>();
        this.updateScrollbarDimensions();
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        new Thread(() -> {
            List<SchematicInfo> loadedSchematics = LitematicHttpClient.fetchSchematicList();
            class_310.method_1551().execute(() -> {
                this.schematics = loadedSchematics;
                this.filterSchematics();
                this.updateScrollbarDimensions();
                this.isLoading = false;
            });
        }).start();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2 - this.searchField.method_25368() / 4, 10, 0xFFFFFF);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), this.searchField.method_46426() - 15, this.searchField.method_46427() + 5, 0xAAAAAA);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        if (this.filteredSchematics.isEmpty()) {
            if (this.isLoading) {
                int centerY = this.scrollAreaY + this.scrollAreaHeight / 2;
                this.drawLoadingAnimation(context, this.field_22789 / 2, centerY - 15);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), this.field_22789 / 2, centerY + 15, 0xCCCCCC);
            } else if (this.schematics.isEmpty()) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No schematics found"), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, 0xCCCCCC);
            } else {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No matches found"), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, 0xCCCCCC);
            }
        } else {
            int y = this.scrollAreaY - this.scrollOffset;
            for (int i = 0; i < this.filteredSchematics.size(); ++i) {
                SchematicInfo schematic = this.filteredSchematics.get(i);
                if (y + 40 >= this.scrollAreaY && y <= this.scrollAreaY + this.scrollAreaHeight) {
                    this.renderSchematicItem(context, schematic, this.scrollAreaX, y, this.scrollAreaWidth, mouseX, mouseY, i);
                    context.method_25294(this.scrollAreaX, y + 40 - 5, this.scrollAreaX + this.scrollAreaWidth - 10, y + 40 - 4, 0x22FFFFFF);
                }
                y += 40;
            }
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        if (this.hasActiveStatusMessage()) {
            int messageWidth = this.field_22793.method_1727(this.statusMessage) + 20;
            int messageHeight = 20;
            int messageX = (this.field_22789 - messageWidth) / 2;
            int messageY = this.field_22790 / 2 - 10;
            context.method_25294(messageX, messageY, messageX + messageWidth, messageY + messageHeight, Integer.MIN_VALUE);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.statusMessage), this.field_22789 / 2, this.field_22790 / 2 - 4, this.statusColor);
        }
        ToastManager.render(context, this.field_22789);
    }

    private void drawLoadingAnimation(class_332 context, int centerX, int centerY) {
        int radius = 12;
        int segments = 8;
        int animationDuration = 1600;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.loadingStartTime;
        float rotation = (float)(elapsedTime % (long)animationDuration) / (float)animationDuration;
        for (int i = 0; i < segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments);
            angle = (float)((double)angle + (double)(rotation * 2.0f) * Math.PI);
            int x1 = centerX + (int)(Math.sin(angle) * (double)(radius - 3));
            int y1 = centerY + (int)(Math.cos(angle) * (double)(radius - 3));
            int x2 = centerX + (int)(Math.sin(angle) * (double)radius);
            int y2 = centerY + (int)(Math.cos(angle) * (double)radius);
            int alpha = 255 - i * 255 / segments;
            int color = 0xFFFFFF | alpha << 24;
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    private void renderSchematicItem(class_332 context, SchematicInfo schematic, int x, int y, int width, int mouseX, int mouseY, int index) {
        int textY;
        int maxTextWidth = width - 110;
        int textX = x + 10;
        int originalY = textY = y + 2;
        List titleLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)schematic.getName()), maxTextWidth);
        for (int i = 0; i < Math.min(titleLines.size(), 2); ++i) {
            if (i == 1 && titleLines.size() > 2) {
                Object lastLine = this.getPlainText((class_5481)titleLines.get(i));
                if (((String)lastLine).length() > 3) {
                    lastLine = ((String)lastLine).substring(0, ((String)lastLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)lastLine).method_30937(), textX, textY, 0xFFFFFF, true);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)titleLines.get(i), textX, textY, 0xFFFFFF, true);
            }
            textY += 10;
        }
        String description = schematic.getDescription().isEmpty() ? "No description" : schematic.getDescription();
        List descLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)description), maxTextWidth);
        if (!descLines.isEmpty()) {
            if (descLines.size() > 1) {
                Object firstLine = this.getPlainText((class_5481)descLines.get(0));
                if (((String)firstLine).length() > 3) {
                    firstLine = ((String)firstLine).substring(0, ((String)firstLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)firstLine).method_30937(), textX, textY, 0xAAAAAA, false);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)descLines.get(0), textX, textY, 0xAAAAAA, false);
            }
            textY += 10;
        }
        String authorText = "By: " + schematic.getUsername();
        context.method_51433(class_310.method_1551().field_1772, authorText, textX, textY, 0xCCCCCC, false);
        int rightX = x + width - 50;
        int statsY = originalY;
        String viewCountStr = String.valueOf(schematic.getViewCount());
        String downloadCountStr = String.valueOf(schematic.getDownloadCount());
        int maxNumberWidth = Math.max(class_310.method_1551().field_1772.method_1727(viewCountStr), class_310.method_1551().field_1772.method_1727(downloadCountStr));
        context.method_51433(class_310.method_1551().field_1772, viewCountStr, rightX - maxNumberWidth, statsY, 0xFFFFFF, false);
        context.method_51433(class_310.method_1551().field_1772, " \ud83d\udc41", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(viewCountStr), statsY, 0xFFFFFF, false);
        context.method_51433(class_310.method_1551().field_1772, downloadCountStr, rightX - maxNumberWidth, statsY += 10, 0xFFFFFF, false);
        context.method_51433(class_310.method_1551().field_1772, " \u2b07", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(downloadCountStr), statsY, 0xFFFFFF, false);
        int buttonX = x + width - 30;
        int buttonY = originalY - 2;
        boolean isButtonHovered = mouseX >= buttonX && mouseX <= buttonX + 20 && mouseY >= buttonY && mouseY <= buttonY + 20;
        int buttonColor = isButtonHovered ? -1711276033 : 0x66FFFFFF;
        context.method_25294(buttonX, buttonY, buttonX + 20, buttonY + 20, buttonColor);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2b07"), buttonX + 10, buttonY + 6, 0xFFFFFF);
    }

    private String getPlainText(class_5481 text) {
        StringBuilder sb = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            sb.appendCodePoint(codePoint);
            return true;
        });
        return sb.toString();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int index;
        if (this.searchField.method_25370() && (mouseX < (double)this.searchField.method_46426() || mouseX > (double)(this.searchField.method_46426() + this.searchField.method_25368()) || mouseY < (double)this.searchField.method_46427() || mouseY > (double)(this.searchField.method_46427() + this.searchField.method_25364()))) {
            this.searchField.method_25365(false);
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                this.scrollDragOffset = (int)(mouseY - (double)this.scrollBarY);
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                return true;
            }
        }
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && (index = (int)((mouseY - (double)this.scrollAreaY + (double)this.scrollOffset) / 40.0)) >= 0 && index < this.filteredSchematics.size()) {
            SchematicInfo schematic = this.filteredSchematics.get(index);
            int buttonX = this.scrollAreaX + this.scrollAreaWidth - 30;
            int buttonY = this.scrollAreaY - this.scrollOffset + index * 40 + 5;
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 20) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20)) {
                this.handleDownload(schematic);
                return true;
            }
            if (button == 0) {
                long currentTime = System.currentTimeMillis();
                if (index == this.lastClickedIndex && currentTime - this.lastClickTime < 500L) {
                    class_310.method_1551().method_1507((class_437)new DetailScreen(schematic.getId()));
                    return true;
                }
                this.lastClickedIndex = index;
                this.lastClickTime = currentTime;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void handleDownload(SchematicInfo schematic) {
        try {
            String savePath;
            String fileName = schematic.getName().replaceAll("[^a-zA-Z0-9.-]", "_");
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                savePath = new File(gameDir, "schematics").getAbsolutePath() + File.separator;
            } else {
                boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
                String homeDir = System.getProperty("user.home");
                savePath = isDevelopment ? homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "schematics" + File.separator : homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "schematics" + File.separator;
            }
            File potentialFile = new File(savePath + fileName + ".litematic");
            if (potentialFile.exists()) {
                ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + fileName + ".litematic\" already exists. Do you want to replace it?")), confirmed -> {
                    if (confirmed.booleanValue()) {
                        this.downloadSchematic(schematic, fileName);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                class_310.method_1551().method_1507((class_437)confirmationScreen);
            } else {
                this.downloadSchematic(schematic, fileName);
            }
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    private void downloadSchematic(SchematicInfo schematic, String fileName) {
        try {
            String filePath = LitematicHttpClient.fetchAndDownloadSchematic(schematic.getId(), fileName);
            String displayPath = "/schematic/" + fileName + ".litematic";
            this.setStatusMessage("Schematic downloaded to: " + displayPath, true);
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    public void setStatusMessage(String message, boolean isSuccess) {
        ToastManager.addToast(message, !isSuccess);
    }

    public boolean hasActiveStatusMessage() {
        return this.statusMessage != null && System.currentTimeMillis() - this.statusMessageDisplayTime < 3000L;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            float dragPosition = (float)(mouseY - (double)this.scrollDragOffset - (double)this.scrollAreaY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
            this.scrollOffset = (int)(dragPosition * (float)(this.totalContentHeight - this.scrollAreaHeight));
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(-verticalAmount * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

