/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.PostEntryWidget;
import com.choculaterie.gui.widget.ScrollBar;
import com.choculaterie.models.MinemevPostInfo;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

@Environment(value=EnvType.CLIENT)
public class PostListWidget
extends class_339 {
    private static final int ENTRY_SPACING = 2;
    private static final int SCROLLBAR_PADDING = 10;
    private final List<PostEntryButton> entries = new ArrayList<PostEntryButton>();
    private double scrollAmount = 0.0;
    private final OnPostClickListener onPostClick;
    private ScrollBar scrollBar;

    public PostListWidget(int x, int y, int width, int height, OnPostClickListener onPostClick) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.onPostClick = onPostClick;
        this.scrollBar = new ScrollBar(x + width - 8, y, height);
    }

    public void setDimensions(int x, int y, int width, int height) {
        this.method_46421(x);
        this.method_46419(y);
        this.field_22758 = width;
        this.field_22759 = height;
        this.scrollBar = new ScrollBar(x + width - 8, y, height);
        double savedScroll = this.scrollAmount;
        this.rebuildEntries();
        this.scrollAmount = savedScroll;
        this.updateScrollBar();
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(double scrollAmount) {
        this.scrollAmount = scrollAmount;
        this.updateScrollBar();
    }

    private void rebuildEntries() {
        ArrayList<MinemevPostInfo> posts = new ArrayList<MinemevPostInfo>();
        for (PostEntryButton entry : this.entries) {
            posts.add(entry.getPost());
        }
        if (!posts.isEmpty()) {
            this.setPosts(posts.toArray(new MinemevPostInfo[0]));
        }
    }

    public void setPosts(MinemevPostInfo[] posts) {
        this.entries.clear();
        this.scrollAmount = 0.0;
        int currentY = 0;
        for (MinemevPostInfo post : posts) {
            int rowWidth = Math.max(0, this.field_22758 - 10);
            Runnable clickAction = () -> {
                if (this.onPostClick != null) {
                    this.onPostClick.onPostClick(post);
                }
            };
            PostEntryWidget visual = new PostEntryWidget(post, this.method_46426(), this.method_46427() + currentY, rowWidth, clickAction);
            PostEntryButton button = new PostEntryButton(visual, clickAction);
            this.entries.add(button);
            currentY += button.getRowHeight() + 2;
        }
        this.updateScrollBar();
    }

    public void clear() {
        this.entries.clear();
        this.scrollAmount = 0.0;
        this.updateScrollBar();
    }

    private void updateScrollBar() {
        double contentHeight = this.getTotalContentHeight();
        this.scrollBar.setScrollData(contentHeight, this.field_22759);
        this.scrollBar.setScrollPercentage(contentHeight > (double)this.field_22759 ? this.scrollAmount / (contentHeight - (double)this.field_22759) : 0.0);
    }

    private double getTotalContentHeight() {
        int totalHeight = 0;
        for (PostEntryButton entry : this.entries) {
            totalHeight += entry.getRowHeight() + 2;
        }
        return totalHeight;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        int offsetY = (int)this.scrollAmount;
        int currentY = 0;
        for (int i = 0; i < this.entries.size(); ++i) {
            PostEntryButton entry = this.entries.get(i);
            int entryY = this.method_46427() + currentY - offsetY;
            if (entryY + entry.getRowHeight() >= this.method_46427() && entryY < this.method_46427() + this.field_22759) {
                entry.updateBounds(this.method_46426(), entryY, Math.max(0, this.field_22758 - 10));
                entry.method_25394(context, mouseX, mouseY, delta);
            }
            currentY += entry.getRowHeight() + 2;
        }
        context.method_44380();
        class_310 client = class_310.method_1551();
        if (client != null && client.method_22683() != null) {
            long windowHandle = client.method_22683().method_4490();
            if (this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, windowHandle)) {
                double maxScroll = this.getMaxScroll();
                this.scrollAmount = this.scrollBar.getScrollPercentage() * maxScroll;
            }
        } else {
            this.scrollBar.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        System.out.println("[PostListWidget] mouseClicked called - mouseX: " + mouseX + ", mouseY: " + mouseY + ", button: " + button + ", doubled: " + doubled);
        if (this.scrollBar.mouseClicked(mouseX, mouseY, button)) {
            System.out.println("[PostListWidget] Scrollbar handled the click");
            return true;
        }
        if (button == 0 && mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759)) {
            int offsetY = (int)this.scrollAmount;
            int currentY = 0;
            for (int i = 0; i < this.entries.size(); ++i) {
                PostEntryButton entry = this.entries.get(i);
                int entryY = this.method_46427() + currentY - offsetY;
                if (entryY + entry.getRowHeight() >= this.method_46427() && entryY < this.method_46427() + this.field_22759) {
                    entry.updateBounds(this.method_46426(), entryY, Math.max(0, this.field_22758 - 10));
                    if (entry.handlePress(mouseX, mouseY, button)) {
                        System.out.println("[PostListWidget] Entry " + i + " handled the click and triggered callback!");
                        return true;
                    }
                }
                currentY += entry.getRowHeight() + 2;
            }
        }
        System.out.println("[PostListWidget] Click not handled by any entry");
        return super.method_25402(click, doubled);
    }

    protected void onPress() {
        System.out.println("[PostListWidget] onPress() called!");
        class_310 client = class_310.method_1551();
        if (client == null || client.field_1729 == null) {
            return;
        }
        double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
        double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
        System.out.println("[PostListWidget] Mouse position: " + mouseX + ", " + mouseY);
        System.out.println("[PostListWidget] Widget bounds: " + this.method_46426() + ", " + this.method_46427() + ", " + (this.method_46426() + this.field_22758) + ", " + (this.method_46427() + this.field_22759));
        if (this.scrollBar.mouseClicked(mouseX, mouseY, 0)) {
            System.out.println("[PostListWidget] Scrollbar handled the click");
            return;
        }
        if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759)) {
            int offsetY = (int)this.scrollAmount;
            int currentY = 0;
            for (int i = 0; i < this.entries.size(); ++i) {
                PostEntryButton entry = this.entries.get(i);
                int entryY = this.method_46427() + currentY - offsetY;
                if (entryY + entry.getRowHeight() >= this.method_46427() && entryY < this.method_46427() + this.field_22759) {
                    entry.updateBounds(this.method_46426(), entryY, Math.max(0, this.field_22758 - 10));
                    if (entry.handlePress(mouseX, mouseY, 0)) {
                        System.out.println("[PostListWidget] Entry " + i + " handled the click and triggered callback!");
                        return;
                    }
                }
                currentY += entry.getRowHeight() + 2;
            }
        }
        System.out.println("[PostListWidget] Click not handled by any entry");
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.scrollBar.isDragging() || this.scrollBar.mouseDragged(mouseX, mouseY, 0, deltaX, deltaY)) {
            this.scrollBar.mouseDragged(mouseX, mouseY, 0, deltaX, deltaY);
            double maxScroll = this.getMaxScroll();
            this.scrollAmount = this.scrollBar.getScrollPercentage() * maxScroll;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.scrollBar.isDragging()) {
            return this.scrollBar.mouseReleased(mouseX, mouseY, button);
        }
        if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759)) {
            int offsetY = (int)this.scrollAmount;
            for (int i = 0; i < this.entries.size(); ++i) {
                PostEntryButton entry = this.entries.get(i);
                int entryY = this.method_46427() + i * (entry.getRowHeight() + 2) - offsetY;
                if (entryY + entry.getRowHeight() < this.method_46427() || entryY >= this.method_46427() + this.field_22759) continue;
                entry.updateBounds(this.method_46426(), entryY, Math.max(0, this.field_22758 - 10));
                if (!entry.handleRelease(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return this.scrollBar.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrollBar.isDragging() || this.scrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
            this.scrollBar.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
            double maxScroll = this.getMaxScroll();
            this.scrollAmount = this.scrollBar.getScrollPercentage() * maxScroll;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759)) {
            double maxScroll = this.getMaxScroll();
            this.scrollAmount = Math.max(0.0, Math.min(maxScroll, this.scrollAmount - verticalAmount * 20.0));
            this.updateScrollBar();
            return true;
        }
        return false;
    }

    private double getMaxScroll() {
        return Math.max(0.0, this.getTotalContentHeight() - (double)this.field_22759);
    }

    protected void method_47399(class_6382 builder) {
    }

    @Environment(value=EnvType.CLIENT)
    public static interface OnPostClickListener {
        public void onPostClick(MinemevPostInfo var1);
    }

    @Environment(value=EnvType.CLIENT)
    private static final class PostEntryButton
    extends class_339 {
        private final PostEntryWidget visual;
        private final MinemevPostInfo post;
        private final Runnable clickAction;
        private boolean pressed;

        private PostEntryButton(PostEntryWidget visual, Runnable clickAction) {
            super(visual.getX(), visual.y, visual.getWidth(), visual.getHeight(), (class_2561)class_2561.method_43473());
            this.visual = visual;
            this.post = visual.getPost();
            this.clickAction = clickAction;
        }

        private void updateBounds(int x, int y, int width) {
            this.method_46421(x);
            this.method_46419(y);
            this.method_25358(width);
            this.field_22759 = this.visual.getHeight();
            this.visual.setX(x);
            this.visual.setWidth(width);
            this.visual.setY(y);
        }

        private int getRowHeight() {
            return this.visual.getHeight();
        }

        private MinemevPostInfo getPost() {
            return this.post;
        }

        private boolean handlePress(double mouseX, double mouseY, int button) {
            if (button != 0 || !this.isPointInside(mouseX, mouseY)) {
                return false;
            }
            this.pressed = true;
            this.visual.setPressed(true);
            this.method_25365(true);
            class_310 client = class_310.method_1551();
            if (client != null && client.method_1483() != null) {
                this.method_25354(client.method_1483());
            }
            if (this.clickAction != null) {
                this.clickAction.run();
            }
            return true;
        }

        private boolean handleRelease(double mouseX, double mouseY, int button) {
            if (!this.pressed) {
                return false;
            }
            this.pressed = false;
            this.visual.setPressed(false);
            return true;
        }

        private boolean isPointInside(double mouseX, double mouseY) {
            return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.method_25368()) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.method_25364());
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            this.visual.method_25394(context, mouseX, mouseY, delta);
            if (this.method_49606()) {
                context.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, 0x30FFFFFF);
            }
        }

        protected void method_47399(class_6382 builder) {
            builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"Post entry"));
        }
    }
}

