/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui.widget;

import com.choculaterie.gui.widget.CustomButton;
import com.choculaterie.gui.widget.ScrollBar;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

@Environment(value=EnvType.CLIENT)
public class ConfirmPopup
implements class_4068,
class_364 {
    private static final int POPUP_WIDTH = 400;
    private static final int PADDING = 10;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LINE_HEIGHT = 12;
    private static final int MAX_MESSAGE_HEIGHT = 300;
    private final class_437 parent;
    private final String title;
    private final String message;
    private final Runnable onConfirm;
    private final Runnable onCancel;
    private CustomButton confirmButton;
    private CustomButton cancelButton;
    private boolean wasEnterPressed = false;
    private boolean wasEscapePressed = false;
    private final int x;
    private final int y;
    private final int popupHeight;
    private final List<String> wrappedMessage;
    private final int actualMessageHeight;
    private final int visibleMessageHeight;
    private ScrollBar scrollBar;
    private double scrollOffset = 0.0;

    public ConfirmPopup(class_437 parent, String title, String message, Runnable onConfirm, Runnable onCancel) {
        this.parent = parent;
        this.title = title;
        this.message = message;
        this.onConfirm = onConfirm;
        this.onCancel = onCancel;
        class_310 client = class_310.method_1551();
        this.wrappedMessage = this.wrapText(message, 380, client);
        int screenHeight = client.method_22683().method_4502();
        int screenWidth = client.method_22683().method_4486();
        int verticalMargin = 40;
        int popupChrome = 72;
        int maxAvailableMessageHeight = screenHeight - verticalMargin * 2 - popupChrome;
        int effectiveMaxHeight = Math.min(300, maxAvailableMessageHeight);
        this.actualMessageHeight = this.wrappedMessage.size() * 12;
        this.visibleMessageHeight = Math.min(this.actualMessageHeight, effectiveMaxHeight);
        this.popupHeight = 32 + this.visibleMessageHeight + 10 + 20 + 10;
        this.x = (screenWidth - 400) / 2;
        this.y = (screenHeight - this.popupHeight) / 2;
        if (this.actualMessageHeight > this.visibleMessageHeight) {
            int messageAreaY = this.y + 10 + 12 + 10;
            int scrollBarX = this.x + 400 - 10 - 8;
            this.scrollBar = new ScrollBar(scrollBarX, messageAreaY, this.visibleMessageHeight);
            this.scrollBar.setScrollData(this.actualMessageHeight, this.visibleMessageHeight);
        }
        this.initWidgets();
    }

    private List<String> wrapText(String text, int maxWidth, class_310 client) {
        String[] paragraphs;
        ArrayList<String> lines = new ArrayList<String>();
        for (String paragraph : paragraphs = text.split("\n")) {
            if (paragraph.isEmpty()) {
                lines.add("");
                continue;
            }
            String[] words = paragraph.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                Object testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
                int width = client.field_1772.method_1727((String)testLine);
                if (width <= maxWidth) {
                    if (currentLine.length() > 0) {
                        currentLine.append(" ");
                    }
                    currentLine.append(word);
                    continue;
                }
                if (currentLine.length() > 0) {
                    lines.add(currentLine.toString());
                }
                currentLine = new StringBuilder(word);
            }
            if (currentLine.length() <= 0) continue;
            lines.add(currentLine.toString());
        }
        return lines.isEmpty() ? List.of(text) : lines;
    }

    private void initWidgets() {
        int buttonY = this.y + this.popupHeight - 10 - 20;
        int buttonWidth = 185;
        this.cancelButton = new CustomButton(this.x + 10, buttonY, buttonWidth, 20, (class_2561)class_2561.method_43470((String)"Cancel"), button -> this.onCancel.run());
        this.confirmButton = new CustomButton(this.x + 20 + buttonWidth, buttonY, buttonWidth, 20, (class_2561)class_2561.method_43470((String)"Delete"), button -> this.onConfirm.run());
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        long windowHandle;
        class_310 client = class_310.method_1551();
        long l = windowHandle = client.method_22683() != null ? client.method_22683().method_4490() : 0L;
        if (windowHandle != 0L) {
            boolean escapePressed;
            boolean enterPressed = GLFW.glfwGetKey((long)windowHandle, (int)257) == 1 || GLFW.glfwGetKey((long)windowHandle, (int)335) == 1;
            boolean bl = escapePressed = GLFW.glfwGetKey((long)windowHandle, (int)256) == 1;
            if (enterPressed && !this.wasEnterPressed) {
                this.onConfirm.run();
            }
            if (escapePressed && !this.wasEscapePressed) {
                this.onCancel.run();
            }
            this.wasEnterPressed = enterPressed;
            this.wasEscapePressed = escapePressed;
        }
        context.method_25294(0, 0, client.method_22683().method_4486(), client.method_22683().method_4502(), Integer.MIN_VALUE);
        context.method_25294(this.x, this.y, this.x + 400, this.y + this.popupHeight, -14013910);
        context.method_25294(this.x, this.y, this.x + 400, this.y + 1, -11184811);
        context.method_25294(this.x, this.y + this.popupHeight - 1, this.x + 400, this.y + this.popupHeight, -11184811);
        context.method_25294(this.x, this.y, this.x + 1, this.y + this.popupHeight, -11184811);
        context.method_25294(this.x + 400 - 1, this.y, this.x + 400, this.y + this.popupHeight, -11184811);
        context.method_25300(client.field_1772, this.title, this.x + 200, this.y + 10, -1);
        int messageAreaY = this.y + 10 + 12 + 10;
        int messageAreaHeight = this.visibleMessageHeight;
        context.method_44379(this.x + 10, messageAreaY, this.x + 400 - 10, messageAreaY + messageAreaHeight);
        int messageY = messageAreaY - (int)this.scrollOffset;
        for (String line : this.wrappedMessage) {
            if (messageY + 12 >= messageAreaY && messageY < messageAreaY + messageAreaHeight) {
                context.method_25303(client.field_1772, line, this.x + 10, messageY, -3355444);
            }
            messageY += 12;
        }
        context.method_44380();
        if (this.scrollBar != null && client.method_22683() != null) {
            this.scrollBar.setScrollPercentage(this.scrollOffset / (double)Math.max(1, this.actualMessageHeight - this.visibleMessageHeight));
            boolean scrollChanged = this.scrollBar.updateAndRender(context, mouseX, mouseY, delta, client.method_22683().method_4490());
            if (scrollChanged || this.scrollBar.isDragging()) {
                double maxScroll = this.actualMessageHeight - this.visibleMessageHeight;
                this.scrollOffset = this.scrollBar.getScrollPercentage() * maxScroll;
            }
        }
        if (this.cancelButton != null) {
            this.cancelButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.confirmButton != null) {
            this.confirmButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseX > (double)(this.x + 400) || mouseY < (double)this.y || mouseY > (double)(this.y + this.popupHeight)) {
            this.onCancel.run();
            return true;
        }
        if (this.cancelButton != null) {
            boolean isOverCancel;
            boolean bl = isOverCancel = mouseX >= (double)this.cancelButton.method_46426() && mouseX < (double)(this.cancelButton.method_46426() + this.cancelButton.method_25368()) && mouseY >= (double)this.cancelButton.method_46427() && mouseY < (double)(this.cancelButton.method_46427() + this.cancelButton.method_25364());
            if (isOverCancel) {
                this.onCancel.run();
                return true;
            }
        }
        if (this.confirmButton != null) {
            boolean isOverConfirm;
            boolean bl = isOverConfirm = mouseX >= (double)this.confirmButton.method_46426() && mouseX < (double)(this.confirmButton.method_46426() + this.confirmButton.method_25368()) && mouseY >= (double)this.confirmButton.method_46427() && mouseY < (double)(this.confirmButton.method_46427() + this.confirmButton.method_25364());
            if (isOverConfirm) {
                this.onConfirm.run();
                return true;
            }
        }
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.scrollBar != null) {
            int messageAreaY = this.y + 10 + 12 + 10;
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + 400) && mouseY >= (double)messageAreaY && mouseY < (double)(messageAreaY + this.visibleMessageHeight)) {
                double maxScroll = this.actualMessageHeight - this.visibleMessageHeight;
                this.scrollOffset = Math.max(0.0, Math.min(maxScroll, this.scrollOffset - verticalAmount * 12.0));
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }
}

