/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.gui.AccountLinkingScreen;
import com.choculaterie.network.NetworkManager;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_526;

@Environment(value=EnvType.CLIENT)
public class UploadManagerScreen
extends class_437 {
    private final class_437 parent;
    private final NetworkManager networkManager = new NetworkManager();
    private class_4185 backBtn;
    private class_4185 refreshBtn;
    private class_4185 prevBtn;
    private class_4185 nextBtn;
    private class_4185 settingsBtn;
    private class_4185 uploadBtn;
    private boolean loading = true;
    private String status = "Loading...";
    private final List<LocalSave> saves = new ArrayList<LocalSave>();
    private int selectedIndex = -1;
    private int currentPage = 0;
    private static final int PAGE_SIZE = 6;
    private static final int COL_WORLD_W = 300;
    private static final int COL_SIZE_W = 100;
    private static final int COL_UPDATED_W = 180;
    private static final ActiveUp ACTIVE = new ActiveUp();
    private final List<class_4264> rowHitBoxes = new ArrayList<class_4264>();

    public UploadManagerScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Upload a Local World"));
        this.parent = parent;
    }

    protected void method_25426() {
        int cx = this.field_22789 / 2;
        int bottomY = this.field_22790 - 28;
        int btnSize = 20;
        int margin = 6;
        this.backBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), b -> {
            if (this.field_22787 != null) {
                class_437 rootParent = UploadManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new class_526(rootParent));
            }
        }).method_46434(10, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.backBtn);
        this.refreshBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), b -> {
            this.selectedIndex = -1;
            this.fetchLocalSaves();
        }).method_46434(35, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.refreshBtn);
        this.settingsBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), b -> {
            if (this.field_22787 != null) {
                class_437 rootParent = UploadManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
            }
        }).method_46434(this.field_22789 - margin - btnSize, margin, btnSize, btnSize).method_46431();
        this.method_37063((class_364)this.settingsBtn);
        this.prevBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"<"), b -> {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.selectedIndex = -1;
                this.method_41843();
            }
        }).method_46434(this.field_22789 - 55, bottomY, 20, 20).method_46431();
        this.method_37063((class_364)this.prevBtn);
        this.nextBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)">"), b -> {
            if ((this.currentPage + 1) * 6 < this.saves.size()) {
                ++this.currentPage;
                this.selectedIndex = -1;
                this.method_41843();
            }
        }).method_46434(this.field_22789 - 30, bottomY, 20, 20).method_46431();
        this.method_37063((class_364)this.nextBtn);
        this.uploadBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Upload"), b -> this.onUploadClicked()).method_46434(cx - 50, bottomY, 100, 20).method_46431();
        this.method_37063((class_364)this.uploadBtn);
        String apiKey = this.loadApiKeyFromDisk();
        if (apiKey == null || apiKey.isBlank()) {
            this.loading = false;
            this.status = "No API key configured";
        } else {
            try {
                this.networkManager.setApiKey(apiKey);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.fetchLocalSaves();
        }
        this.buildRowHitBoxes();
        this.rebuildPagerState();
        this.updateActionButtons();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.method_41843();
    }

    private void fetchLocalSaves() {
        this.loading = true;
        this.status = "Loading...";
        this.updateActionButtons();
        CompletableFuture.runAsync(() -> {
            ArrayList<LocalSave> tmp = new ArrayList<LocalSave>();
            try {
                Path savesDir = this.field_22787.field_1697.toPath().resolve("saves");
                if (Files.exists(savesDir, new LinkOption[0]) && Files.isDirectory(savesDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> ds = Files.newDirectoryStream(savesDir);){
                        for (Path p : ds) {
                            if (!Files.isDirectory(p, new LinkOption[0])) continue;
                            LocalSave s2 = LocalSave.fromDir(p);
                            tmp.add(s2);
                        }
                    }
                }
                tmp.sort(Comparator.comparingLong(s -> s.lastModified).reversed());
            }
            catch (Exception e) {
                SaveManagerMod.LOGGER.error("UploadManager: error scanning saves", (Throwable)e);
            }
            this.runOnClient(() -> {
                this.saves.clear();
                this.saves.addAll(tmp);
                this.currentPage = 0;
                this.selectedIndex = -1;
                this.loading = false;
                this.status = this.saves.isEmpty() ? "No local saves found" : "";
                this.buildRowHitBoxes();
                this.rebuildPagerState();
                this.updateActionButtons();
            });
        });
    }

    private void onUploadClicked() {
        LocalSave s = this.getSelected();
        if (s == null) {
            return;
        }
        if (this.networkManager.getApiKey() == null || this.networkManager.getApiKey().isBlank()) {
            if (this.field_22787 != null) {
                class_437 rootParent = UploadManagerScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
            }
            return;
        }
        this.loading = true;
        this.status = "Preparing...";
        this.updateActionButtons();
        this.networkManager.listWorldSaveNames().whenComplete((names, err) -> this.runOnClient(() -> {
            if (err != null) {
                SaveManagerMod.LOGGER.warn("UploadManager: names list failed; proceeding", err);
                this.beginZipAndUpload(s);
                return;
            }
            String sanitized = UploadManagerScreen.sanitizeFolderName(s.worldName);
            boolean exists = false;
            if (names != null) {
                for (String n : names) {
                    if (n == null || !n.equalsIgnoreCase(s.worldName) && (sanitized.isEmpty() || !n.equalsIgnoreCase(sanitized))) continue;
                    exists = true;
                    break;
                }
            }
            if (!exists) {
                this.beginZipAndUpload(s);
                return;
            }
            class_5250 title = class_2561.method_43470((String)"Overwrite Cloud Save?");
            class_5250 message = class_2561.method_43470((String)("A save named \"" + s.worldName + "\" already exists in the cloud. Overwrite?"));
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                this.field_22787.method_1507((class_437)this);
                if (confirmed) {
                    this.beginZipAndUpload(s);
                } else {
                    this.loading = false;
                    this.status = "";
                    this.updateActionButtons();
                }
            }, (class_2561)title, (class_2561)message));
        }));
    }

    private void beginZipAndUpload(LocalSave s) {
        UploadManagerScreen.ACTIVE.active = true;
        UploadManagerScreen.ACTIVE.zipping = true;
        UploadManagerScreen.ACTIVE.uploaded = 0L;
        UploadManagerScreen.ACTIVE.total = -1L;
        UploadManagerScreen.ACTIVE.lastTickNanos = UploadManagerScreen.ACTIVE.startNanos = System.nanoTime();
        UploadManagerScreen.ACTIVE.lastBytes = 0L;
        UploadManagerScreen.ACTIVE.speedBps = 0.0;
        this.loading = true;
        this.status = "Zipping...";
        this.updateActionButtons();
        Path worldDir = s.dir;
        String worldName = s.worldName;
        new Thread(() -> {
            Path zip = null;
            try {
                zip = UploadManagerScreen.sm$zipWorld(worldDir, worldName.replaceAll("[\\\\/:*?\"<>|]+", "_"));
            }
            catch (Exception ex) {
                SaveManagerMod.LOGGER.error("UploadManager: zip failed", (Throwable)ex);
                String raw = UploadManagerScreen.sm$rawFromThrowable(ex);
                Path toDelete = zip;
                this.runOnClient(() -> {
                    UploadManagerScreen.ACTIVE.active = false;
                    UploadManagerScreen.ACTIVE.zipping = false;
                    this.loading = false;
                    this.status = "Zip failed";
                    this.updateActionButtons();
                    this.sm$showErrorDialog(raw, "Failed to prepare world zip");
                });
                return;
            }
            Path zipFinal = zip;
            this.runOnClient(() -> this.startUpload(zipFinal, worldName));
        }, "SaveManager-zip").start();
    }

    private void startUpload(Path zipFile, String worldName) {
        UploadManagerScreen.ACTIVE.zipping = false;
        UploadManagerScreen.ACTIVE.active = true;
        UploadManagerScreen.ACTIVE.uploaded = 0L;
        UploadManagerScreen.ACTIVE.total = -1L;
        UploadManagerScreen.ACTIVE.lastTickNanos = UploadManagerScreen.ACTIVE.startNanos = System.nanoTime();
        UploadManagerScreen.ACTIVE.lastBytes = 0L;
        UploadManagerScreen.ACTIVE.speedBps = 0.0;
        this.loading = true;
        this.status = "Uploading...";
        this.updateActionButtons();
        try {
            this.networkManager.uploadWorldSave(worldName, zipFile, (sent, total) -> {
                UploadManagerScreen.ACTIVE.uploaded = Math.max(0L, sent);
                if (total > 0L) {
                    UploadManagerScreen.ACTIVE.total = total;
                }
                long now = System.nanoTime();
                long dtNs = now - UploadManagerScreen.ACTIVE.lastTickNanos;
                long dBytes = UploadManagerScreen.ACTIVE.uploaded - UploadManagerScreen.ACTIVE.lastBytes;
                if (dtNs > 50000000L) {
                    double instBps = dBytes > 0L ? (double)dBytes * 1.0E9 / (double)dtNs : 0.0;
                    double alpha = 0.2;
                    UploadManagerScreen.ACTIVE.speedBps = UploadManagerScreen.ACTIVE.speedBps <= 0.0 ? instBps : alpha * instBps + (1.0 - alpha) * UploadManagerScreen.ACTIVE.speedBps;
                    UploadManagerScreen.ACTIVE.lastTickNanos = now;
                    UploadManagerScreen.ACTIVE.lastBytes = UploadManagerScreen.ACTIVE.uploaded;
                }
            }).whenComplete((json, err) -> this.runOnClient(() -> {
                try {
                    Files.deleteIfExists(zipFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UploadManagerScreen.ACTIVE.active = false;
                UploadManagerScreen.ACTIVE.zipping = false;
                UploadManagerScreen.ACTIVE.uploaded = 0L;
                UploadManagerScreen.ACTIVE.total = -1L;
                UploadManagerScreen.ACTIVE.startNanos = 0L;
                UploadManagerScreen.ACTIVE.lastTickNanos = 0L;
                UploadManagerScreen.ACTIVE.lastBytes = 0L;
                UploadManagerScreen.ACTIVE.speedBps = 0.0;
                if (err != null) {
                    SaveManagerMod.LOGGER.error("UploadManager: upload failed", err);
                    String raw = UploadManagerScreen.sm$rawFromThrowable(err);
                    this.loading = false;
                    this.status = "Upload failed";
                    this.updateActionButtons();
                    this.sm$showErrorDialog(raw, "Upload failed");
                    return;
                }
                this.loading = false;
                this.status = "Uploaded";
                this.updateActionButtons();
            }));
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(zipFile);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SaveManagerMod.LOGGER.error("UploadManager: upload error", t);
            String raw = UploadManagerScreen.sm$rawFromThrowable(t);
            this.loading = false;
            this.status = "Upload failed";
            this.updateActionButtons();
            this.sm$showErrorDialog(raw, "Upload failed");
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float delta) {
        super.method_25394(ctx, mouseX, mouseY, delta);
        int cx = this.field_22789 / 2;
        ctx.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        Geometry g = this.computeGeometry();
        int col1 = g.listX();
        int col2 = col1 + 300;
        int col3 = col2 + 100;
        int headerY = this.field_22790 / 4 + 10;
        this.drawColText(ctx, "World", col1, headerY, -1);
        this.drawColText(ctx, "Size", col2, headerY, -1);
        this.drawColText(ctx, "Updated", col3, headerY, -1);
        ctx.method_44379(g.listX(), g.listY(), g.listX() + g.listW(), g.listY() + g.listH());
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        for (int i = start; i < end; ++i) {
            LocalSave s = this.saves.get(i);
            int ry = g.rowStartY() + (i - start) * g.rowHeight();
            if (i == this.selectedIndex) {
                int h = Math.max(1, g.rowHeight() - 4);
                int x1 = g.listX();
                int x2 = g.listX() + g.listW();
                ctx.method_25294(x1, ry - 4, x2, ry - 1 + h, 0x66FFFFFF);
            }
            this.drawColText(ctx, UploadManagerScreen.safe(s.worldName), col1, ry, -2236963);
            this.drawColText(ctx, UploadManagerScreen.formatBytes(s.sizeBytes), col2, ry, -2236963);
            this.drawColText(ctx, UploadManagerScreen.shortDate(s.lastModified), col3, ry, -2236963);
            ctx.method_25294(g.listX(), ry + g.rowHeight() - 5, g.listX() + g.listW(), ry + g.rowHeight() - 4, 0x22FFFFFF);
        }
        ctx.method_44380();
        boolean opActive = UploadManagerScreen.ACTIVE.active;
        int baseStatusY = this.field_22790 - 56;
        int statusY = opActive ? baseStatusY - 16 : baseStatusY;
        String displayStatus = this.status;
        if (UploadManagerScreen.ACTIVE.active) {
            String string = UploadManagerScreen.ACTIVE.zipping ? "Zipping..." : (displayStatus = UploadManagerScreen.ACTIVE.uploaded <= 0L ? "Preparing..." : "");
        }
        if (this.loading || displayStatus != null && !displayStatus.isEmpty()) {
            ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)displayStatus), cx, statusY, -1);
        }
        if (UploadManagerScreen.ACTIVE.active) {
            if (UploadManagerScreen.ACTIVE.zipping || UploadManagerScreen.ACTIVE.uploaded <= 0L) {
                int radius = 8;
                int dots = 12;
                int cx0 = this.field_22789 / 2;
                int cy0 = statusY + 24;
                long t = System.currentTimeMillis();
                int head = (int)(t / 100L % (long)dots);
                for (int i = 0; i < dots; ++i) {
                    double ang = Math.PI * 2 * (double)i / (double)dots;
                    int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                    int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                    int x = cx0 + dx;
                    int y = cy0 + dy;
                    int dist = (i - head + dots) % dots;
                    int alpha = switch (dist) {
                        case 0 -> 255;
                        case 1 -> 204;
                        case 2 -> 153;
                        case 3 -> 102;
                        default -> 51;
                    };
                    int col = alpha << 24 | 0xCCCCCC;
                    ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                }
            } else {
                boolean knownTotals;
                long uploaded = UploadManagerScreen.ACTIVE.uploaded;
                long total = UploadManagerScreen.ACTIVE.total;
                double speed = UploadManagerScreen.ACTIVE.speedBps;
                boolean bl = knownTotals = total > 0L && uploaded >= 0L;
                if (knownTotals) {
                    int barW = 360;
                    int barH = 8;
                    int bx = cx - barW / 2;
                    int by = statusY + 14;
                    ctx.method_25294(bx, by, bx + barW, by + barH, -12303292);
                    double frac = Math.min(1.0, (double)uploaded / (double)total);
                    int filled = (int)((double)barW * frac);
                    ctx.method_25294(bx, by, bx + filled, by + barH, -3355444);
                    int pct = (int)Math.min(100.0, Math.floor((double)uploaded * 100.0 / (double)total));
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(pct + "%")), cx, by - 10, -1);
                    String info = UploadManagerScreen.formatBytes(uploaded) + " / " + UploadManagerScreen.formatBytes(total);
                    if (speed > 1.0) {
                        String sp = UploadManagerScreen.formatBytes((long)speed) + "/s";
                        long remaining = Math.max(0L, total - uploaded);
                        long etaSec = Math.max(0L, (long)Math.ceil((double)remaining / Math.max(1.0, speed)));
                        info = info + " \u2022 " + sp + " \u2022 ETA " + UploadManagerScreen.formatDurationShort(etaSec);
                    }
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)info), cx, by + barH + 2, -3355444);
                } else {
                    int radius = 8;
                    int dots = 12;
                    int cx0 = this.field_22789 / 2;
                    int cy0 = statusY + 24;
                    long t = System.currentTimeMillis();
                    int head = (int)(t / 100L % (long)dots);
                    for (int i = 0; i < dots; ++i) {
                        double ang = Math.PI * 2 * (double)i / (double)dots;
                        int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                        int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                        int x = cx0 + dx;
                        int y = cy0 + dy;
                        int dist = (i - head + dots) % dots;
                        int alpha = switch (dist) {
                            case 0 -> 255;
                            case 1 -> 204;
                            case 2 -> 153;
                            case 3 -> 102;
                            default -> 51;
                        };
                        int col = alpha << 24 | 0xCCCCCC;
                        ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                    }
                }
            }
        }
        this.rebuildPagerState();
        this.updateActionButtons();
    }

    private void buildRowHitBoxes() {
        for (class_4264 w : this.rowHitBoxes) {
            try {
                this.method_37066((class_364)w);
            }
            catch (Throwable throwable) {}
        }
        this.rowHitBoxes.clear();
        Geometry g = this.computeGeometry();
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        for (int i = start; i < end; ++i) {
            int globalIndex = i;
            int ry = g.rowStartY + (i - start) * g.rowHeight;
            class_4185 hit = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> {
                this.selectedIndex = globalIndex;
                if (!this.loading && !UploadManagerScreen.ACTIVE.active) {
                    this.status = "";
                }
                this.updateActionButtons();
            }).method_46434(g.listX, ry - 4, g.listW, g.rowHeight).method_46431();
            try {
                hit.method_25350(0.0f);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            hit.field_22764 = true;
            hit.field_22763 = true;
            this.method_37063((class_364)hit);
            this.rowHitBoxes.add((class_4264)hit);
        }
    }

    private void rebuildPagerState() {
        boolean allowPager;
        boolean bl = allowPager = !this.loading || UploadManagerScreen.ACTIVE.active;
        if (this.prevBtn != null) {
            boolean bl2 = this.prevBtn.field_22763 = this.currentPage > 0 && allowPager;
        }
        if (this.nextBtn != null) {
            this.nextBtn.field_22763 = (this.currentPage + 1) * 6 < this.saves.size() && allowPager;
        }
    }

    private void updateActionButtons() {
        boolean enabled;
        boolean bl = enabled = this.getSelected() != null && !this.loading && !UploadManagerScreen.ACTIVE.active;
        if (this.uploadBtn != null) {
            this.uploadBtn.field_22763 = enabled;
        }
    }

    private LocalSave getSelected() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.saves.size()) {
            return null;
        }
        return this.saves.get(this.selectedIndex);
    }

    private Geometry computeGeometry() {
        int cx = this.field_22789 / 2;
        int top = this.field_22790 / 4;
        int headerY = top + 10;
        int rowStartY = headerY + 20;
        int rowHeight = 22;
        int start = this.currentPage * 6;
        int end = Math.min(start + 6, this.saves.size());
        int visible = Math.max(0, end - start);
        int contentW = 580;
        int listX = Math.max(0, cx - contentW / 2);
        int listY = rowStartY - 10;
        int listW = contentW;
        int listH = Math.max(visible * rowHeight, rowHeight) + 12;
        return new Geometry(listX, listY, listW, listH, rowStartY, rowHeight);
    }

    private void drawColText(class_332 ctx, String s, int x, int y, int color) {
        ctx.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)s), x, y, color);
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static String shortDate(long epochMillis) {
        if (epochMillis <= 0L) {
            return "";
        }
        Instant i = Instant.ofEpochMilli(epochMillis);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneId.systemDefault()).format(i);
    }

    private static String formatDurationShort(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        if (h > 0L) {
            return String.format("%dh %02dm", h, m);
        }
        if (m > 0L) {
            return String.format("%dm %02ds", m, s);
        }
        return String.format("%ds", s);
    }

    private static String formatBytes(long n) {
        if (n < 1024L) {
            return n + " B";
        }
        int u = -1;
        double d = n;
        String[] units = new String[]{"KB", "MB", "GB", "TB"};
        while ((d /= 1024.0) >= 1024.0 && ++u < units.length - 1) {
        }
        return String.format(Locale.ROOT, "%.1f %s", d, units[u]);
    }

    private static String sanitizeFolderName(String s) {
        if (s == null) {
            return "";
        }
        String clean = s.trim().replaceAll("[\\\\/:*?\"<>|]+", "_");
        return clean.isBlank() ? "" : clean;
    }

    private void runOnClient(Runnable r) {
        if (this.field_22787 != null) {
            this.field_22787.execute(r);
        }
    }

    private static class_437 sm$resolveWorldRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    private static String sm$rawFromThrowable(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int guard = 0;
        while (t != null && guard++ < 16) {
            String m = t.getMessage();
            if (m != null && !m.isBlank()) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(m);
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    private void sm$showErrorDialog(String raw, String fallbackTitle) {
        String friendly = UploadManagerScreen.sm$extractFriendly(raw);
        class_5250 title = class_2561.method_43470((String)"Error");
        class_5250 message = class_2561.method_43470((String)(friendly == null || friendly.isBlank() ? fallbackTitle : friendly));
        boolean invalidKey = UploadManagerScreen.sm$isInvalidKey(raw, friendly);
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (!confirmed) {
                try {
                    if (this.field_22787 != null && this.field_22787.field_1774 != null) {
                        this.field_22787.field_1774.method_1455(raw == null ? "" : raw);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (invalidKey) {
                if (this.field_22787 != null) {
                    class_437 rootParent = UploadManagerScreen.sm$resolveWorldRootParent(this.parent);
                    this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
                }
                return;
            }
            this.field_22787.method_1507((class_437)this);
        }, (class_2561)title, (class_2561)message, (class_2561)class_2561.method_43470((String)"OK"), (class_2561)class_2561.method_43470((String)"Copy error")));
    }

    private static boolean sm$isInvalidKey(String raw, String friendly) {
        String r = (raw == null ? "" : raw).toLowerCase(Locale.ROOT);
        if (friendly != null && friendly.equalsIgnoreCase("Invalid Save Manager API key")) {
            return true;
        }
        return r.contains("401") && r.contains("invalid save manager api key");
    }

    private static String sm$extractFriendly(String raw) {
        int i;
        if (raw == null) {
            raw = "";
        }
        String friendly = "";
        int start = raw.indexOf(123);
        while (start >= 0 && start < raw.length()) {
            try {
                JsonObject obj;
                String sub = raw.substring(start).trim();
                JsonElement el = new JsonParser().parse(sub);
                if (el.isJsonObject() && (obj = el.getAsJsonObject()).has("error") && obj.get("error").isJsonPrimitive() && (friendly = obj.get("error").getAsString()) != null && !friendly.isBlank()) {
                    return friendly;
                }
            }
            catch (Throwable sub) {
                // empty catch block
            }
            start = raw.indexOf(123, start + 1);
        }
        if (raw.contains("401") && raw.toLowerCase(Locale.ROOT).contains("invalid save manager api key")) {
            return "Invalid Save Manager API key";
        }
        if (raw.toLowerCase(Locale.ROOT).contains("exceed storage quota") && (i = raw.indexOf(123)) >= 0) {
            try {
                String s;
                JsonObject obj = new JsonParser().parse(raw.substring(i)).getAsJsonObject();
                if (obj.has("error") && (s = obj.get("error").getAsString()) != null && !s.isBlank()) {
                    return s;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return friendly;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadApiKeyFromDisk() {
        try {
            class_310 mc = class_310.method_1551();
            if (mc == null) {
                return null;
            }
            File configDir = new File(mc.field_1697, "config");
            File configFile = new File(configDir, "save-manager-settings.json");
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = this.decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            SaveManagerMod.LOGGER.error("UploadManager: error loading API key", (Throwable)e);
        }
        return null;
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(MessageDigest.getInstance("SHA-256").digest("SaveManagerSecKey.v1".getBytes(StandardCharsets.UTF_8)), "AES");
        cipher.init(2, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] pt = cipher.doFinal(ct);
        return new String(pt, StandardCharsets.UTF_8);
    }

    private static Path sm$zipWorld(Path worldDir, String worldName) throws Exception {
        Path zip = Files.createTempFile("savemanager-" + worldName + "-", ".zip", new FileAttribute[0]);
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip, StandardOpenOption.WRITE));){
            final Path base = worldDir;
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Path rel = base.relativize(file);
                        if ("session.lock".equalsIgnoreCase(rel.getFileName().toString())) {
                            return FileVisitResult.CONTINUE;
                        }
                        ZipEntry entry = new ZipEntry(rel.toString().replace('\\', '/'));
                        zos.putNextEntry(entry);
                        Files.copy(file, zos);
                        zos.closeEntry();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return zip;
    }

    @Environment(value=EnvType.CLIENT)
    private static class LocalSave {
        final Path dir;
        final String worldName;
        final long sizeBytes;
        final long lastModified;

        LocalSave(Path dir, String worldName, long sizeBytes, long lastModified) {
            this.dir = dir;
            this.worldName = worldName;
            this.sizeBytes = sizeBytes;
            this.lastModified = lastModified;
        }

        static LocalSave fromDir(Path dir) {
            String name = dir.getFileName() != null ? dir.getFileName().toString() : dir.toString();
            long lm = 0L;
            try {
                lm = Files.getLastModifiedTime(dir, new LinkOption[0]).toMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
            long size = 0L;
            try {
                size = LocalSave.computeDirSize(dir);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new LocalSave(dir, name, size, lm);
        }

        static long computeDirSize(Path dir) throws Exception {
            final long[] sum = new long[]{0L};
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        sum[0] = sum[0] + Files.size(file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return sum[0];
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class ActiveUp {
        volatile boolean active = false;
        volatile boolean zipping = false;
        volatile long uploaded = 0L;
        volatile long total = -1L;
        volatile long startNanos = 0L;
        volatile long lastTickNanos = 0L;
        volatile long lastBytes = 0L;
        volatile double speedBps = 0.0;

        private ActiveUp() {
        }
    }

    @Environment(value=EnvType.CLIENT)
    private record Geometry(int listX, int listY, int listW, int listH, int rowStartY, int rowHeight) {
    }
}

