/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.network;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class NetworkManager {
    private static final String BASE_URL = "https://choculaterie.com";
    private static final String API_KEY_HEADER = "X-Save-Key";
    private static final HttpClient INSECURE_CLIENT;
    private static final SSLSocketFactory INSECURE_SSLSF;
    private static final HostnameVerifier INSECURE_HV;
    private final HttpClient httpClient = INSECURE_CLIENT;
    private final Gson gson = new Gson();
    private String apiKey;

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiTokenGenerationUrl() {
        return "https://choculaterie.com/api/SaveManagerAPI/GenerateSaveToken";
    }

    public CompletableFuture<JsonObject> listWorldSaves() {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/list")).header(API_KEY_HEADER, this.apiKey).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    public CompletableFuture<JsonObject> uploadWorldSave(String worldName, Path zipFilePath) throws IOException {
        return this.uploadWorldSave(worldName, zipFilePath, null);
    }

    public CompletableFuture<JsonObject> uploadWorldSave(String worldName, Path zipFilePath, BiConsumer<Long, Long> progressCallback) throws IOException {
        this.validateApiKey();
        String safeWorldName = worldName == null || worldName.isBlank() ? "world" : worldName;
        String fileName = safeWorldName + ".zip";
        String boundary = "----savemanager-" + String.valueOf(UUID.randomUUID());
        return CompletableFuture.supplyAsync(() -> {
            HttpURLConnection conn = null;
            try {
                InputStream respStream;
                long total;
                long fileSize;
                boolean usingFixedLength;
                byte[] closingBytes;
                byte[] fileHdrBytes;
                byte[] metaBytes;
                block60: {
                    URL url = new URL("https://choculaterie.com/api/SaveManagerAPI/upload");
                    conn = (HttpURLConnection)url.openConnection();
                    if (conn instanceof HttpsURLConnection) {
                        try {
                            ((HttpsURLConnection)conn).setSSLSocketFactory(INSECURE_SSLSF);
                            ((HttpsURLConnection)conn).setHostnameVerifier(INSECURE_HV);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    conn.setRequestProperty(API_KEY_HEADER, this.apiKey);
                    conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    conn.setRequestProperty("Expect", "100-continue");
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(600000);
                    String partWorldName = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"WorldName\"\r\n\r\n" + safeWorldName + "\r\n";
                    String partFileHeader = "--" + boundary + "\r\nContent-Disposition: form-data; name=\"SaveFile\"; filename=\"" + fileName + "\"\r\nContent-Type: application/zip\r\n\r\n";
                    String closing = "\r\n--" + boundary + "--\r\n";
                    metaBytes = partWorldName.getBytes(StandardCharsets.UTF_8);
                    fileHdrBytes = partFileHeader.getBytes(StandardCharsets.UTF_8);
                    closingBytes = closing.getBytes(StandardCharsets.UTF_8);
                    usingFixedLength = false;
                    fileSize = -1L;
                    total = -1L;
                    try {
                        fileSize = Files.size(zipFilePath);
                        total = (long)metaBytes.length + (long)fileHdrBytes.length + fileSize + (long)closingBytes.length;
                        try {
                            conn.setFixedLengthStreamingMode(total);
                            usingFixedLength = true;
                        }
                        catch (IllegalArgumentException | NoSuchMethodError e) {
                            if (total <= Integer.MAX_VALUE) {
                                conn.setFixedLengthStreamingMode((int)total);
                                usingFixedLength = true;
                                break block60;
                            }
                            usingFixedLength = false;
                        }
                    }
                    catch (Throwable t) {
                        usingFixedLength = false;
                        fileSize = -1L;
                        total = -1L;
                    }
                }
                if (!usingFixedLength) {
                    try {
                        conn.setChunkedStreamingMode(0);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (progressCallback != null) {
                    try {
                        progressCallback.accept(0L, total);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                try (OutputStream rawOut = conn.getOutputStream();
                     BufferedOutputStream out = new BufferedOutputStream(rawOut);
                     InputStream fileIn = Files.newInputStream(zipFilePath, new OpenOption[0]);){
                    int read;
                    out.write(metaBytes);
                    out.write(fileHdrBytes);
                    out.flush();
                    byte[] buffer = new byte[65536];
                    long uploaded = 0L;
                    while ((read = fileIn.read(buffer)) != -1) {
                        try {
                            out.write(buffer, 0, read);
                            uploaded += (long)read;
                            if (progressCallback == null) continue;
                            try {
                                progressCallback.accept(uploaded, total > 0L ? total : fileSize);
                            }
                            catch (Throwable throwable) {}
                        }
                        catch (IOException io) {
                            String serverMsg = "";
                            try {
                                int code = -1;
                                try {
                                    code = conn.getResponseCode();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                InputStream err = null;
                                try {
                                    err = conn.getErrorStream();
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                if (err != null) {
                                    try (InputStream e2 = err;){
                                        byte[] eb = e2.readAllBytes();
                                        serverMsg = new String(eb, StandardCharsets.UTF_8);
                                    }
                                    catch (Throwable e2) {
                                        // empty catch block
                                    }
                                }
                                Object codePart = code == -1 ? "" : "HTTP/" + code + " ";
                                throw new IOException((String)codePart + "Error writing request body to server while streaming file. Server message: " + serverMsg, io);
                            }
                            catch (IOException re) {
                                throw re;
                            }
                            catch (Throwable t) {
                                throw new IOException("Error writing request body to server while streaming file and failed to read error stream", io);
                            }
                        }
                    }
                    out.flush();
                    out.write(closingBytes);
                    out.flush();
                }
                int status = conn.getResponseCode();
                InputStream inputStream = respStream = status >= 400 ? conn.getErrorStream() : conn.getInputStream();
                if (respStream == null) {
                    respStream = new ByteArrayInputStream(new byte[0]);
                }
                String body = new String(respStream.readAllBytes(), StandardCharsets.UTF_8);
                if (status >= 400) {
                    throw new RuntimeException("Upload failed: " + status + " - " + body);
                }
                JsonObject jsonObject = JsonParser.parseString((String)body).getAsJsonObject();
                return jsonObject;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        });
    }

    public CompletableFuture<List<String>> listWorldSaveNames() {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/names")).header(API_KEY_HEADER, this.apiKey).GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            if (response.statusCode() >= 400) {
                throw new RuntimeException("Request failed: " + response.statusCode() + " - " + (String)response.body());
            }
            String body = (String)response.body();
            Optional<String> ct = response.headers().firstValue("Content-Type");
            if (ct.map(s -> s.contains("text/html")).orElse(false).booleanValue() || body.startsWith("<!DOCTYPE")) {
                throw new RuntimeException("Unexpected HTML response from server. Check the API URL.");
            }
            JsonArray arr = JsonParser.parseString((String)body).getAsJsonArray();
            ArrayList<String> out = new ArrayList<String>();
            for (JsonElement e : arr) {
                if (e == null || !e.isJsonPrimitive()) continue;
                out.add(e.getAsString());
            }
            return out;
        });
    }

    public CompletableFuture<Path> downloadWorldSave(String saveId, Path destinationDirectory) {
        return this.downloadWorldSave(saveId, destinationDirectory, null);
    }

    public CompletableFuture<Path> downloadWorldSave(String saveId, Path destinationDirectory, BiConsumer<Long, Long> progressCallback) {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/download/" + saveId)).header(API_KEY_HEADER, this.apiKey).header("Accept-Encoding", "identity").GET().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofInputStream()).thenCompose(response -> CompletableFuture.supplyAsync(() -> {
            int status = response.statusCode();
            if (status >= 400) {
                try {
                    InputStream err = (InputStream)response.body();
                    try {
                        String body = new String(err.readAllBytes(), StandardCharsets.UTF_8);
                        throw new RuntimeException("Request failed: " + status + " - " + body);
                    }
                    catch (Throwable throwable) {
                        if (err != null) {
                            try {
                                err.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Request failed: " + status, e);
                }
            }
            long total = this.firstLongHeader((HttpResponse<?>)response, "Content-Length", "X-Content-Length", "X-File-Size", "X-Total-Length").orElse(-1L);
            if (progressCallback != null) {
                try {
                    progressCallback.accept(0L, total);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            String fileName = this.extractFileNameFromResponse((HttpResponse<?>)response);
            try {
                Files.createDirectories(destinationDirectory, new FileAttribute[0]);
                Path temp = Files.createTempFile(destinationDirectory, "download-", ".tmp", new FileAttribute[0]);
                long downloaded = 0L;
                try (InputStream in = (InputStream)response.body();
                     OutputStream out = Files.newOutputStream(temp, new OpenOption[0]);){
                    int read;
                    byte[] buffer = new byte[262144];
                    while ((read = in.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                        downloaded += (long)read;
                        if (progressCallback == null) continue;
                        try {
                            progressCallback.accept(downloaded, total);
                        }
                        catch (Throwable throwable) {}
                    }
                    out.flush();
                }
                Path finalPath = destinationDirectory.resolve(fileName);
                try {
                    Files.move(temp, finalPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception e) {
                    Files.move(temp, finalPath, StandardCopyOption.REPLACE_EXISTING);
                }
                long finalSize = Files.size(finalPath);
                if (progressCallback != null) {
                    long finalTotal = total > 0L ? total : finalSize;
                    try {
                        progressCallback.accept(finalSize, finalTotal);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return finalPath;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    private String extractFileNameFromResponse(HttpResponse<?> response) {
        String def = "world_save.zip";
        return response.headers().firstValue("Content-Disposition").map(header -> {
            String lower = header.toLowerCase(Locale.ROOT);
            int idx = lower.indexOf("filename=");
            if (idx >= 0) {
                int end;
                String raw = header.substring(idx + 9).trim();
                if (raw.startsWith("\"") && (end = raw.indexOf(34, 1)) > 1) {
                    return raw.substring(1, end);
                }
                int semi = raw.indexOf(59);
                String v = (semi >= 0 ? raw.substring(0, semi) : raw).replace("\"", "").trim();
                if (!v.isEmpty()) {
                    return v;
                }
            }
            return def;
        }).orElse(def);
    }

    private Optional<Long> firstLongHeader(HttpResponse<?> response, String ... names) {
        for (String n : names) {
            Optional<String> v = response.headers().firstValue(n);
            if (!v.isPresent()) continue;
            try {
                return Optional.of(Long.parseLong(v.get().trim()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public CompletableFuture<JsonObject> deleteWorldSave(String saveId) {
        this.validateApiKey();
        HttpRequest req = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/SaveManagerAPI/delete/" + saveId)).header(API_KEY_HEADER, this.apiKey).DELETE().build();
        return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(this::handleJsonResponse);
    }

    private void validateApiKey() {
        if (this.apiKey == null || this.apiKey.isEmpty()) {
            throw new IllegalStateException("API key is not set");
        }
    }

    private JsonObject handleJsonResponse(HttpResponse<String> response) {
        if (response.statusCode() >= 400) {
            throw new RuntimeException("Request failed: " + response.statusCode() + " - " + response.body());
        }
        Optional<String> ct = response.headers().firstValue("Content-Type");
        String body = response.body();
        if (ct.map(s -> s.contains("text/html")).orElse(false).booleanValue() || body.startsWith("<!DOCTYPE")) {
            throw new RuntimeException("Unexpected HTML response from server. Check the API URL.");
        }
        return JsonParser.parseString((String)body).getAsJsonObject();
    }

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext ssl = SSLContext.getInstance("TLS");
            ssl.init(null, trustAllCerts, new SecureRandom());
            try {
                SSLContext.setDefault(ssl);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            INSECURE_CLIENT = HttpClient.newBuilder().sslContext(ssl).followRedirects(HttpClient.Redirect.NORMAL).build();
            INSECURE_SSLSF = ssl.getSocketFactory();
            INSECURE_HV = (hostname, session) -> true;
            try {
                HttpsURLConnection.setDefaultSSLSocketFactory(INSECURE_SSLSF);
                HttpsURLConnection.setDefaultHostnameVerifier(INSECURE_HV);
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize HttpClient with custom SSL context", e);
        }
    }
}

