/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.network.NetworkManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_526;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class AccountLinkingScreen
extends class_437 {
    private final class_437 parent;
    private class_342 tokenField;
    private String statusMessage = "";
    private final NetworkManager networkManager;
    private boolean passwordVisible = false;
    private boolean maskingProviderInstalled = false;
    private class_4185 visibilityButton;
    private class_4185 resetButton;
    private String realToken = "";
    private boolean lastEmptyState = true;
    private static final String CONFIG_FILE = "save-manager-settings.json";
    private static final String KEY_MATERIAL = "SaveManagerSecKey.v1";
    private static final byte[] AES_KEY;
    private static final int GCM_TAG_BITS = 128;
    private static final int IV_LEN = 12;
    private static final SecureRandom RNG;

    public AccountLinkingScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Link Your Account"));
        this.parent = parent;
        this.networkManager = new NetworkManager();
    }

    protected void method_25426() {
        boolean empty;
        int cx = this.field_22789 / 2;
        int fieldW = 200;
        int eyeW = 25;
        int resetW = 50;
        int gap = 6;
        int groupW = fieldW + gap + eyeW + gap + resetW;
        int groupLeft = cx - groupW / 2;
        int fieldY = this.field_22790 / 2 - 10;
        int actionY = fieldY + 30;
        this.tokenField = new class_342(this.field_22793, groupLeft, fieldY, fieldW, 20, (class_2561)class_2561.method_43470((String)"API Key"));
        this.tokenField.method_1880(Integer.MAX_VALUE);
        this.tokenField.method_1863(s -> {
            boolean isEmptyNow;
            if (this.isEffectivelyVisible() || this.maskingProviderInstalled) {
                String string = this.realToken = s != null ? s : "";
            }
            if ((isEmptyNow = this.isTokenEmpty()) != this.lastEmptyState) {
                this.lastEmptyState = isEmptyNow;
                this.applyMasking();
                this.updateResetButton();
            }
        });
        this.method_25429((class_364)this.tokenField);
        this.method_48265((class_364)this.tokenField);
        this.visibilityButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)""), b -> {
            this.passwordVisible = !this.passwordVisible;
            this.applyMasking();
            this.updateResetButton();
        }).method_46434(groupLeft + fieldW + gap, fieldY, eyeW, 20).method_46431();
        this.method_37063((class_364)this.visibilityButton);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), b -> {
            if (this.isTokenEmpty()) {
                this.openApiKeyWebsite();
            } else {
                this.resetApiKeyAndOpenLink();
            }
        }).method_46434(groupLeft + fieldW + gap + eyeW + gap, fieldY, resetW, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        int actionW = 95;
        int actionGap = 10;
        int actionsGroupW = actionW + actionGap + actionW;
        int actionsLeft = cx - actionsGroupW / 2;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), b -> this.saveApiKey(this.getApiKeyForSave())).method_46434(actionsLeft, actionY, actionW, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), b -> {
            if (this.field_22787 != null) {
                class_437 rootParent = AccountLinkingScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new class_526(rootParent));
            }
        }).method_46434(actionsLeft + actionW + actionGap, actionY, actionW, 20).method_46431());
        this.loadSavedApiKey();
        this.lastEmptyState = empty = this.isTokenEmpty();
        this.passwordVisible = empty;
        this.applyMasking();
        this.updateResetButton();
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.method_41843();
    }

    private void applyMasking() {
        boolean providerOk;
        boolean effectiveVisible = this.isEffectivelyVisible();
        if (this.visibilityButton != null) {
            this.visibilityButton.method_25355((class_2561)class_2561.method_43470((String)"\ud83d\udc41"));
        }
        this.maskingProviderInstalled = providerOk = effectiveVisible ? this.installClearTextProviderReflectively() : this.installMaskingProviderReflectively();
        if (providerOk) {
            this.tokenField.method_1852(this.realToken);
            return;
        }
        if (effectiveVisible) {
            this.tokenField.method_1852(this.realToken);
        } else {
            this.tokenField.method_1852(AccountLinkingScreen.mask(this.realToken.length()));
        }
    }

    private boolean isTokenEmpty() {
        if (this.maskingProviderInstalled || this.passwordVisible) {
            String t = this.tokenField == null ? "" : this.tokenField.method_1882();
            return t == null || t.isEmpty();
        }
        return this.realToken == null || this.realToken.isEmpty();
    }

    private void updateResetButton() {
        if (this.resetButton != null) {
            boolean empty = this.isTokenEmpty();
            this.resetButton.method_25355((class_2561)class_2561.method_43470((String)(empty ? "Link" : "Reset")));
        }
    }

    private boolean isEffectivelyVisible() {
        return this.passwordVisible || this.isTokenEmpty();
    }

    private boolean installMaskingProviderReflectively() {
        try {
            BiFunction<String, Integer, class_5481> provider = (text, firstIndex) -> {
                String s = text == null ? "" : text;
                String masked = s.isEmpty() ? "" : AccountLinkingScreen.mask(s.length());
                int start = Math.min(Math.max(firstIndex, 0), masked.length());
                return class_2561.method_43470((String)masked.substring(start)).method_30937();
            };
            Method m = class_342.class.getMethod("setRenderTextProvider", BiFunction.class);
            m.invoke((Object)this.tokenField, provider);
            return true;
        }
        catch (Throwable provider) {
            try {
                Function<String, class_5481> provider2 = s -> {
                    String str = s == null ? "" : s;
                    return class_2561.method_43470((String)(str.isEmpty() ? "" : AccountLinkingScreen.mask(str.length()))).method_30937();
                };
                Method m = class_342.class.getMethod("setRenderTextProvider", Function.class);
                m.invoke((Object)this.tokenField, provider2);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    private boolean installClearTextProviderReflectively() {
        try {
            BiFunction<String, Integer, class_5481> provider = (text, firstIndex) -> {
                String s = text == null ? "" : text;
                int start = Math.min(Math.max(firstIndex, 0), s.length());
                return class_2561.method_43470((String)s.substring(start)).method_30937();
            };
            Method m = class_342.class.getMethod("setRenderTextProvider", BiFunction.class);
            m.invoke((Object)this.tokenField, provider);
            return true;
        }
        catch (Throwable provider) {
            try {
                Function<String, class_5481> provider2 = s -> class_2561.method_43470((String)(s == null ? "" : s)).method_30937();
                Method m = class_342.class.getMethod("setRenderTextProvider", Function.class);
                m.invoke((Object)this.tokenField, provider2);
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }

    private void resetApiKeyAndOpenLink() {
        block17: {
            try {
                this.passwordVisible = true;
                this.realToken = "";
                this.lastEmptyState = true;
                this.applyMasking();
                this.networkManager.setApiKey(null);
                this.statusMessage = "API key cleared";
                File configDir = new File(this.field_22787.field_1697, "config");
                File configFile = new File(configDir, CONFIG_FILE);
                if (!configFile.exists()) break block17;
                boolean keptFile = false;
                JsonObject json = null;
                try (FileReader reader = new FileReader(configFile);){
                    json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                }
                catch (Exception readEx) {
                    SaveManagerMod.LOGGER.warn("Failed reading config; deleting file", (Throwable)readEx);
                }
                if (json != null) {
                    json.remove("encryptedApiToken");
                    json.remove("apiToken");
                    if (!json.entrySet().isEmpty()) {
                        try (FileWriter writer = new FileWriter(configFile);){
                            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                            keptFile = true;
                        }
                    }
                }
                if (!keptFile) {
                    configFile.delete();
                }
            }
            catch (Exception e) {
                SaveManagerMod.LOGGER.error("Error clearing API key", (Throwable)e);
                this.statusMessage = "Error clearing API key";
            }
        }
        this.openApiKeyWebsite();
    }

    private void loadSavedApiKey() {
        block13: {
            try {
                File configDir = new File(this.field_22787.field_1697, "config");
                File configFile = new File(configDir, CONFIG_FILE);
                if (!configFile.exists()) break block13;
                try (FileReader reader = new FileReader(configFile);){
                    JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    if (json != null) {
                        String token = null;
                        if (json.has("encryptedApiToken")) {
                            token = this.decrypt(json.get("encryptedApiToken").getAsString());
                            this.statusMessage = "API key loaded";
                        } else if (json.has("apiToken")) {
                            token = json.get("apiToken").getAsString();
                            this.statusMessage = "API key loaded (plain)";
                        } else {
                            this.statusMessage = "No saved API key";
                        }
                        if (token != null) {
                            this.realToken = token;
                            this.networkManager.setApiKey(token);
                        }
                    }
                }
            }
            catch (Exception e) {
                SaveManagerMod.LOGGER.error("Error loading API key", (Throwable)e);
                this.statusMessage = "Error loading saved API key";
            }
        }
    }

    private void saveApiKey(String apiKey) {
        try {
            if (apiKey == null || apiKey.isEmpty()) {
                this.networkManager.setApiKey(null);
                File configDir = new File(this.field_22787.field_1697, "config");
                File configFile = new File(configDir, CONFIG_FILE);
                if (configFile.exists()) {
                    boolean keptFile = false;
                    JsonObject json = null;
                    try (FileReader reader = new FileReader(configFile);){
                        json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                    }
                    catch (Exception readEx) {
                        SaveManagerMod.LOGGER.warn("Failed reading config; deleting file", (Throwable)readEx);
                    }
                    if (json != null) {
                        json.remove("encryptedApiToken");
                        json.remove("apiToken");
                        if (!json.entrySet().isEmpty()) {
                            try (FileWriter writer = new FileWriter(configFile);){
                                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
                                keptFile = true;
                            }
                        }
                    }
                    if (!keptFile) {
                        configFile.delete();
                    }
                }
                this.statusMessage = "API key cleared";
                SaveManagerMod.LOGGER.info("API key cleared");
                if (this.field_22787 != null) {
                    class_437 rootParent = AccountLinkingScreen.sm$resolveWorldRootParent(this.parent);
                    this.field_22787.method_1507((class_437)new class_526(rootParent));
                }
                return;
            }
            this.networkManager.setApiKey(apiKey);
            String encrypted = this.encrypt(apiKey);
            File configDir = new File(this.field_22787.field_1697, "config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File configFile = new File(configDir, CONFIG_FILE);
            JsonObject json = new JsonObject();
            json.addProperty("encryptedApiToken", encrypted);
            try (FileWriter writer = new FileWriter(configFile);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
            }
            this.statusMessage = "API key saved";
            SaveManagerMod.LOGGER.info("API key saved (encrypted)");
            if (this.field_22787 != null) {
                class_437 rootParent = AccountLinkingScreen.sm$resolveWorldRootParent(this.parent);
                this.field_22787.method_1507((class_437)new class_526(rootParent));
            }
        }
        catch (Exception e) {
            this.statusMessage = "Error: " + e.getMessage();
            SaveManagerMod.LOGGER.error("Error saving API key", (Throwable)e);
        }
    }

    private String getApiKeyForSave() {
        return this.passwordVisible || this.maskingProviderInstalled ? this.tokenField.method_1882() : this.realToken;
    }

    private static String mask(int len) {
        if (len <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            sb.append('*');
        }
        return sb.toString();
    }

    private String encrypt(String input) throws Exception {
        byte[] iv = new byte[12];
        RNG.nextBytes(iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(AES_KEY, "AES");
        cipher.init(1, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] ct = cipher.doFinal(input.getBytes(StandardCharsets.UTF_8));
        byte[] out = new byte[iv.length + ct.length];
        System.arraycopy(iv, 0, out, 0, iv.length);
        System.arraycopy(ct, 0, out, iv.length, ct.length);
        return Base64.getEncoder().encodeToString(out);
    }

    private String decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid data");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(AES_KEY, "AES");
        cipher.init(2, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] pt = cipher.doFinal(ct);
        return new String(pt, StandardCharsets.UTF_8);
    }

    private void openApiKeyWebsite() {
        try {
            class_156.method_668().method_670(this.networkManager.getApiTokenGenerationUrl());
        }
        catch (Exception e) {
            this.statusMessage = "Could not open browser";
            SaveManagerMod.LOGGER.error("Failed to open API key website", (Throwable)e);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int cx = this.field_22789 / 2;
        int fieldY = this.field_22790 / 2 - 10;
        int actionY = fieldY + 30;
        int statusY = actionY + 26;
        context.method_27534(this.field_22793, this.field_22785, cx, 10, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Enter your API key to link your account"), cx, fieldY - 14, -5592406);
        if (!this.statusMessage.isEmpty()) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.statusMessage), cx, statusY, -1);
        }
        if (this.maskingProviderInstalled) {
            this.tokenField.method_1852(this.realToken);
        } else {
            this.tokenField.method_1852(this.isEffectivelyVisible() ? this.realToken : AccountLinkingScreen.mask(this.realToken.length()));
        }
        this.tokenField.method_25394(context, mouseX, mouseY, delta);
    }

    private static class_437 sm$resolveWorldRootParent(class_437 parent) {
        class_437 p = parent;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    static {
        RNG = new SecureRandom();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            AES_KEY = md.digest(KEY_MATERIAL.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init crypto key", e);
        }
    }
}

