/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.mixin;

import com.choculaterie.SaveManagerMod;
import com.choculaterie.gui.AccountLinkingScreen;
import com.choculaterie.gui.CloudSaveManagerScreen;
import com.choculaterie.network.NetworkManager;
import com.choculaterie.util.SelectedWorld;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_526;
import net.minecraft.class_528;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_526.class})
public abstract class SinglePlayerScreenMixin
extends class_437 {
    @Shadow
    protected class_342 field_3220;
    @Unique
    private class_4185 saveManagerLinkBtn;
    @Unique
    private class_4185 uploadSaveBtn;
    @Unique
    private class_4185 cloudSavesBtn;
    @Unique
    private static final int ICON_SIZE = 20;
    @Unique
    private static final int GAP = 4;
    @Unique
    private static final String CONFIG_FILE = "save-manager-settings.json";
    @Unique
    private static final String KEY_MATERIAL = "SaveManagerSecKey.v1";
    @Unique
    private static final byte[] AES_KEY = SinglePlayerScreenMixin.sm$deriveKey("SaveManagerSecKey.v1");
    @Unique
    private static final int GCM_TAG_BITS = 128;
    @Unique
    private final NetworkManager savemanager$net = new NetworkManager();
    @Unique
    private static volatile boolean upActive = false;
    @Unique
    private static volatile boolean upZipping = false;
    @Unique
    private static volatile long upUploaded = 0L;
    @Unique
    private static volatile long upTotal = -1L;
    @Unique
    private static volatile long upStartNanos = 0L;
    @Unique
    private static volatile long upLastTickNanos = 0L;
    @Unique
    private static volatile long upLastBytes = 0L;
    @Unique
    private static volatile double upSpeedBps = 0.0;
    @Unique
    private volatile boolean sm$pendingZip = false;
    @Unique
    private volatile boolean sm$zipStarted = false;
    @Unique
    private Path sm$pendingWorldDir = null;
    @Unique
    private String sm$pendingWorldName = null;
    @Unique
    private List<class_4185> sm$bottomButtons = new ArrayList<class_4185>();
    @Unique
    private Map<class_4185, Boolean> sm$bottomPrevVisible = new HashMap<class_4185, Boolean>();
    @Unique
    private Map<class_4185, Boolean> sm$bottomPrevActive = new HashMap<class_4185, Boolean>();
    @Unique
    private boolean sm$bottomHidden = false;
    @Unique
    private static volatile String sm$apiKey = null;
    @Unique
    private class_437 parent;

    protected SinglePlayerScreenMixin(class_2561 title, class_437 parent) {
        super(title);
        this.parent = parent;
    }

    @Unique
    private static boolean sm$isUploading() {
        return upActive;
    }

    @Unique
    private void sm$collectBottomButtons() {
        this.sm$bottomButtons.clear();
        int topThresholdY = this.field_22790 - 70;
        int bottomThresholdY = this.field_22790 - 20;
        try {
            String[] listFieldNames;
            for (String fname : listFieldNames = new String[]{"drawables", "children", "selectables", "drawableChildren", "renderables", "buttons", "buttonList"}) {
                for (Class<?> c = ((Object)((Object)this)).getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                    try {
                        Field f = c.getDeclaredField(fname);
                        f.setAccessible(true);
                        Object val = f.get((Object)this);
                        if (!(val instanceof List)) continue;
                        List list = (List)val;
                        for (Object o : list) {
                            boolean isBottomByPos;
                            String lc;
                            if (!(o instanceof class_4185)) continue;
                            class_4185 b = (class_4185)o;
                            int by = -1;
                            int bh = -1;
                            try {
                                by = (Integer)b.getClass().getMethod("getY", new Class[0]).invoke((Object)b, new Object[0]);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (by < 0) {
                                try {
                                    Field fy = b.getClass().getDeclaredField("y");
                                    fy.setAccessible(true);
                                    by = fy.getInt(b);
                                }
                                catch (Throwable fy) {
                                    // empty catch block
                                }
                            }
                            try {
                                bh = (Integer)b.getClass().getMethod("getHeight", new Class[0]).invoke((Object)b, new Object[0]);
                            }
                            catch (Throwable fy) {
                                // empty catch block
                            }
                            if (bh < 0) {
                                try {
                                    Field fh = b.getClass().getDeclaredField("height");
                                    fh.setAccessible(true);
                                    bh = fh.getInt(b);
                                }
                                catch (Throwable fh) {
                                    // empty catch block
                                }
                            }
                            int bottom = (by >= 0 ? by : 0) + Math.max(0, bh);
                            String label = null;
                            try {
                                Object msg = b.getClass().getMethod("getMessage", new Class[0]).invoke((Object)b, new Object[0]);
                                if (msg instanceof class_2561) {
                                    class_2561 t = (class_2561)msg;
                                    label = t.getString();
                                } else if (msg != null) {
                                    label = String.valueOf(msg);
                                }
                            }
                            catch (Throwable msg) {
                                // empty catch block
                            }
                            boolean matchesLabel = false;
                            if (label != null && ((lc = label.toLowerCase()).contains("create new world") || lc.contains("play selected world") || lc.equals("back") || lc.equals("done") || lc.equals("cancel"))) {
                                matchesLabel = true;
                            }
                            boolean bl = isBottomByPos = by >= topThresholdY || bottom >= bottomThresholdY;
                            if (!matchesLabel && !isBottomByPos || this.sm$bottomButtons.contains(b)) continue;
                            this.sm$bottomButtons.add(b);
                        }
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void sm$hideBottomButtons() {
        if (this.sm$bottomHidden) {
            return;
        }
        this.sm$collectBottomButtons();
        for (class_4185 b : this.sm$bottomButtons) {
            try {
                this.sm$bottomPrevVisible.put(b, b.field_22764);
                this.sm$bottomPrevActive.put(b, b.field_22763);
                b.field_22764 = false;
                b.field_22763 = false;
            }
            catch (Throwable throwable) {}
        }
        this.sm$bottomHidden = true;
    }

    @Unique
    private void sm$restoreBottomButtons() {
        if (!this.sm$bottomHidden) {
            return;
        }
        this.sm$collectBottomButtons();
        for (class_4185 b : this.sm$bottomButtons) {
            try {
                Boolean prevV = this.sm$bottomPrevVisible.get(b);
                Boolean prevA = this.sm$bottomPrevActive.get(b);
                b.field_22764 = prevV == null ? true : prevV;
                b.field_22763 = prevA == null ? b.field_22763 : prevA;
            }
            catch (Throwable throwable) {}
        }
        this.sm$bottomPrevVisible.clear();
        this.sm$bottomPrevActive.clear();
        this.sm$bottomHidden = false;
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    private void savemanager$init(CallbackInfo ci) {
        this.parent = this;
        this.uploadSaveBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcbe"), b -> this.savemanager$confirmThenUploadSelected()).method_46434(0, 0, 20, 20).method_46431();
        this.uploadSaveBtn.field_22763 = false;
        this.method_37063((class_364)this.uploadSaveBtn);
        this.cloudSavesBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), b -> {
            String apiKey = SinglePlayerScreenMixin.sm$loadApiKey(this.field_22787);
            if (apiKey == null || apiKey.isBlank()) {
                class_437 rootParent = SinglePlayerScreenMixin.sm$resolveWorldRootParent(this);
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
            } else {
                sm$apiKey = apiKey;
                try {
                    this.savemanager$net.setApiKey(apiKey);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.field_22787.method_1507((class_437)new CloudSaveManagerScreen(this));
            }
        }).method_46434(0, 0, 20, 20).method_46431();
        this.method_37063((class_364)this.cloudSavesBtn);
        this.method_37060(this::savemanager$frameUpdate);
        try {
            this.savemanager$repositionButtons();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.sm$collectBottomButtons();
            if (SinglePlayerScreenMixin.sm$isUploading()) {
                if (this.uploadSaveBtn != null) {
                    this.uploadSaveBtn.field_22763 = false;
                }
                this.sm$hideBottomButtons();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void savemanager$frameUpdate(class_332 ctx, int mouseX, int mouseY, float delta) {
        this.savemanager$repositionButtons();
        if (this.uploadSaveBtn != null) {
            boolean bl = this.uploadSaveBtn.field_22763 = this.sm$hasSelection() && !SinglePlayerScreenMixin.sm$isUploading();
        }
        if (SinglePlayerScreenMixin.sm$isUploading()) {
            this.sm$hideBottomButtons();
        } else {
            this.sm$restoreBottomButtons();
        }
        if (SinglePlayerScreenMixin.sm$isUploading()) {
            int baseY;
            int cx = this.field_22789 / 2;
            int statusY = baseY = this.field_22790 - 50;
            if (upZipping) {
                ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Zipping..."), cx, statusY, -1);
                int radius = 8;
                int dots = 12;
                int cx0 = this.field_22789 / 2;
                int cy0 = statusY + 24;
                long t = System.currentTimeMillis();
                int head = (int)(t / 100L % (long)dots);
                for (int i = 0; i < dots; ++i) {
                    double ang = Math.PI * 2 * (double)i / (double)dots;
                    int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                    int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                    int x = cx0 + dx;
                    int y = cy0 + dy;
                    int dist = (i - head + dots) % dots;
                    int alpha = switch (dist) {
                        case 0 -> 255;
                        case 1 -> 204;
                        case 2 -> 153;
                        case 3 -> 102;
                        default -> 51;
                    };
                    int col = alpha << 24 | 0xCCCCCC;
                    ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                }
            } else {
                boolean finishingStall;
                long uploaded = upUploaded;
                long total = upTotal;
                double speed = upSpeedBps;
                boolean knownTotals = total > 0L && uploaded >= 0L;
                boolean nearlyDone = knownTotals && uploaded < total && uploaded >= Math.max(0L, (long)Math.floor((double)total * 0.99));
                long nowNs = System.nanoTime();
                long sinceLastProgressNs = upLastTickNanos > 0L ? nowNs - upLastTickNanos : Long.MAX_VALUE;
                boolean bl = finishingStall = nearlyDone && sinceLastProgressNs > 1500000000L;
                if (finishingStall) {
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Finishing..."), cx, statusY, -1);
                    int radius = 8;
                    int dots = 12;
                    int cx0 = this.field_22789 / 2;
                    int cy0 = statusY + 24;
                    long t = System.currentTimeMillis();
                    int head = (int)(t / 100L % (long)dots);
                    for (int i = 0; i < dots; ++i) {
                        double ang = Math.PI * 2 * (double)i / (double)dots;
                        int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                        int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                        int x = cx0 + dx;
                        int y = cy0 + dy;
                        int dist = (i - head + dots) % dots;
                        int alpha = switch (dist) {
                            case 0 -> 255;
                            case 1 -> 204;
                            case 2 -> 153;
                            case 3 -> 102;
                            default -> 51;
                        };
                        int col = alpha << 24 | 0xCCCCCC;
                        ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                    }
                } else if (knownTotals) {
                    int barW = 360;
                    int barH = 8;
                    int bx = cx - barW / 2;
                    int by = statusY + 14;
                    ctx.method_25294(bx, by, bx + barW, by + barH, -12303292);
                    double frac = Math.min(1.0, (double)uploaded / (double)total);
                    int filled = (int)((double)barW * frac);
                    ctx.method_25294(bx, by, bx + filled, by + barH, -3355444);
                    int pct = (int)Math.min(100.0, Math.floor((double)uploaded * 100.0 / (double)total));
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)(pct + "%")), cx, by - 10, -1);
                    String info = SinglePlayerScreenMixin.formatBytes(uploaded) + " / " + SinglePlayerScreenMixin.formatBytes(total);
                    if (speed > 1.0) {
                        String sp = SinglePlayerScreenMixin.formatBytes((long)speed) + "/s";
                        long remaining = Math.max(0L, total - uploaded);
                        long etaSec = Math.max(0L, (long)Math.ceil((double)remaining / Math.max(1.0, speed)));
                        info = info + " \u2022 " + sp + " \u2022 ETA " + SinglePlayerScreenMixin.formatDurationShort(etaSec);
                    }
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)info), cx, by + barH + 2, -3355444);
                } else {
                    ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Uploading..."), cx, statusY, -1);
                    int radius = 8;
                    int dots = 12;
                    int cx0 = this.field_22789 / 2;
                    int cy0 = statusY + 24;
                    long t = System.currentTimeMillis();
                    int head = (int)(t / 100L % (long)dots);
                    for (int i = 0; i < dots; ++i) {
                        double ang = Math.PI * 2 * (double)i / (double)dots;
                        int dx = (int)Math.round(Math.cos(ang) * (double)radius);
                        int dy = (int)Math.round(Math.sin(ang) * (double)radius);
                        int x = cx0 + dx;
                        int y = cy0 + dy;
                        int dist = (i - head + dots) % dots;
                        int alpha = switch (dist) {
                            case 0 -> 255;
                            case 1 -> 204;
                            case 2 -> 153;
                            case 3 -> 102;
                            default -> 51;
                        };
                        int col = alpha << 24 | 0xCCCCCC;
                        ctx.method_25294(x - 1, y - 1, x + 2, y + 2, col);
                    }
                }
            }
        }
        if (this.sm$pendingZip && !this.sm$zipStarted) {
            this.sm$zipStarted = true;
            Path dir = this.sm$pendingWorldDir;
            String wname = this.sm$pendingWorldName;
            new Thread(() -> {
                try {
                    Path zip = SinglePlayerScreenMixin.sm$zipWorld(dir, wname == null ? "world" : wname.replaceAll("[\\\\/:*?\"<>|]+", "_"));
                    this.sm$uploadZipDirect(zip, wname, this.savemanager$net);
                }
                catch (Exception e) {
                    SaveManagerMod.LOGGER.error("(savemanager) Failed zipping world", (Throwable)e);
                    upActive = false;
                    upZipping = false;
                    this.field_22787.execute(() -> this.field_22787.method_1507((class_437)new class_410(b -> this.field_22787.method_1507((class_437)((class_526)this)), (class_2561)class_2561.method_43470((String)"Upload Failed"), (class_2561)class_2561.method_43470((String)"Failed to prepare world zip"))));
                }
                finally {
                    this.sm$pendingZip = false;
                    this.sm$pendingWorldDir = null;
                    this.sm$pendingWorldName = null;
                }
            }, "SaveManager-zip").start();
        }
    }

    @Unique
    private void sm$beginZipOnNextFrame(String worldName, Path worldDir) {
        try {
            if (sm$apiKey != null) {
                this.savemanager$net.setApiKey(sm$apiKey);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        upActive = true;
        upZipping = true;
        upUploaded = 0L;
        upTotal = -1L;
        upLastTickNanos = upStartNanos = System.nanoTime();
        upLastBytes = 0L;
        upSpeedBps = 0.0;
        this.sm$pendingWorldName = worldName;
        this.sm$pendingWorldDir = worldDir;
        this.sm$pendingZip = true;
        this.sm$zipStarted = false;
        try {
            this.field_22787.execute(() -> {});
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Unique
    private void sm$uploadZipDirect(Path zipFinal, String origWorldName, NetworkManager savemanager$net) {
        block6: {
            try {
                upZipping = false;
                upActive = true;
                upUploaded = 0L;
                upTotal = -1L;
                upLastTickNanos = upStartNanos = System.nanoTime();
                upLastBytes = 0L;
                upSpeedBps = 0.0;
                try {
                    this.field_22787.execute(() -> {});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                savemanager$net.uploadWorldSave(origWorldName, zipFinal, (sent, total) -> {
                    upUploaded = Math.max(0L, sent);
                    if (total > 0L) {
                        upTotal = total;
                    }
                    long now = System.nanoTime();
                    long dtNs = now - upLastTickNanos;
                    long dBytes = upUploaded - upLastBytes;
                    if (dtNs > 50000000L) {
                        double instBps = dBytes > 0L ? (double)dBytes * 1.0E9 / (double)dtNs : 0.0;
                        double alpha = 0.2;
                        upSpeedBps = upSpeedBps <= 0.0 ? instBps : alpha * instBps + (1.0 - alpha) * upSpeedBps;
                        upLastTickNanos = now;
                        upLastBytes = upUploaded;
                    }
                    try {
                        this.field_22787.execute(() -> {});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }).whenComplete((json, uploadErr) -> {
                    try {
                        Files.deleteIfExists(zipFinal);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (this.field_22787 == null) {
                        return;
                    }
                    this.field_22787.execute(() -> {
                        upActive = false;
                        upZipping = false;
                        upUploaded = 0L;
                        upTotal = -1L;
                        upStartNanos = 0L;
                        upLastBytes = 0L;
                        upLastTickNanos = 0L;
                        upSpeedBps = 0.0;
                        if (uploadErr != null) {
                            SaveManagerMod.LOGGER.error("(savemanager) Upload failed for \"{}\"", (Object)origWorldName, uploadErr);
                            String raw = SinglePlayerScreenMixin.sm$rawFromThrowable(uploadErr);
                            this.sm$showErrorDialog(raw, "Upload failed");
                            return;
                        }
                        this.sm$openFreshSelectWorld();
                    });
                });
            }
            catch (Throwable t) {
                try {
                    Files.deleteIfExists(zipFinal);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SaveManagerMod.LOGGER.error("(savemanager) Upload error for \"{}\"", (Object)origWorldName, (Object)t);
                if (this.field_22787 == null) break block6;
                String raw = SinglePlayerScreenMixin.sm$rawFromThrowable(t);
                this.field_22787.execute(() -> this.sm$showErrorDialog(raw, "Upload failed"));
            }
        }
    }

    @Unique
    private void savemanager$repositionButtons() {
        int w;
        int h;
        int y;
        int x;
        block25: {
            x = 6;
            y = 6;
            h = 20;
            w = 0;
            try {
                Field f2;
                if (this.field_3220 == null) break block25;
                try {
                    x = (Integer)this.field_3220.getClass().getMethod("getX", new Class[0]).invoke((Object)this.field_3220, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    y = (Integer)this.field_3220.getClass().getMethod("getY", new Class[0]).invoke((Object)this.field_3220, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    w = (Integer)this.field_3220.getClass().getMethod("getWidth", new Class[0]).invoke((Object)this.field_3220, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    h = (Integer)this.field_3220.getClass().getMethod("getHeight", new Class[0]).invoke((Object)this.field_3220, new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    f2 = this.field_3220.getClass().getDeclaredField("x");
                    f2.setAccessible(true);
                    x = f2.getInt(this.field_3220);
                }
                catch (Throwable f2) {
                    // empty catch block
                }
                try {
                    f2 = this.field_3220.getClass().getDeclaredField("y");
                    f2.setAccessible(true);
                    y = f2.getInt(this.field_3220);
                }
                catch (Throwable f3) {
                    // empty catch block
                }
                if (w == 0) {
                    try {
                        f2 = this.field_3220.getClass().getDeclaredField("width");
                        f2.setAccessible(true);
                        w = f2.getInt(this.field_3220);
                    }
                    catch (Throwable f4) {
                        // empty catch block
                    }
                }
                try {
                    f2 = this.field_3220.getClass().getDeclaredField("height");
                    f2.setAccessible(true);
                    h = f2.getInt(this.field_3220);
                }
                catch (Throwable f5) {}
            }
            catch (Throwable f5) {
                // empty catch block
            }
        }
        int iconY = y + Math.max(0, (h - 20) / 2);
        if (this.uploadSaveBtn != null) {
            int uploadX = x + w + 4;
            try {
                this.uploadSaveBtn.method_48229(uploadX, iconY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.uploadSaveBtn.field_22764 = true;
        }
        if (this.cloudSavesBtn != null) {
            int cloudX = x + w + 4 + 20 + 4;
            try {
                this.cloudSavesBtn.method_48229(cloudX, iconY);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cloudSavesBtn.field_22764 = true;
        }
    }

    @Unique
    private static boolean sm$isInvalidKey(String raw, String friendly) {
        String r = (raw == null ? "" : raw).toLowerCase(Locale.ROOT);
        if (friendly != null && friendly.equalsIgnoreCase("Invalid Save Manager API key")) {
            return true;
        }
        return r.contains("401") && r.contains("invalid save manager api key");
    }

    @Unique
    private boolean sm$hasSelection() {
        return this.sm$getSelectedWorld() != null;
    }

    @Unique
    private SelectedWorld sm$getSelectedWorld() {
        try {
            Path candidate;
            class_528 list = this.sm$getWorldList();
            if (list == null) {
                return null;
            }
            Object entry = this.sm$getSelectedEntry(list);
            if (entry == null) {
                return null;
            }
            String dirName = this.sm$getWorldDirNameFromEntry(entry);
            String display = this.sm$getWorldDisplayNameFromEntry(entry);
            if (display == null) {
                display = "";
            }
            if (dirName != null && !dirName.isEmpty() && Files.exists(candidate = this.field_22787.field_1697.toPath().resolve("saves").resolve(dirName), new LinkOption[0])) {
                return new SelectedWorld(candidate, display);
            }
            try {
                Path saves = this.field_22787.field_1697.toPath().resolve("saves");
                if (Files.exists(saves, new LinkOption[0]) && Files.isDirectory(saves, new LinkOption[0])) {
                    String displaySan = display == null ? "" : display.trim();
                    for (Path p : Files.newDirectoryStream(saves)) {
                        if (!Files.isDirectory(p, new LinkOption[0])) continue;
                        String fn = p.getFileName().toString();
                        if (dirName != null && dirName.equals(fn)) {
                            return new SelectedWorld(p, display);
                        }
                        if (!displaySan.isEmpty() && (fn.equals(displaySan) || fn.equalsIgnoreCase(displaySan))) {
                            return new SelectedWorld(p, display);
                        }
                        String loose = displaySan.replaceAll("[\\\\/:*?\"<>|]+", "_");
                        if (loose.isEmpty() || !fn.equals(loose)) continue;
                        return new SelectedWorld(p, display);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable t) {
            SaveManagerMod.LOGGER.warn("(savemanager) sm$getSelectedWorld reflection error", t);
        }
        return null;
    }

    @Unique
    private class_528 sm$getWorldList() {
        try {
            Object val;
            for (Class<?> c = ((Object)((Object)this)).getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
                for (Field f : c.getDeclaredFields()) {
                    Class<?> t = f.getType();
                    if (t == null || !class_528.class.isAssignableFrom(t)) continue;
                    f.setAccessible(true);
                    val = f.get((Object)this);
                    if (val == null) continue;
                    return (class_528)val;
                }
            }
            Class<class_526> sw = class_526.class;
            for (Field f : sw.getDeclaredFields()) {
                if (!class_528.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                val = f.get((Object)this);
                if (val == null) continue;
                return (class_528)val;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    @Unique
    private Object sm$getSelectedEntry(class_528 list) {
        try {
            return class_528.class.getMethod("getSelectedOrNull", new Class[0]).invoke((Object)list, new Object[0]);
        }
        catch (Throwable throwable) {
            try {
                return class_528.class.getMethod("getSelected", new Class[0]).invoke((Object)list, new Object[0]);
            }
            catch (Throwable throwable2) {
                return null;
            }
        }
    }

    @Unique
    private String sm$getWorldDirNameFromEntry(Object entry) {
        Object summary = SinglePlayerScreenMixin.sm$getFieldByNames(entry, "level", "summary");
        if (summary == null) {
            return null;
        }
        String id = SinglePlayerScreenMixin.sm$invokeString(summary, "getLevelId");
        if (id == null) {
            id = SinglePlayerScreenMixin.sm$invokeString(summary, "getFileName");
        }
        if (id == null) {
            id = SinglePlayerScreenMixin.sm$invokeString(summary, "getDirectoryName");
        }
        if (id == null) {
            id = SinglePlayerScreenMixin.sm$invokeString(summary, "getName");
        }
        return id;
    }

    @Unique
    private String sm$getWorldDisplayNameFromEntry(Object entry) {
        Object summary = SinglePlayerScreenMixin.sm$getFieldByNames(entry, "level", "summary");
        if (summary == null) {
            return null;
        }
        String name = SinglePlayerScreenMixin.sm$invokeString(summary, "getName");
        if (name == null) {
            name = SinglePlayerScreenMixin.sm$invokeString(summary, "getLevelName");
        }
        return name;
    }

    @Unique
    private static Object sm$getFieldByNames(Object target, String ... names) {
        Class<?> cur;
        if (target == null) {
            return null;
        }
        Class<?> c = target.getClass();
        for (String n : names) {
            for (cur = c; cur != null && cur != Object.class; cur = cur.getSuperclass()) {
                try {
                    Field f = cur.getDeclaredField(n);
                    f.setAccessible(true);
                    try {
                        Object v = f.get(target);
                        if (v == null) continue;
                        return v;
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                    continue;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
        for (String n : names) {
            for (cur = c; cur != null && cur != Object.class; cur = cur.getSuperclass()) {
                for (Field f : cur.getDeclaredFields()) {
                    try {
                        if (!f.getName().toLowerCase().contains(n.toLowerCase())) continue;
                        f.setAccessible(true);
                        try {
                            Object v = f.get(target);
                            if (v == null) continue;
                            return v;
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    @Unique
    private static String sanitizeFolderName(String s) {
        if (s == null) {
            return "";
        }
        String clean = s.trim().replaceAll("[\\\\/:*?\"<>|]+", "_");
        return clean.isBlank() ? "" : clean;
    }

    @Unique
    private static Object sm$invoke(Object target, String method) {
        if (target == null) {
            return null;
        }
        for (Class<?> c = target.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(method, new Class[0]);
                m.setAccessible(true);
                return m.invoke(target, new Object[0]);
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (Throwable t) {
                return null;
            }
        }
        try {
            Method m = target.getClass().getMethod(method, new Class[0]);
            m.setAccessible(true);
            return m.invoke(target, new Object[0]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Unique
    private static String sm$invokeString(Object target, String method) {
        Object v = SinglePlayerScreenMixin.sm$invoke(target, method);
        return v == null ? null : String.valueOf(v);
    }

    @Unique
    private static Path sm$zipWorld(Path worldDir, String worldName) throws Exception {
        Path zip = Files.createTempFile("savemanager-" + worldName + "-", ".zip", new FileAttribute[0]);
        try (final ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zip, StandardOpenOption.WRITE));){
            final Path base = worldDir;
            Files.walkFileTree(base, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Path rel = base.relativize(file);
                        if ("session.lock".equalsIgnoreCase(rel.getFileName().toString())) {
                            return FileVisitResult.CONTINUE;
                        }
                        ZipEntry entry = new ZipEntry(rel.toString().replace('\\', '/'));
                        zos.putNextEntry(entry);
                        Files.copy(file, zos);
                        zos.closeEntry();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        return zip;
    }

    @Unique
    private static byte[] sm$deriveKey(String material) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(material.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    private static String sm$loadApiKey(class_310 client) {
        try {
            File configDir = new File(client.field_1697, "config");
            File configFile = new File(configDir, CONFIG_FILE);
            if (!configFile.exists()) {
                return null;
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
                if (json == null) {
                    String string = null;
                    return string;
                }
                if (json.has("encryptedApiToken")) {
                    String string = SinglePlayerScreenMixin.sm$decrypt(json.get("encryptedApiToken").getAsString());
                    return string;
                }
                if (!json.has("apiToken")) return null;
                String string = json.get("apiToken").getAsString();
                return string;
            }
        }
        catch (Exception e) {
            SaveManagerMod.LOGGER.error("SaveManager: failed to load API key", (Throwable)e);
        }
        return null;
    }

    @Unique
    private static String sm$decrypt(String base64) throws Exception {
        byte[] data = Base64.getDecoder().decode(base64);
        if (data.length < 28) {
            throw new IllegalArgumentException("Invalid encrypted payload");
        }
        byte[] iv = new byte[12];
        byte[] ct = new byte[data.length - 12];
        System.arraycopy(data, 0, iv, 0, 12);
        System.arraycopy(data, 12, ct, 0, ct.length);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        SecretKeySpec keySpec = new SecretKeySpec(AES_KEY, "AES");
        cipher.init(2, (Key)keySpec, new GCMParameterSpec(128, iv));
        byte[] pt = cipher.doFinal(ct);
        return new String(pt, StandardCharsets.UTF_8);
    }

    @Unique
    private void savemanager$confirmThenUploadSelected() {
        try {
            SelectedWorld sel = this.sm$getSelectedWorld();
            if (sel == null) {
                SaveManagerMod.LOGGER.warn("(savemanager) Upload canceled: no world selected");
                return;
            }
            String apiKey = SinglePlayerScreenMixin.sm$loadApiKey(this.field_22787);
            if (apiKey == null || apiKey.isBlank()) {
                if (this.field_22787 != null) {
                    this.field_22787.execute(() -> {
                        class_437 rootParent = SinglePlayerScreenMixin.sm$resolveWorldRootParent(this);
                        this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
                    });
                }
                return;
            }
            sm$apiKey = apiKey;
            this.savemanager$net.setApiKey(apiKey);
            String worldName = sel.getDisplayName();
            Path worldDir = sel.getDir();
            if (worldDir == null || !Files.exists(worldDir, new LinkOption[0])) {
                SaveManagerMod.LOGGER.warn("(savemanager) Upload canceled: world directory not found: {}", (Object)sel);
                return;
            }
            String dirKey = worldDir.getFileName() != null ? worldDir.getFileName().toString() : null;
            this.savemanager$net.listWorldSaveNames().whenComplete((names, namesErr) -> {
                Runnable beginOnCurrentScreen = () -> {
                    try {
                        class_437 cur = this.field_22787.field_1755;
                        if (cur instanceof class_526) {
                            SinglePlayerScreenMixin mixin = (SinglePlayerScreenMixin)cur;
                            if (sm$apiKey != null) {
                                mixin.savemanager$net.setApiKey(sm$apiKey);
                            }
                            mixin.sm$beginZipOnNextFrame(worldName, worldDir);
                        } else {
                            if (sm$apiKey != null) {
                                this.savemanager$net.setApiKey(sm$apiKey);
                            }
                            this.sm$beginZipOnNextFrame(worldName, worldDir);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
                if (namesErr != null) {
                    SaveManagerMod.LOGGER.warn("(savemanager) Failed to fetch name list; proceeding: {}", (Object)SinglePlayerScreenMixin.safeErrMessage(namesErr));
                    this.field_22787.execute(beginOnCurrentScreen);
                    return;
                }
                boolean exists = false;
                String sanitized = SinglePlayerScreenMixin.sanitizeFolderName(worldName);
                if (names != null) {
                    for (String n : names) {
                        if (n == null || !n.equalsIgnoreCase(worldName) && (sanitized.isEmpty() || !n.equalsIgnoreCase(sanitized))) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    this.field_22787.execute(beginOnCurrentScreen);
                    return;
                }
                this.field_22787.execute(() -> {
                    class_5250 title = class_2561.method_43470((String)"Overwrite Cloud Save?");
                    class_5250 message = class_2561.method_43470((String)("A save named \"" + worldName + "\" already exists in the cloud. Overwrite?"));
                    this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                        this.sm$openFreshSelectWorld();
                        this.field_22787.execute(() -> {
                            block21: {
                                try {
                                    class_437 cur = this.field_22787.field_1755;
                                    if (cur instanceof class_526) {
                                        class_528 list;
                                        SinglePlayerScreenMixin mixin = (SinglePlayerScreenMixin)cur;
                                        if (dirKey != null && (list = mixin.sm$getWorldList()) != null) {
                                            List entries = null;
                                            try {
                                                entries = (List)list.getClass().getMethod("children", new Class[0]).invoke((Object)list, new Object[0]);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                            if (entries == null) {
                                                try {
                                                    Field f = list.getClass().getDeclaredField("children");
                                                    f.setAccessible(true);
                                                    Object v = f.get(list);
                                                    if (v instanceof List) {
                                                        List l;
                                                        entries = l = (List)v;
                                                    }
                                                }
                                                catch (Throwable f) {
                                                    // empty catch block
                                                }
                                            }
                                            if (entries != null) {
                                                Object match = null;
                                                for (Object e : entries) {
                                                    String dn = mixin.sm$getWorldDirNameFromEntry(e);
                                                    if (!dirKey.equals(dn)) continue;
                                                    match = e;
                                                    break;
                                                }
                                                if (match != null) {
                                                    try {
                                                        for (Method m : list.getClass().getMethods()) {
                                                            if (!m.getName().equals("setSelected") || m.getParameterCount() != 1) continue;
                                                            m.setAccessible(true);
                                                            m.invoke((Object)list, match);
                                                            break;
                                                        }
                                                    }
                                                    catch (Throwable throwable) {
                                                        // empty catch block
                                                    }
                                                }
                                            }
                                        }
                                        if (confirmed) {
                                            if (sm$apiKey != null) {
                                                mixin.savemanager$net.setApiKey(sm$apiKey);
                                            }
                                            mixin.sm$beginZipOnNextFrame(worldName, worldDir);
                                        }
                                        break block21;
                                    }
                                    if (confirmed) {
                                        if (sm$apiKey != null) {
                                            this.savemanager$net.setApiKey(sm$apiKey);
                                        }
                                        this.sm$beginZipOnNextFrame(worldName, worldDir);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }, (class_2561)title, (class_2561)message));
                });
            });
        }
        catch (Throwable t) {
            SaveManagerMod.LOGGER.error("(savemanager) Unexpected error in upload flow", t);
            upActive = false;
            upZipping = false;
        }
    }

    @Unique
    private static String safeErrMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        String m = t.getMessage();
        if (m == null || m.isBlank()) {
            return t.getClass().getSimpleName();
        }
        Object one = m.split("\n", 2)[0];
        if (((String)one).length() > 200) {
            one = ((String)one).substring(0, 200) + "...";
        }
        return one;
    }

    @Unique
    private static String formatDurationShort(long seconds) {
        if (seconds <= 0L) {
            return "0s";
        }
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 60L;
        if (h > 0L) {
            return String.format("%dh %02dm", h, m);
        }
        if (m > 0L) {
            return String.format("%dm %02ds", m, s);
        }
        return String.format("%ds", s);
    }

    @Unique
    private static String formatBytes(long b) {
        if (b < 1024L) {
            return b + " B";
        }
        int unit = 1024;
        int exp = (int)(Math.log(b) / Math.log(unit));
        String pre = "" + "KMGTPE".charAt(Math.min(exp - 1, 5));
        return String.format("%.1f %sB", (double)b / Math.pow(unit, exp), pre);
    }

    @Unique
    private static class_437 sm$resolveWorldRootParent(class_437 start) {
        class_437 p = start;
        int guard = 0;
        while (p instanceof class_526 && guard++ < 8) {
            try {
                Field f = class_526.class.getDeclaredField("parent");
                f.setAccessible(true);
                class_437 next = (class_437)f.get(p);
                if (next == null || next == p) break;
                p = next;
            }
            catch (Throwable ignored) {
                break;
            }
        }
        return p;
    }

    @Unique
    private void sm$openFreshSelectWorld() {
        if (this.field_22787 == null) {
            return;
        }
        class_437 rootParent = SinglePlayerScreenMixin.sm$resolveWorldRootParent(this);
        this.field_22787.method_1507((class_437)new class_526(rootParent));
    }

    @Unique
    private static String sm$rawFromThrowable(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int guard = 0;
        while (t != null && guard++ < 16) {
            String m = t.getMessage();
            if (m != null && !m.isBlank()) {
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(m);
            }
            t = t.getCause();
        }
        return sb.toString();
    }

    @Unique
    private static String sm$extractFriendly(String raw) {
        int i;
        if (raw == null) {
            raw = "";
        }
        String friendly = "";
        int start = raw.indexOf(123);
        while (start >= 0 && start < raw.length()) {
            try {
                JsonObject obj;
                String sub = raw.substring(start).trim();
                JsonElement el = new JsonParser().parse(sub);
                if (el.isJsonObject() && (obj = el.getAsJsonObject()).has("error") && obj.get("error").isJsonPrimitive() && (friendly = obj.get("error").getAsString()) != null && !friendly.isBlank()) {
                    return friendly;
                }
            }
            catch (Throwable sub) {
                // empty catch block
            }
            start = raw.indexOf(123, start + 1);
        }
        if (raw.contains("401") && raw.toLowerCase(Locale.ROOT).contains("invalid save manager api key")) {
            return "Invalid Save Manager API key";
        }
        if (raw.toLowerCase(Locale.ROOT).contains("exceed storage quota") && (i = raw.indexOf(123)) >= 0) {
            try {
                String s;
                JsonObject obj = new JsonParser().parse(raw.substring(i)).getAsJsonObject();
                if (obj.has("error") && (s = obj.get("error").getAsString()) != null && !s.isBlank()) {
                    return s;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return friendly;
    }

    @Unique
    private void sm$showErrorDialog(String raw, String fallbackTitle) {
        String friendly = SinglePlayerScreenMixin.sm$extractFriendly(raw);
        class_5250 title = class_2561.method_43470((String)"Error");
        class_5250 message = class_2561.method_43470((String)(friendly == null || friendly.isBlank() ? fallbackTitle : friendly));
        this.field_22787.method_1507((class_437)new class_410(confirmed -> {
            if (!confirmed) {
                try {
                    if (this.field_22787 != null && this.field_22787.field_1774 != null) {
                        this.field_22787.field_1774.method_1455(raw == null ? "" : raw);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return;
            }
            if (SinglePlayerScreenMixin.sm$isInvalidKey(raw, friendly)) {
                class_437 rootParent = SinglePlayerScreenMixin.sm$resolveWorldRootParent(this);
                this.field_22787.method_1507((class_437)new AccountLinkingScreen(rootParent));
                return;
            }
            this.sm$openFreshSelectWorld();
        }, (class_2561)title, (class_2561)message, (class_2561)class_2561.method_43470((String)"OK"), (class_2561)class_2561.method_43470((String)"Copy error")));
    }
}

