/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.CacheManager;
import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.LitematicDownloaderScreen;
import com.choculaterie.gui.NavigationState;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.MinemevFileInfo;
import com.choculaterie.models.MinemevPostDetailInfo;
import com.choculaterie.networking.LitematicHttpClient;
import com.choculaterie.networking.MinemevHttpClient;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class MinemevDetailScreen
extends class_437 {
    private final String postUuid;
    private MinemevPostDetailInfo postDetail;
    private boolean isLoading = true;
    private String errorMessage = null;
    private class_4185 backButton;
    private class_4185 downloadButton;
    private class_2960 coverImageTexture = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private boolean isImageLoading = false;
    private String[] imageUrls = new String[0];
    private int currentImageIndex = 0;
    private class_4185 prevImageButton;
    private class_4185 nextImageButton;
    private int descriptionScrollPos = 0;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private int scrollDragOffset = 0;
    private boolean filesLoading = false;
    private List<MinemevFileInfo> availableFiles = new ArrayList<MinemevFileInfo>();
    private int filesRenderStartY = -1;
    private int filesRenderCount = 0;
    private final int fileItemHeight = 14;
    private int lastRightSectionX = 0;
    private int lastContentWidth = 0;
    private boolean showFileDropdown = false;
    private List<MinemevFileInfo> fileDropdownItems = new ArrayList<MinemevFileInfo>();
    private int fileDropdownX = 0;
    private int fileDropdownY = 0;
    private int fileDropdownWidth = 360;
    private int fileDropdownHeight = 0;
    private int fileDropdownScroll = 0;
    private int fileDropdownContentHeight = 0;
    private boolean isDraggingFileDropdown = false;
    private int fileDropdownDragOffset = 0;
    private long loadingStartTime = 0L;
    private static final CacheManager cacheManager = LitematicDownloaderScreen.getCacheManager();
    private static final long DETAIL_CACHE_DURATION_MS = 300000L;

    public MinemevDetailScreen(String postUuid) {
        super((class_2561)class_2561.method_43470((String)""));
        this.postUuid = postUuid;
    }

    protected void method_25426() {
        super.method_25426();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> {
            NavigationState navState = NavigationState.getInstance();
            if (navState.getSavedCurrentPage() > 0) {
                class_310.method_1551().method_1507((class_437)new LitematicDownloaderScreen(true));
            } else {
                class_310.method_1551().method_1507((class_437)new LitematicDownloaderScreen());
            }
        }).method_46434(10, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.backButton);
        this.downloadButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b07"), button -> {
            if (this.postDetail != null) {
                if (!this.availableFiles.isEmpty() && this.availableFiles.size() == 1) {
                    this.startPerFileDownloadWithConfirm(this.availableFiles.get(0));
                } else {
                    this.openMinemevFileDropdown(this.field_22789 - 40, 30);
                }
            }
        }).method_46434(this.field_22789 - 30, 10, 20, 20).method_46431();
        this.downloadButton.field_22763 = false;
        this.method_37063((class_364)this.downloadButton);
        int padding = 20;
        int leftSectionWidth = 256;
        int topMargin = 40;
        int centerY = topMargin + leftSectionWidth / 2 - 10;
        this.prevImageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), button -> {
            if (this.imageUrls != null && this.imageUrls.length > 1) {
                this.currentImageIndex = (this.currentImageIndex - 1 + this.imageUrls.length) % this.imageUrls.length;
                this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                this.updateImageButtonsState();
            }
        }).method_46434(padding + 6, centerY, 20, 20).method_46431();
        this.prevImageButton.field_22763 = false;
        this.method_37063((class_364)this.prevImageButton);
        this.nextImageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), button -> {
            if (this.imageUrls != null && this.imageUrls.length > 1) {
                this.currentImageIndex = (this.currentImageIndex + 1) % this.imageUrls.length;
                this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                this.updateImageButtonsState();
            }
        }).method_46434(padding + leftSectionWidth - 26, centerY, 20, 20).method_46431();
        this.nextImageButton.field_22763 = false;
        this.method_37063((class_364)this.nextImageButton);
        this.errorMessage = null;
        this.loadPostDetails();
    }

    private void updateImageButtonsState() {
        boolean multiple;
        boolean bl = multiple = this.imageUrls != null && this.imageUrls.length > 1;
        if (this.prevImageButton != null) {
            this.prevImageButton.field_22763 = multiple;
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.field_22763 = multiple;
        }
    }

    private void loadPostDetails() {
        if (cacheManager.hasValidMinemevDetailCache(this.postUuid, 300000L)) {
            CacheManager.MinemevDetailCacheEntry cached = cacheManager.getMinemevDetailCache(this.postUuid);
            this.postDetail = cached.getDetail();
            this.isLoading = false;
            this.downloadButton.field_22763 = true;
            if (this.postDetail.getImages() != null && this.postDetail.getImages().length > 0) {
                this.imageUrls = this.postDetail.getImages();
                this.currentImageIndex = 0;
                this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                this.preloadImages(this.imageUrls);
            } else {
                String imgUrl = this.postDetail.getThumbnailUrl();
                if (imgUrl != null && !imgUrl.isEmpty()) {
                    this.loadCoverImage(imgUrl);
                }
            }
            this.updateImageButtonsState();
            this.loadFilesList();
            return;
        }
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        new Thread(() -> {
            try {
                MinemevPostDetailInfo detail = MinemevHttpClient.fetchPostDetails(this.postUuid);
                class_310.method_1551().execute(() -> {
                    this.postDetail = detail;
                    this.isLoading = false;
                    this.downloadButton.field_22763 = true;
                    cacheManager.putMinemevDetailCache(this.postUuid, detail, 300000L);
                    if (detail.getImages() != null && detail.getImages().length > 0) {
                        this.imageUrls = detail.getImages();
                        this.currentImageIndex = 0;
                        this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                        this.preloadImages(this.imageUrls);
                    } else {
                        String imgUrl = detail.getThumbnailUrl();
                        if ((imgUrl == null || imgUrl.isEmpty()) && detail.getImages() != null && detail.getImages().length > 0) {
                            imgUrl = detail.getImages()[0];
                        }
                        if (imgUrl != null && !imgUrl.isEmpty()) {
                            this.loadCoverImage(imgUrl);
                        }
                    }
                    this.updateImageButtonsState();
                    this.loadFilesList();
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> {
                    this.errorMessage = "Failed to load Minemev details: " + e.getMessage();
                    this.isLoading = false;
                });
            }
        }).start();
    }

    private void preloadImages(String[] urls) {
        if (urls == null || urls.length == 0) {
            return;
        }
        for (String url : urls) {
            if (url == null || url.isEmpty()) continue;
            try {
                if (cacheManager != null && cacheManager.hasValidImageCache(url, 300000L)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            new Thread(() -> {
                try {
                    String encodedUrl = this.encodeImageUrl(url);
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create(encodedUrl)).GET().build();
                    HttpResponse<byte[]> response = LitematicHttpClient.getClient().send(request, HttpResponse.BodyHandlers.ofByteArray());
                    if (response.statusCode() != 200) {
                        return;
                    }
                    byte[] imageData = response.body();
                    if (imageData == null || imageData.length < 100) {
                        return;
                    }
                    String detectedFormat = this.detectImageFormat(imageData);
                    class_310.method_1551().execute(() -> {
                        block13: {
                            try {
                                class_1011 nativeImage;
                                try {
                                    if (cacheManager != null && cacheManager.hasValidImageCache(url, 300000L)) {
                                        return;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                String uniqueId = UUID.randomUUID().toString().replace("-", "");
                                class_2960 texId = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
                                try {
                                    byte[] processed = this.convertImageToPng(imageData, detectedFormat);
                                    nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(processed));
                                    if (nativeImage.method_4307() <= 0 || nativeImage.method_4323() <= 0) {
                                        nativeImage.close();
                                        nativeImage = this.createPlaceholderImage(256, 256, "Invalid dims");
                                    } else if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096) {
                                        nativeImage.close();
                                        nativeImage = this.createPlaceholderImage(256, 256, "Too large");
                                    }
                                }
                                catch (Exception e) {
                                    nativeImage = this.createPlaceholderImage(256, 256, "Unsupported");
                                }
                                if (nativeImage == null) break block13;
                                class_310.method_1551().method_1531().method_4616(texId, (class_1044)new class_1043(() -> "minemev_preload_image", nativeImage));
                                try {
                                    if (cacheManager != null) {
                                        cacheManager.putImageCache(url, texId);
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
    }

    private void loadFilesList() {
        this.filesLoading = true;
        this.availableFiles = new ArrayList<MinemevFileInfo>();
        new Thread(() -> {
            try {
                List<MinemevFileInfo> files = MinemevHttpClient.fetchPostFiles(this.postUuid);
                class_310.method_1551().execute(() -> {
                    this.availableFiles = files;
                    this.filesLoading = false;
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> {
                    this.filesLoading = false;
                    ToastManager.addToast("Failed to load files: " + e.getMessage(), true);
                });
            }
        }).start();
    }

    private void openMinemevFileDropdown(int anchorX, int anchorY) {
        this.showFileDropdown = false;
        this.fileDropdownItems = new ArrayList<MinemevFileInfo>();
        this.fileDropdownX = Math.min(anchorX, this.field_22789 - this.fileDropdownWidth - 10);
        this.fileDropdownY = anchorY;
        this.fileDropdownScroll = 0;
        if (!this.availableFiles.isEmpty()) {
            if (this.availableFiles.size() == 1) {
                this.startPerFileDownloadWithConfirm(this.availableFiles.get(0));
                return;
            }
            this.fileDropdownItems = this.availableFiles;
            this.fileDropdownContentHeight = this.fileDropdownItems.size() * 18;
            int maxHeight = Math.min(220, this.field_22790 - this.fileDropdownY - 20);
            this.fileDropdownHeight = Math.min(this.fileDropdownContentHeight, maxHeight);
            this.showFileDropdown = true;
        } else {
            new Thread(() -> {
                try {
                    List<MinemevFileInfo> files = MinemevHttpClient.fetchPostFiles(this.postUuid);
                    class_310.method_1551().execute(() -> {
                        if (files == null || files.isEmpty()) {
                            ToastManager.addToast("No files available for this post", true);
                            this.showFileDropdown = false;
                            return;
                        }
                        if (files.size() == 1) {
                            this.startPerFileDownloadWithConfirm((MinemevFileInfo)files.get(0));
                            this.showFileDropdown = false;
                            return;
                        }
                        this.fileDropdownItems = files;
                        this.fileDropdownContentHeight = this.fileDropdownItems.size() * 18;
                        int maxHeight = Math.min(220, this.field_22790 - this.fileDropdownY - 20);
                        this.fileDropdownHeight = Math.min(this.fileDropdownContentHeight, maxHeight);
                        boolean bl = this.showFileDropdown = !this.fileDropdownItems.isEmpty();
                        if (!this.showFileDropdown) {
                            ToastManager.addToast("No files available for this post", true);
                        }
                    });
                }
                catch (Exception e) {
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Failed to load files: " + e.getMessage(), true);
                        this.showFileDropdown = false;
                    });
                }
            }).start();
        }
    }

    private void loadCoverImage(String imageUrl) {
        System.out.println("[DEBUG] loadCoverImage called with URL: " + imageUrl);
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            System.out.println("[DEBUG] loadCoverImage: URL is null or empty, setting coverImageTexture to null");
            this.coverImageTexture = null;
            return;
        }
        long IMAGE_CACHE_DURATION_MS = 300000L;
        try {
            if (cacheManager != null && cacheManager.hasValidImageCache(imageUrl, 300000L)) {
                CacheManager.ImageCacheEntry cached = cacheManager.getImageCache(imageUrl);
                if (cached != null && cached.getTextureId() != null) {
                    this.coverImageTexture = cached.getTextureId();
                    this.isImageLoading = false;
                    System.out.println("[DEBUG] Using cached Minemev image texture for URL: " + imageUrl);
                    return;
                }
                System.out.println("[DEBUG] Cache entry found but invalid for URL: " + imageUrl);
            } else {
                System.out.println("[DEBUG] No valid cache entry found for URL: " + imageUrl);
            }
        }
        catch (Exception e) {
            System.err.println("[DEBUG] Minemev image cache check failed: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("[DEBUG] Starting image download for URL: " + imageUrl);
        this.isImageLoading = true;
        new Thread(() -> {
            try {
                String encodedUrl = this.encodeImageUrl(imageUrl);
                System.out.println("[DEBUG] Encoded URL: " + encodedUrl);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(encodedUrl)).GET().build();
                HttpResponse<byte[]> response = LitematicHttpClient.getClient().send(request, HttpResponse.BodyHandlers.ofByteArray());
                System.out.println("[DEBUG] HTTP response status: " + response.statusCode() + " for URL: " + imageUrl);
                if (response.statusCode() != 200) {
                    System.err.println("[DEBUG] HTTP error " + response.statusCode() + " for URL: " + imageUrl);
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Failed to load image: HTTP " + response.statusCode(), true);
                        this.createAndRegisterPlaceholder("HTTP " + response.statusCode());
                    });
                    return;
                }
                byte[] imageData = response.body();
                System.out.println("[DEBUG] Downloaded " + imageData.length + " bytes for URL: " + imageUrl);
                if (imageData.length < 100) {
                    System.err.println("[DEBUG] Image file too small (" + imageData.length + " bytes) for URL: " + imageUrl);
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Image file too small (corrupted)", true);
                        this.createAndRegisterPlaceholder("Image too small");
                    });
                    return;
                }
                String detectedFormat = this.detectImageFormat(imageData);
                System.out.println("[DEBUG] Detected image format: " + detectedFormat + " for URL: " + imageUrl);
                class_310.method_1551().execute(() -> {
                    block12: {
                        try {
                            class_1011 nativeImage;
                            String uniqueId = UUID.randomUUID().toString().replace("-", "");
                            this.coverImageTexture = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
                            System.out.println("[DEBUG] Generated texture ID: " + String.valueOf(this.coverImageTexture) + " for URL: " + imageUrl);
                            try {
                                System.out.println("[DEBUG] Converting " + detectedFormat + " image to PNG for URL: " + imageUrl);
                                byte[] processed = this.convertImageToPng(imageData, detectedFormat);
                                System.out.println("[DEBUG] Converted image size: " + processed.length + " bytes (was " + imageData.length + ") for URL: " + imageUrl);
                                if (detectedFormat.equals("webp") && processed.length == imageData.length && (processed.length < 8 || processed[0] != -119 || processed[1] != 80 || processed[2] != 78 || processed[3] != 71)) {
                                    System.err.println("[DEBUG] WebP conversion failed, original WebP data returned instead of PNG for URL: " + imageUrl);
                                    throw new Exception("WebP conversion failed - no valid PNG data produced");
                                }
                                nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(processed));
                                System.out.println("[DEBUG] Created NativeImage with dimensions: " + nativeImage.method_4307() + "x" + nativeImage.method_4323() + " for URL: " + imageUrl);
                                if (nativeImage.method_4307() <= 0 || nativeImage.method_4323() <= 0) {
                                    System.err.println("[DEBUG] Image has invalid dimensions: " + nativeImage.method_4307() + "x" + nativeImage.method_4323() + " for URL: " + imageUrl);
                                    ToastManager.addToast("Image has invalid dimensions", true);
                                    nativeImage.close();
                                    nativeImage = this.createPlaceholderImage(256, 256, "Invalid dims");
                                } else if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096) {
                                    System.err.println("[DEBUG] Image too large: " + nativeImage.method_4307() + "x" + nativeImage.method_4323() + " for URL: " + imageUrl);
                                    ToastManager.addToast("Image too large", true);
                                    nativeImage.close();
                                    nativeImage = this.createPlaceholderImage(256, 256, "Too large");
                                }
                            }
                            catch (Exception e) {
                                System.err.println("[DEBUG] Failed to process " + detectedFormat + " image for URL: " + imageUrl);
                                System.err.println("[DEBUG] Exception: " + e.getMessage());
                                e.printStackTrace();
                                Object errorReason = detectedFormat.equals("webp") ? "WebP decode failed" : "Unsupported " + detectedFormat;
                                ToastManager.addToast("Could not load " + detectedFormat + " image: " + e.getMessage(), true);
                                nativeImage = this.createPlaceholderImage(256, 256, (String)errorReason);
                            }
                            if (nativeImage != null) {
                                this.imageWidth = nativeImage.method_4307();
                                this.imageHeight = nativeImage.method_4323();
                                System.out.println("[DEBUG] Registering texture with Minecraft for URL: " + imageUrl);
                                class_310.method_1551().method_1531().method_4616(this.coverImageTexture, (class_1044)new class_1043(() -> "minemev_cover_image", nativeImage));
                                System.out.println("[DEBUG] Successfully registered texture for URL: " + imageUrl);
                                try {
                                    if (cacheManager != null) {
                                        cacheManager.putImageCache(imageUrl, this.coverImageTexture);
                                        System.out.println("[DEBUG] Cached texture for URL: " + imageUrl);
                                    }
                                    break block12;
                                }
                                catch (Exception e) {
                                    System.err.println("[DEBUG] Failed to cache texture for URL: " + imageUrl + " - " + e.getMessage());
                                }
                                break block12;
                            }
                            System.err.println("[DEBUG] NativeImage is null after processing for URL: " + imageUrl);
                        }
                        catch (Exception e) {
                            System.err.println("[DEBUG] Failed to process image on main thread for URL: " + imageUrl);
                            System.err.println("[DEBUG] Exception: " + e.getMessage());
                            e.printStackTrace();
                            ToastManager.addToast("Failed to process image", true);
                            this.coverImageTexture = null;
                        }
                    }
                });
            }
            catch (Exception e) {
                System.err.println("[DEBUG] Failed to download image for URL: " + imageUrl);
                System.err.println("[DEBUG] Exception: " + e.getMessage());
                e.printStackTrace();
                class_310.method_1551().execute(() -> {
                    ToastManager.addToast("Failed to load image", true);
                    this.createAndRegisterPlaceholder("Download failed");
                });
            }
            finally {
                System.out.println("[DEBUG] Image loading finished for URL: " + imageUrl);
                this.isImageLoading = false;
            }
        }).start();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        for (class_364 child : this.method_25396()) {
            class_4185 b;
            if (child instanceof class_4185 && ((b = (class_4185)child) == this.backButton || b == this.downloadButton) || !(child instanceof class_4068)) continue;
            class_4068 d = (class_4068)child;
            d.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.isLoading) {
            int centerY = this.field_22790 / 2;
            this.drawLoadingAnimation(context, this.field_22789 / 2, centerY - 15);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), this.field_22789 / 2, centerY + 15, -1);
        } else if (this.errorMessage != null) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage), this.field_22789 / 2, this.field_22790 / 2, -1);
        } else if (this.postDetail != null) {
            String tagsJoined;
            String publishDate;
            String username;
            int padding = 20;
            int leftSectionWidth = 256;
            int rightSectionX = leftSectionWidth + padding * 2;
            int contentWidth = this.field_22789 - rightSectionX - padding;
            int topMargin = 40;
            this.lastRightSectionX = rightSectionX;
            this.lastContentWidth = contentWidth;
            if (this.coverImageTexture != null) {
                context.method_25290(class_10799.field_56883, this.coverImageTexture, padding, topMargin, 0.0f, 0.0f, leftSectionWidth, leftSectionWidth, leftSectionWidth, leftSectionWidth);
            } else if (this.isImageLoading) {
                int centerX = padding + leftSectionWidth / 2;
                int centerY = topMargin + leftSectionWidth / 2;
                this.drawLoadingAnimation(context, centerX, centerY);
            } else {
                context.method_25294(padding, topMargin, padding + leftSectionWidth, topMargin + leftSectionWidth, 0x33FFFFFF);
                String noImageText = "No Image";
                int textWidth = this.field_22793.method_1727(noImageText);
                int textX = padding + (leftSectionWidth - textWidth) / 2;
                int textY = topMargin + leftSectionWidth / 2 - 4;
                context.method_51433(this.field_22793, noImageText, textX, textY, -5592406, false);
            }
            if (this.imageUrls != null && this.imageUrls.length > 1) {
                String idxStr = String.format("%d/%d", this.currentImageIndex + 1, this.imageUrls.length);
                int idxW = this.field_22793.method_1727(idxStr);
                int idxX = padding + (leftSectionWidth - idxW) / 2;
                int idxY = topMargin + leftSectionWidth - 18;
                context.method_25294(idxX - 6, idxY - 3, idxX + idxW + 6, idxY + 12, -1442840576);
                context.method_51433(this.field_22793, idxStr, idxX, idxY, -1, false);
            }
            int y = topMargin;
            String name = this.postDetail.getTitle();
            if (name != null) {
                List nameLines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)name), contentWidth);
                for (Object line : nameLines) {
                    context.method_51430(this.field_22793, (class_5481)line, rightSectionX, y, -1, true);
                    y += 10;
                }
                y += 5;
            }
            if ((username = this.postDetail.getAuthor()) != null) {
                List authorLines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)("By: " + username)), contentWidth);
                for (class_5481 line : authorLines) {
                    context.method_51430(this.field_22793, line, rightSectionX, y, -2763307, false);
                    y += 10;
                }
                y += 5;
            }
            if ((publishDate = this.postDetail.getCreatedAt()) != null && !publishDate.isEmpty()) {
                String formattedDate = publishDate.split("T")[0];
                context.method_51433(this.field_22793, "Published: " + formattedDate, rightSectionX, y, -2763307, false);
                y += 20;
            }
            context.method_51433(this.field_22793, "Downloads: " + this.postDetail.getDownloads(), rightSectionX, y, -2763307, false);
            y += 25;
            String versionsJoined = this.joinArray(this.postDetail.getVersions());
            if (!versionsJoined.isEmpty()) {
                context.method_51433(this.field_22793, "Versions:", rightSectionX, y, -1, true);
                y += 15;
                List vLines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)versionsJoined), contentWidth);
                for (Object line : vLines) {
                    context.method_51430(this.field_22793, (class_5481)line, rightSectionX, y, -1, false);
                    y += 10;
                }
                y += 5;
            }
            if (!(tagsJoined = this.joinArray(this.postDetail.getTags())).isEmpty()) {
                context.method_51433(this.field_22793, "Tags:", rightSectionX, y, -1, true);
                y += 15;
                List tLines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)tagsJoined), contentWidth);
                for (class_5481 line : tLines) {
                    context.method_51430(this.field_22793, line, rightSectionX, y, -1, false);
                    y += 10;
                }
                y += 10;
            }
            context.method_51433(this.field_22793, "Description:", rightSectionX, y, -1, true);
            this.scrollAreaX = rightSectionX;
            this.scrollAreaY = y += 15;
            this.scrollAreaWidth = contentWidth;
            this.scrollAreaHeight = this.field_22790 - y - padding;
            String description = this.postDetail.getDescription() != null && !this.postDetail.getDescription().isEmpty() ? this.postDetail.getDescription() : "No description available";
            description = description.replace("\r", "").replaceAll("[ \t]+", " ").trim();
            context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
            int textY = this.scrollAreaY - this.descriptionScrollPos;
            int reservedRightPx = 10;
            int wrapWidth = Math.max(10, this.scrollAreaWidth - reservedRightPx);
            List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)description), wrapWidth);
            this.totalContentHeight = lines.size() * 10;
            for (class_5481 line : lines) {
                context.method_51430(this.field_22793, line, this.scrollAreaX, textY, -1, false);
                textY += 10;
            }
            context.method_44380();
            if (this.totalContentHeight > this.scrollAreaHeight) {
                int scrollBarWidth = 6;
                this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
                this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth - scrollBarWidth - 2;
                this.scrollBarY = this.scrollAreaY + (int)((float)this.descriptionScrollPos / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
                context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
                boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
                int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
                context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
            }
        }
        if (this.backButton != null) {
            this.backButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.downloadButton != null) {
            this.downloadButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.prevImageButton != null) {
            this.prevImageButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.nextImageButton != null) {
            this.nextImageButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.showFileDropdown && !this.fileDropdownItems.isEmpty()) {
            this.renderFileDropdown(context, mouseX, mouseY);
        }
        ToastManager.render(context, this.field_22789);
    }

    private void renderFileDropdown(class_332 context, int mouseX, int mouseY) {
        int x1 = this.fileDropdownX;
        int y1 = this.fileDropdownY;
        int x2 = this.fileDropdownX + this.fileDropdownWidth;
        int y2 = this.fileDropdownY + this.fileDropdownHeight;
        context.method_25294(x1 - 1, y1 - 1, x2 + 1, y2 + 1, -1442840576);
        context.method_25294(x1, y1, x2, y2, -300937200);
        context.method_44379(x1, y1, x2, y2);
        int itemHeight = 18;
        int startIndex = Math.max(0, this.fileDropdownScroll / itemHeight);
        int endIndex = Math.min(this.fileDropdownItems.size(), startIndex + this.fileDropdownHeight / itemHeight + 1);
        int drawY = y1 - this.fileDropdownScroll % itemHeight;
        for (int i = startIndex; i < endIndex; ++i) {
            boolean hovered;
            MinemevFileInfo f = this.fileDropdownItems.get(i);
            int itemTop = drawY + (i - startIndex) * itemHeight;
            boolean bl = hovered = mouseX >= x1 && mouseX <= x2 && mouseY >= itemTop && mouseY <= itemTop + itemHeight;
            if (hovered) {
                context.method_25294(x1, itemTop, x2, itemTop + itemHeight, 0x33FFFFFF);
            }
            String name = f.getFileName() != null && !f.getFileName().isEmpty() ? f.getFileName() : "Unnamed";
            String sizeStr = f.getFileSize() > 0L ? " \u2022 " + this.formatSize(f.getFileSize()) : "";
            String ver = this.joinArrayShort(f.getVersions());
            String line = this.trimToWidth(name, this.fileDropdownWidth - 20) + sizeStr + (String)(ver.isEmpty() ? "" : " \u2022 " + ver);
            context.method_51433(this.field_22793, line, x1 + 6, itemTop + 4, -1, false);
        }
        context.method_44380();
        if (this.fileDropdownContentHeight > this.fileDropdownHeight) {
            int scrollBarWidth = 6;
            int barHeight = Math.max(20, this.fileDropdownHeight * this.fileDropdownHeight / Math.max(1, this.fileDropdownContentHeight));
            int barX = x2 - scrollBarWidth - 2;
            int barY = y1 + (int)((float)this.fileDropdownScroll / (float)(this.fileDropdownContentHeight - this.fileDropdownHeight) * (float)(this.fileDropdownHeight - barHeight));
            context.method_25294(barX, y1, barX + scrollBarWidth, y2, 0x33FFFFFF);
            boolean isHovering = mouseX >= barX && mouseX <= barX + scrollBarWidth && mouseY >= barY && mouseY <= barY + barHeight;
            int color = isHovering ? -1 : -1426063361;
            context.method_25294(barX, barY, barX + scrollBarWidth, barY + barHeight, color);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.showFileDropdown) {
            if (this.fileDropdownContentHeight > this.fileDropdownHeight && button == 0) {
                int barWidth = 6;
                int barX = this.fileDropdownX + this.fileDropdownWidth - barWidth - 2;
                int barHeight = Math.max(20, this.fileDropdownHeight * this.fileDropdownHeight / Math.max(1, this.fileDropdownContentHeight));
                int barY = this.fileDropdownY + (int)((float)this.fileDropdownScroll / (float)Math.max(1, this.fileDropdownContentHeight - this.fileDropdownHeight) * (float)(this.fileDropdownHeight - barHeight));
                if (mouseX >= (double)barX && mouseX <= (double)(barX + barWidth) && mouseY >= (double)barY && mouseY <= (double)(barY + barHeight)) {
                    this.isDraggingFileDropdown = true;
                    this.fileDropdownDragOffset = (int)(mouseY - (double)barY);
                    return true;
                }
                if (mouseX >= (double)barX && mouseX <= (double)(barX + barWidth) && mouseY >= (double)this.fileDropdownY && mouseY <= (double)(this.fileDropdownY + this.fileDropdownHeight)) {
                    float clickPercent = (float)(mouseY - (double)this.fileDropdownY) / (float)Math.max(1, this.fileDropdownHeight);
                    this.fileDropdownScroll = (int)(clickPercent * (float)(this.fileDropdownContentHeight - this.fileDropdownHeight));
                    this.fileDropdownScroll = Math.max(0, Math.min(this.fileDropdownContentHeight - this.fileDropdownHeight, this.fileDropdownScroll));
                    return true;
                }
            }
            if (this.handleDropdownClick(mouseX, mouseY, button)) {
                return true;
            }
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + scrollBarWidth) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                this.scrollDragOffset = (int)(mouseY - (double)this.scrollBarY);
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + scrollBarWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = (float)(mouseY - (double)this.scrollAreaY) / (float)Math.max(1, this.scrollAreaHeight);
                this.descriptionScrollPos = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.descriptionScrollPos = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.descriptionScrollPos));
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseY = click.comp_4799();
        if (this.isScrolling && this.totalContentHeight > this.scrollAreaHeight) {
            int newBarTop = (int)mouseY - this.scrollDragOffset;
            int minBarTop = this.scrollAreaY;
            int maxBarTop = this.scrollAreaY + this.scrollAreaHeight - this.scrollBarHeight;
            newBarTop = Math.max(minBarTop, Math.min(maxBarTop, newBarTop));
            float percent = (float)(newBarTop - this.scrollAreaY) / (float)Math.max(1, this.scrollAreaHeight - this.scrollBarHeight);
            this.descriptionScrollPos = (int)(percent * (float)(this.totalContentHeight - this.scrollAreaHeight));
            return true;
        }
        if (this.isDraggingFileDropdown && this.fileDropdownContentHeight > this.fileDropdownHeight) {
            int newBarTop = (int)mouseY - this.fileDropdownDragOffset;
            int minBarTop = this.fileDropdownY;
            int barHeight = Math.max(20, this.fileDropdownHeight * this.fileDropdownHeight / Math.max(1, this.fileDropdownContentHeight));
            int maxBarTop = this.fileDropdownY + this.fileDropdownHeight - barHeight;
            newBarTop = Math.max(minBarTop, Math.min(maxBarTop, newBarTop));
            float percent = (float)(newBarTop - this.fileDropdownY) / (float)Math.max(1, this.fileDropdownHeight - barHeight);
            this.fileDropdownScroll = (int)(percent * (float)(this.fileDropdownContentHeight - this.fileDropdownHeight));
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        int button = click.method_74245();
        if (button == 0) {
            if (this.isScrolling) {
                this.isScrolling = false;
                return true;
            }
            if (this.isDraggingFileDropdown) {
                this.isDraggingFileDropdown = false;
                return true;
            }
        }
        return super.method_25406(click);
    }

    private boolean handleDropdownClick(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.fileDropdownX || mouseX > (double)(this.fileDropdownX + this.fileDropdownWidth) || mouseY < (double)this.fileDropdownY || mouseY > (double)(this.fileDropdownY + this.fileDropdownHeight)) {
            this.showFileDropdown = false;
            return false;
        }
        if (button != 0) {
            return true;
        }
        int relativeY = (int)(mouseY - (double)this.fileDropdownY + (double)this.fileDropdownScroll);
        int itemHeight = 18;
        int index = relativeY / itemHeight;
        if (index >= 0 && index < this.fileDropdownItems.size()) {
            MinemevFileInfo f = this.fileDropdownItems.get(index);
            this.startPerFileDownloadWithConfirm(f);
            this.showFileDropdown = false;
            return true;
        }
        return true;
    }

    private void startPerFileDownloadWithConfirm(MinemevFileInfo file) {
        String schematicsPath;
        File potentialFile;
        String chosenName = this.sanitizeFileName(file.getFileName() != null ? file.getFileName() : this.postDetail.getTitle());
        if (chosenName.toLowerCase().endsWith(".litematic")) {
            chosenName = chosenName.substring(0, chosenName.length() - ".litematic".length());
        }
        if ((potentialFile = new File((schematicsPath = SettingsManager.getSchematicsPath()) + File.separator + chosenName + ".litematic")).exists()) {
            String finalName = chosenName;
            MinemevFileInfo finalFile = file;
            ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + finalName + ".litematic\" already exists. Replace it?")), confirmed -> {
                if (confirmed.booleanValue()) {
                    this.performMinemevFileDownload(finalFile, finalName);
                }
                class_310.method_1551().method_1507((class_437)this);
            });
            class_310.method_1551().method_1507((class_437)confirmationScreen);
        } else {
            this.performMinemevFileDownload(file, chosenName);
        }
    }

    private void performMinemevFileDownload(MinemevFileInfo file, String chosenName) {
        try {
            String relativePath;
            String filenameForResolver = file.getFileName() != null && !file.getFileName().isEmpty() ? file.getFileName() : chosenName + ".litematic";
            String resolvedUrl = MinemevHttpClient.getDownloadUrl(this.postUuid, filenameForResolver, file.getDownloadUrl());
            String filePath = LitematicHttpClient.downloadFileFromUrl(resolvedUrl, chosenName);
            String schematicsPath = SettingsManager.getSchematicsPath();
            if (filePath.startsWith(schematicsPath)) {
                String pathAfterBase = filePath.substring(schematicsPath.length());
                if (pathAfterBase.startsWith(File.separator)) {
                    pathAfterBase = pathAfterBase.substring(File.separator.length());
                }
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + pathAfterBase.replace(File.separator, "/");
            } else {
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + chosenName + ".litematic";
            }
            ToastManager.addToast("Schematic downloaded to: " + relativePath, false);
        }
        catch (Exception e) {
            ToastManager.addToast("Failed to download: " + e.getMessage(), true);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.showFileDropdown && mouseX >= (double)this.fileDropdownX && mouseX <= (double)(this.fileDropdownX + this.fileDropdownWidth) && mouseY >= (double)this.fileDropdownY && mouseY <= (double)(this.fileDropdownY + this.fileDropdownHeight) && this.fileDropdownContentHeight > this.fileDropdownHeight) {
            int delta = (int)(-verticalAmount * 20.0);
            this.fileDropdownScroll = Math.max(0, Math.min(this.fileDropdownContentHeight - this.fileDropdownHeight, this.fileDropdownScroll + delta));
            return true;
        }
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            double amount = verticalAmount != 0.0 ? verticalAmount : horizontalAmount;
            int scrollAmount = (int)(-amount * 20.0);
            this.descriptionScrollPos = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.descriptionScrollPos + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void drawLoadingAnimation(class_332 context, int centerX, int centerY) {
        int radius = 12;
        int segments = 8;
        int animationDuration = 1600;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.loadingStartTime;
        float rotation = (float)(elapsedTime % (long)animationDuration) / (float)animationDuration;
        for (int i = 0; i < segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments);
            angle = (float)((double)angle + (double)(rotation * 2.0f) * Math.PI);
            int x1 = centerX + (int)(Math.sin(angle) * (double)(radius - 3));
            int y1 = centerY + (int)(Math.cos(angle) * (double)(radius - 3));
            int x2 = centerX + (int)(Math.sin(angle) * (double)radius);
            int y2 = centerY + (int)(Math.cos(angle) * (double)radius);
            int alpha = 255 - i * 255 / segments;
            int color = 0xFFFFFF | alpha << 24;
            context.method_25294(x1, y1, x2 + 1, y2 + 1, color);
        }
    }

    private String detectImageFormat(byte[] imageData) {
        String startString;
        if (imageData.length < 12) {
            return "unknown";
        }
        if (imageData[0] == -119 && imageData[1] == 80 && imageData[2] == 78 && imageData[3] == 71) {
            return "png";
        }
        if (imageData[0] == -1 && imageData[1] == -40 && imageData[2] == -1) {
            return "jpeg";
        }
        if (imageData.length >= 6 && imageData[0] == 71 && imageData[1] == 73 && imageData[2] == 70) {
            return "gif";
        }
        if (imageData[0] == 66 && imageData[1] == 77) {
            return "bmp";
        }
        if (imageData.length >= 12 && imageData[0] == 82 && imageData[1] == 73 && imageData[2] == 70 && imageData[3] == 70 && imageData[8] == 87 && imageData[9] == 69 && imageData[10] == 66 && imageData[11] == 80) {
            return "webp";
        }
        if (imageData.length >= 4 && (imageData[0] == 73 && imageData[1] == 73 && imageData[2] == 42 && imageData[3] == 0 || imageData[0] == 77 && imageData[1] == 77 && imageData[2] == 0 && imageData[3] == 42)) {
            return "tiff";
        }
        if (imageData.length >= 4 && imageData[0] == 0 && imageData[1] == 0 && imageData[2] == 1 && imageData[3] == 0) {
            return "ico";
        }
        if (imageData.length >= 12 && imageData[4] == 102 && imageData[5] == 116 && imageData[6] == 121 && imageData[7] == 112 && imageData[8] == 97 && imageData[9] == 118 && imageData[10] == 105 && (imageData[11] == 102 || imageData[11] == 115)) {
            return "avif";
        }
        if (imageData.length >= 12 && imageData[4] == 102 && imageData[5] == 116 && imageData[6] == 121 && imageData[7] == 112 && (imageData[8] == 104 && imageData[9] == 101 && imageData[10] == 105 && imageData[11] == 99 || imageData[8] == 109 && imageData[9] == 105 && imageData[10] == 102 && imageData[11] == 49)) {
            return "heif";
        }
        if (imageData.length >= 5 && ((startString = new String(imageData, 0, Math.min(100, imageData.length)).toLowerCase()).contains("<svg") || startString.startsWith("<?xml") && startString.contains("svg"))) {
            return "svg";
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertImageToPng(byte[] imageData, String format) throws Exception {
        System.out.println("[DEBUG] convertImageToPng called with format: " + format + ", data size: " + imageData.length + " bytes");
        if (format.equals("png") || format.equals("unknown")) {
            System.out.println("[DEBUG] Format is PNG or unknown, returning original data");
            return imageData;
        }
        if (format.equals("svg")) {
            System.err.println("[DEBUG] SVG format detected, throwing exception");
            throw new Exception("SVG format is not supported for conversion");
        }
        if (format.equals("avif") || format.equals("heif")) {
            System.err.println("[DEBUG] " + format.toUpperCase() + " format detected, throwing exception");
            throw new Exception(format.toUpperCase() + " format is not supported by Java ImageIO");
        }
        try {
            BufferedImage convertedImage;
            BufferedImage bufferedImage;
            block32: {
                bufferedImage = null;
                System.out.println("[DEBUG] Attempting auto-detection with ImageInputStream for format: " + format);
                try (ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));){
                    Iterator<ImageReader> autoReaders = ImageIO.getImageReaders(iis);
                    if (autoReaders.hasNext()) {
                        ImageReader reader = autoReaders.next();
                        System.out.println("[DEBUG] Found auto-reader: " + reader.getClass().getSimpleName() + " for format: " + format);
                        try {
                            reader.setInput(iis, true, true);
                            bufferedImage = reader.read(0);
                            System.out.println("[DEBUG] Successfully read image using auto-reader for format: " + format + ", dimensions: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                            break block32;
                        }
                        finally {
                            reader.dispose();
                        }
                    }
                    System.out.println("[DEBUG] No auto-readers found for format: " + format);
                }
                catch (Exception e) {
                    System.err.println("[DEBUG] Auto-detection failed for format: " + format + " - " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                System.out.println("[DEBUG] Attempting ImageIO.read convenience method for format: " + format);
                try {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                    if (bufferedImage != null) {
                        System.out.println("[DEBUG] Successfully read image using convenience method for format: " + format + ", dimensions: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                    } else {
                        System.out.println("[DEBUG] Convenience method returned null for format: " + format);
                    }
                }
                catch (Exception e) {
                    System.err.println("[DEBUG] Convenience method failed for format: " + format + " - " + e.getMessage());
                }
            }
            if (bufferedImage == null && !format.equals("unknown")) {
                System.out.println("[DEBUG] Attempting explicit readers by format name: " + format.toUpperCase());
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(format.toUpperCase());
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        System.out.println("[DEBUG] Found explicit reader: " + reader.getClass().getSimpleName() + " for format: " + format);
                        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));
                        reader.setInput(iis);
                        bufferedImage = reader.read(0);
                        System.out.println("[DEBUG] Successfully read image using explicit reader for format: " + format + ", dimensions: " + bufferedImage.getWidth() + "x" + bufferedImage.getHeight());
                        reader.dispose();
                        iis.close();
                    } else {
                        System.out.println("[DEBUG] No explicit readers found for format: " + format.toUpperCase());
                    }
                }
                catch (Exception e) {
                    System.err.println("[DEBUG] Explicit reader failed for format: " + format + " - " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                System.err.println("[DEBUG] All image reading methods failed for format: " + format);
                throw new Exception("Could not decode " + format + " image");
            }
            System.out.println("[DEBUG] Image successfully decoded, converting to appropriate format for format: " + format);
            System.out.println("[DEBUG] Original BufferedImage type: " + bufferedImage.getType() + " for format: " + format);
            if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
                System.out.println("[DEBUG] Converting BufferedImage type from " + bufferedImage.getType() + " to TYPE_INT_ARGB for format: " + format);
                convertedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                Graphics2D g2d = convertedImage.createGraphics();
                g2d.drawImage((Image)bufferedImage, 0, 0, null);
                g2d.dispose();
                System.out.println("[DEBUG] BufferedImage type conversion completed for format: " + format);
            } else {
                System.out.println("[DEBUG] BufferedImage type is already compatible, no conversion needed for format: " + format);
                convertedImage = bufferedImage;
            }
            System.out.println("[DEBUG] Writing BufferedImage to PNG format for format: " + format);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean success = ImageIO.write((RenderedImage)convertedImage, "PNG", baos);
            if (!success) {
                System.err.println("[DEBUG] Failed to write PNG output for format: " + format);
                throw new Exception("Failed to write PNG output");
            }
            byte[] result = baos.toByteArray();
            System.out.println("[DEBUG] Successfully converted " + format + " to PNG, output size: " + result.length + " bytes");
            return result;
        }
        catch (Exception e) {
            System.err.println("[DEBUG] Exception during image conversion for format: " + format + " - " + e.getMessage());
            e.printStackTrace();
            if (format.equals("svg") || format.equals("avif") || format.equals("heif")) {
                throw e;
            }
            System.out.println("[DEBUG] Falling back to original image data for format: " + format);
            return imageData;
        }
    }

    private void createAndRegisterPlaceholder(String reason) {
        try {
            String uniqueId = UUID.randomUUID().toString().replace("-", "");
            this.coverImageTexture = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
            class_1011 nativeImage = this.createPlaceholderImage(256, 256, reason);
            if (nativeImage != null) {
                this.imageWidth = nativeImage.method_4307();
                this.imageHeight = nativeImage.method_4323();
                class_310.method_1551().method_1531().method_4616(this.coverImageTexture, (class_1044)new class_1043(() -> "minemev_placeholder", nativeImage));
            }
        }
        catch (Exception e) {
            this.coverImageTexture = null;
        }
    }

    private class_1011 createPlaceholderImage(int width, int height, String reason) {
        try {
            int x;
            System.out.println("[DEBUG] Creating placeholder image: " + width + "x" + height + " with reason: " + reason);
            class_1011 image = new class_1011(class_1011.class_1012.field_4997, width, height, false);
            int bgColor = -13421773;
            for (int y = 0; y < height; ++y) {
                for (x = 0; x < width; ++x) {
                    image.method_4305(x, y, bgColor);
                }
            }
            int borderColor = -10066330;
            for (x = 0; x < width; ++x) {
                image.method_4305(x, 0, borderColor);
                image.method_4305(x, height - 1, borderColor);
            }
            for (int y = 0; y < height; ++y) {
                image.method_4305(0, y, borderColor);
                image.method_4305(width - 1, y, borderColor);
            }
            int xColor = -6710887;
            for (int i = 0; i < Math.min(width, height); ++i) {
                int x2;
                if (i < width && i < height) {
                    image.method_4305(i, i, xColor);
                    if (i > 0 && i < width - 1 && i < height - 1) {
                        image.method_4305(i - 1, i, xColor);
                        image.method_4305(i + 1, i, xColor);
                        image.method_4305(i, i - 1, xColor);
                        image.method_4305(i, i + 1, xColor);
                    }
                }
                if ((x2 = width - 1 - i) < 0 || x2 >= width || i >= height) continue;
                image.method_4305(x2, i, xColor);
                if (x2 <= 0 || x2 >= width - 1 || i <= 0 || i >= height - 1) continue;
                image.method_4305(x2 - 1, i, xColor);
                image.method_4305(x2 + 1, i, xColor);
                image.method_4305(x2, i - 1, xColor);
                image.method_4305(x2, i + 1, xColor);
            }
            System.out.println("[DEBUG] Successfully created placeholder image for reason: " + reason);
            return image;
        }
        catch (Exception e) {
            System.err.println("[DEBUG] Failed to create placeholder image: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private String encodeImageUrl(String url) {
        try {
            URL parsedUrl = new URL(url);
            String encodedPath = URLEncoder.encode(parsedUrl.getPath(), "UTF-8").replace("%2F", "/").replace("+", "%20");
            return parsedUrl.getProtocol() + "://" + parsedUrl.getHost() + (String)(parsedUrl.getPort() != -1 ? ":" + parsedUrl.getPort() : "") + encodedPath;
        }
        catch (Exception e) {
            return url.replace(" ", "%20");
        }
    }

    private String joinArray(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        ArrayList<String> items = new ArrayList<String>();
        for (String s : arr) {
            String t;
            if (s == null || (t = s.trim()).isEmpty()) continue;
            items.add(t);
        }
        if (items.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)", ", items);
    }

    private String joinArrayShort(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        ArrayList<String> items = new ArrayList<String>();
        for (String s : arr) {
            String t;
            if (s == null || (t = s.trim()).isEmpty()) continue;
            items.add(t);
        }
        return String.join((CharSequence)", ", items);
    }

    private String formatSize(long bytes) {
        int idx;
        if (bytes <= 0L) {
            return "";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB"};
        double b = bytes;
        for (idx = 0; b >= 1024.0 && idx < units.length - 1; b /= 1024.0, ++idx) {
        }
        return String.format(Locale.ROOT, "%.1f %s", b, units[idx]);
    }

    private String trimToWidth(String text, int maxWidth) {
        String next;
        if (this.field_22793.method_1727(text) <= maxWidth) {
            return text;
        }
        String ellipsis = "...";
        int ellipsisWidth = this.field_22793.method_1727(ellipsis);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length() && this.field_22793.method_1727(next = sb.toString() + text.charAt(i)) + ellipsisWidth <= maxWidth; ++i) {
            sb.append(text.charAt(i));
        }
        return sb.append(ellipsis).toString();
    }

    private String sanitizeFileName(String name) {
        String n = name == null || name.isEmpty() ? "minemev_schematic" : name;
        n = n.replaceAll("[^a-zA-Z0-9.-]", "_");
        return n;
    }

    public boolean method_25404(class_11908 input) {
        int key = input.comp_4795();
        if (this.imageUrls != null && this.imageUrls.length > 1) {
            if (key == 263) {
                this.currentImageIndex = (this.currentImageIndex - 1 + this.imageUrls.length) % this.imageUrls.length;
                this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                this.updateImageButtonsState();
                return true;
            }
            if (key == 262) {
                this.currentImageIndex = (this.currentImageIndex + 1) % this.imageUrls.length;
                this.loadCoverImage(this.imageUrls[this.currentImageIndex]);
                this.updateImageButtonsState();
                return true;
            }
        }
        return super.method_25404(input);
    }
}

