/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.CacheManager;
import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.DetailScreen;
import com.choculaterie.gui.FileManagerScreen;
import com.choculaterie.gui.MinemevDetailScreen;
import com.choculaterie.gui.NavigationState;
import com.choculaterie.gui.SettingsScreen;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.MinemevFileInfo;
import com.choculaterie.models.MinemevPostDetailInfo;
import com.choculaterie.models.MinemevPostInfo;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.choculaterie.networking.LitematicHttpClient;
import com.choculaterie.networking.MinemevHttpClient;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LitematicDownloaderScreen
extends class_437 {
    private ReferenceImmutableList<SchematicInfo> schematics = new ReferenceImmutableList(new ArrayList());
    private class_342 searchField;
    private String searchTerm = "";
    private boolean isSearchMode = false;
    private int currentPage = 1;
    private int totalPages = 1;
    private int totalItems = 0;
    private final int pageSize = 15;
    private boolean showUnverified = false;
    private static final CacheManager cacheManager = new CacheManager();
    private static final long CACHE_DURATION_MS = 900000L;
    private static final long DETAIL_CACHE_DURATION_MS = 300000L;
    private volatile int activeRequestPage = -1;
    private volatile long lastRequestTime = 0L;
    private static final long MIN_REQUEST_INTERVAL_MS = 100L;
    private int scrollOffset = 0;
    private final int itemHeight = 40;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private int scrollDragOffset = 0;
    private String statusMessage = null;
    private int statusColor = -1;
    private long statusMessageDisplayTime = 0L;
    private static final long STATUS_MESSAGE_DURATION = 3000L;
    private int lastClickedIndex = -1;
    private long lastClickTime = 0L;
    private boolean isLoading = false;
    private long loadingStartTime = 0L;
    private long lastSearchTime = 0L;
    private static final long SEARCH_DEBOUNCE_MS = 500L;
    private String lastSearchedTerm = "";
    private int hoveredItemIndex = -1;
    private long hoverStartTime = 0L;
    private static final long HOVER_DELAY_MS = 200L;
    private boolean isPreloadingHoveredItem = false;
    @Nullable
    private String currentlyPreloadingId = null;
    private boolean isPreloadingPagination = false;
    private int preloadingPageNumber = -1;
    private ServerMode serverMode = ServerMode.CHOCULATERIE;
    private boolean chocEnabled = true;
    private boolean mineEnabled = true;
    private boolean showSourcesDropdown = false;
    private int sourcesDropdownX = 0;
    private int sourcesDropdownY = 0;
    private int sourcesDropdownWidth = 130;
    private int sourcesDropdownHeight = 0;
    private boolean showFileDropdown = false;
    private List<MinemevFileInfo> fileDropdownItems = new ArrayList<MinemevFileInfo>();
    private int fileDropdownX = 0;
    private int fileDropdownY = 0;
    private int fileDropdownWidth = 320;
    private int fileDropdownHeight = 0;
    private int fileDropdownScroll = 0;
    private final int fileDropdownItemHeight = 18;
    private int fileDropdownContentHeight = 0;
    @Nullable
    private String fileDropdownPostId = null;
    private String fileDropdownBaseName = "";
    private String lastPaginationText = "";
    private boolean lastIsLoading = false;
    private boolean lastSchematicsEmpty = true;
    private int lastSchematicsSize = 0;
    private int lastCurrentPage = 0;
    private int lastTotalPages = 0;
    private int lastTotalItems = 0;

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public LitematicDownloaderScreen() {
        super((class_2561)class_2561.method_43470((String)""));
    }

    public LitematicDownloaderScreen(boolean restoreState) {
        super((class_2561)class_2561.method_43470((String)""));
        if (restoreState) {
            // empty if block
        }
    }

    public void restoreNavigationState(int currentPage, int totalPages, int totalItems, boolean isSearchMode, String searchTerm, String lastSearchedTerm, int scrollOffset) {
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        this.totalItems = totalItems;
        this.isSearchMode = isSearchMode;
        this.searchTerm = searchTerm;
        this.lastSearchedTerm = lastSearchedTerm;
        this.scrollOffset = scrollOffset;
        System.out.println("Restored navigation state in screen: page=" + currentPage + ", scroll=" + scrollOffset);
    }

    protected void method_25426() {
        super.method_25426();
        this.chocEnabled = SettingsManager.isChoculaterieEnabled();
        this.mineEnabled = SettingsManager.isMinemevEnabled();
        this.recalcServerMode();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), button -> class_310.method_1551().method_1507((class_437)new FileManagerScreen(this))).method_46434(this.field_22789 - 65, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), button -> class_310.method_1551().method_1507((class_437)new SettingsScreen(this, changed -> {
            if (changed.booleanValue()) {
                this.loadSchematics();
            }
        }))).method_46434(this.field_22789 - 90, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), button -> {
            cacheManager.clearAllCache();
            LitematicHttpClient.clearCaches();
            if (this.isSearchMode) {
                this.performSearch();
            } else {
                this.loadSchematics();
            }
        }).method_46434(this.field_22789 - 40, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.showUnverified ? "\u2713" : "\u2717")), button -> {
            this.showUnverified = !this.showUnverified;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.showUnverified ? "\u2713" : "\u2717")));
            cacheManager.clearAllCache();
            LitematicHttpClient.clearCaches();
            this.currentPage = 1;
            if (this.isSearchMode) {
                this.performSearch();
            } else {
                this.loadSchematics();
            }
        }).method_46434(this.field_22789 - 115, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Sites"), button -> {
            this.showSourcesDropdown = !this.showSourcesDropdown;
            this.sourcesDropdownWidth = 150;
            this.sourcesDropdownX = this.field_22789 - 165;
            this.sourcesDropdownY = 35;
            this.sourcesDropdownHeight = 48;
        }).method_46434(this.field_22789 - 165, 10, 45, 20).method_46431());
        int contentWidth = Math.min(600, this.field_22789 - 80);
        this.scrollAreaX = (this.field_22789 - contentWidth) / 2;
        this.scrollAreaY = 70;
        this.scrollAreaWidth = contentWidth;
        this.scrollAreaHeight = this.field_22790 - this.scrollAreaY - 40;
        int searchFieldWidth = 200;
        this.searchField = new class_342(this.field_22793, (this.field_22789 - searchFieldWidth) / 2, 10, searchFieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_1880(50);
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_1863(text -> {
            this.searchTerm = text.trim();
        });
        this.method_25429((class_364)this.searchField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> {
            this.searchField.method_1852("");
            this.isSearchMode = false;
            this.currentPage = 1;
            this.loadSchematics();
        }).method_46434((this.field_22789 + searchFieldWidth) / 2 + 5, 10, 20, 20).method_46431());
        this.setupPaginationControls();
        this.updateScrollbarDimensions();
        NavigationState navState = NavigationState.getInstance();
        if (this instanceof LitematicDownloaderScreen && navState.getSavedCurrentPage() > 0) {
            navState.restoreState(this);
            if (this.isSearchMode && !this.searchTerm.isEmpty()) {
                this.searchField.method_1852(this.searchTerm);
            }
        }
        this.loadSchematics();
    }

    private void recalcServerMode() {
        if (this.chocEnabled && this.mineEnabled) {
            this.serverMode = ServerMode.BOTH;
        } else if (this.chocEnabled) {
            this.serverMode = ServerMode.CHOCULATERIE;
        } else if (this.mineEnabled) {
            this.serverMode = ServerMode.MINEMEV;
        } else {
            this.chocEnabled = true;
            SettingsManager.setSourcesEnabled(this.chocEnabled, this.mineEnabled);
            this.serverMode = ServerMode.CHOCULATERIE;
        }
    }

    public boolean method_25404(class_11908 input) {
        String text;
        int key;
        if (this.searchField.method_25370() && ((key = input.comp_4795()) == 257 || key == 335) && !(text = this.searchField.method_1882().trim()).isEmpty()) {
            this.searchTerm = text;
            this.lastSearchedTerm = text;
            this.isSearchMode = true;
            this.currentPage = 1;
            this.performSearch();
            return true;
        }
        return super.method_25404(input);
    }

    private void setupPaginationControls() {
        int centerX = this.field_22789 / 2;
        int paginationY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), button -> {
            if (this.currentPage > 1) {
                --this.currentPage;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX - 100, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), button -> {
            if (this.currentPage < this.totalPages) {
                ++this.currentPage;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX + 80, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23ee"), button -> {
            if (this.currentPage > 1) {
                this.currentPage = 1;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX - 125, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23ed"), button -> {
            if (this.currentPage < this.totalPages) {
                this.currentPage = this.totalPages;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX + 105, paginationY, 20, 20).method_46431());
    }

    private void performSearch() {
        if (this.searchTerm.isEmpty()) {
            return;
        }
        this.recalcServerMode();
        if (this.serverMode == ServerMode.CHOCULATERIE) {
            if (cacheManager.hasValidSearchCache(this.searchTerm, 900000L)) {
                this.schematics = cacheManager.getSearchCache(this.searchTerm).getItems();
                this.totalPages = 1;
                this.totalItems = this.schematics.size();
                this.updateScrollbarDimensions();
                return;
            }
            this.schematics = new ReferenceImmutableList(new ArrayList());
            this.updateScrollbarDimensions();
            this.scrollOffset = 0;
            this.isLoading = true;
            this.loadingStartTime = System.currentTimeMillis();
            new Thread(() -> {
                ReferenceImmutableList searchResults = new ReferenceImmutableList(LitematicHttpClient.searchSchematics(this.searchTerm));
                class_310.method_1551().execute(() -> {
                    this.schematics = searchResults;
                    this.totalPages = 1;
                    this.totalItems = searchResults.size();
                    cacheManager.putSearchCache(this.searchTerm, (ReferenceImmutableList<SchematicInfo>)searchResults);
                    this.updateScrollbarDimensions();
                    this.isLoading = false;
                });
            }).start();
            return;
        }
        this.schematics = new ReferenceImmutableList(new ArrayList());
        this.updateScrollbarDimensions();
        this.scrollOffset = 0;
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        String term = this.searchTerm;
        new Thread(() -> {
            ArrayList<SchematicInfo> merged = new ArrayList<SchematicInfo>();
            int totalCount = 0;
            try {
                if (this.mineEnabled) {
                    MinemevHttpClient.MinemevSearchResult mres = MinemevHttpClient.searchPosts(term, 1);
                    for (MinemevPostInfo post : mres.getPosts()) {
                        merged.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                    }
                    totalCount += mres.getTotalResults();
                }
                if (this.chocEnabled) {
                    List<SchematicInfo> cres = LitematicHttpClient.searchSchematics(term);
                    merged.addAll(cres);
                    totalCount += cres.size();
                }
            }
            catch (Exception e) {
                System.err.println("Search error: " + e.getMessage());
            }
            ReferenceImmutableList finalList = new ReferenceImmutableList(merged);
            int finalTotal = totalCount > 0 ? totalCount : merged.size();
            class_310.method_1551().execute(() -> {
                this.schematics = finalList;
                this.totalPages = 1;
                this.totalItems = finalTotal;
                this.updateScrollbarDimensions();
                this.isLoading = false;
            });
        }).start();
    }

    private void loadSchematics() {
        this.recalcServerMode();
        System.out.println("=== loadSchematics() called for page " + this.currentPage + " ===");
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRequestTime < 100L) {
            System.out.println("Request throttled - too soon after last request");
            return;
        }
        if (this.activeRequestPage != -1 && this.activeRequestPage != this.currentPage) {
            System.out.println("Cancelling request for page " + this.activeRequestPage + " to load page " + this.currentPage);
            this.activeRequestPage = -1;
        }
        cacheManager.debugPrintCachedPages();
        if (this.serverMode == ServerMode.BOTH) {
            boolean hasMinemevCache;
            boolean hasChocCache = this.chocEnabled && cacheManager.hasValidSchematicCache(this.currentPage, 900000L);
            boolean bl = hasMinemevCache = this.mineEnabled && cacheManager.hasValidMinemevCache(this.currentPage, 900000L);
            if (hasChocCache && hasMinemevCache) {
                CacheManager.SchematicCacheEntry chocEntry = cacheManager.getSchematicCache(this.currentPage);
                CacheManager.MinemevCacheEntry minemevEntry = cacheManager.getMinemevCache(this.currentPage);
                if (!chocEntry.getItems().isEmpty() || !minemevEntry.getItems().isEmpty()) {
                    System.out.println("Using cached data from BOTH sources for page " + this.currentPage);
                    ArrayList<SchematicInfo> merged = new ArrayList<SchematicInfo>();
                    merged.addAll((Collection<SchematicInfo>)chocEntry.getItems());
                    for (MinemevPostInfo post : minemevEntry.getItems()) {
                        merged.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                    }
                    this.schematics = new ReferenceImmutableList(merged);
                    this.totalPages = Math.max(chocEntry.getTotalPages(), minemevEntry.getTotalPages());
                    this.totalItems = chocEntry.getTotalItems() + minemevEntry.getTotalItems();
                    this.updateScrollbarDimensions();
                    System.out.println("Loaded " + this.schematics.size() + " items from BOTH caches for page " + this.currentPage);
                    return;
                }
            }
        }
        if (cacheManager.hasValidSchematicCache(this.currentPage, 900000L) && this.chocEnabled) {
            CacheManager.SchematicCacheEntry cachedEntry = cacheManager.getSchematicCache(this.currentPage);
            if (!cachedEntry.getItems().isEmpty()) {
                System.out.println("Using cached Choculaterie data for page " + this.currentPage);
                if (this.serverMode == ServerMode.CHOCULATERIE) {
                    this.schematics = cachedEntry.getItems();
                    this.totalPages = cachedEntry.getTotalPages();
                    this.totalItems = cachedEntry.getTotalItems();
                    this.updateScrollbarDimensions();
                    System.out.println("Loaded " + this.schematics.size() + " items from cache for page " + this.currentPage);
                    return;
                }
                if (this.serverMode == ServerMode.BOTH) {
                    this.schematics = cachedEntry.getItems();
                    this.updateScrollbarDimensions();
                    System.out.println("Displayed cached Choc items for page " + this.currentPage + " while merging Minemev in background");
                    if (this.mineEnabled) {
                        CacheManager.SchematicCacheEntry ce = cachedEntry;
                        int requestedPage = this.currentPage;
                        new Thread(() -> {
                            try {
                                if (this.currentPage != requestedPage) {
                                    System.out.println("Minemev merge cancelled - page changed from " + requestedPage + " to " + this.currentPage);
                                    return;
                                }
                                MinemevHttpClient.MinemevSearchResult mres = MinemevHttpClient.searchPosts(null, null, null, "newest", requestedPage);
                                class_310.method_1551().execute(() -> cacheManager.putMinemevCache(mres));
                                ArrayList<SchematicInfo> merged = new ArrayList<SchematicInfo>();
                                merged.addAll((Collection<SchematicInfo>)ce.getItems());
                                for (MinemevPostInfo post : mres.getPosts()) {
                                    merged.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                                }
                                ReferenceImmutableList items = new ReferenceImmutableList(merged);
                                int pagesChoc = Math.max(1, ce.getTotalPages());
                                int pagesMine = Math.max(1, mres.getTotalPages());
                                int finalPages = Math.max(pagesChoc, pagesMine);
                                int finalTotal = ce.getTotalItems() + Math.max(mres.getTotalResults(), mres.getPosts().size());
                                class_310.method_1551().execute(() -> {
                                    if (this.currentPage == requestedPage) {
                                        this.schematics = items;
                                        this.totalPages = finalPages;
                                        this.totalItems = finalTotal > 0 ? finalTotal : items.size();
                                        this.updateScrollbarDimensions();
                                        System.out.println("Merged Minemev items into cached Choc list for page " + requestedPage);
                                    } else {
                                        System.out.println("Discarded Minemev merge for page " + requestedPage + " - now on page " + this.currentPage);
                                    }
                                });
                            }
                            catch (Exception e) {
                                System.err.println("Failed to fetch Minemev portion while merging cached Choc data: " + e.getMessage());
                            }
                        }).start();
                    } else {
                        this.totalPages = cachedEntry.getTotalPages();
                        this.totalItems = cachedEntry.getTotalItems();
                    }
                    return;
                }
            } else {
                System.out.println("Cache entry exists but is empty for page " + this.currentPage + ", fetching from server...");
            }
        }
        if (cacheManager.hasValidMinemevCache(this.currentPage, 900000L) && this.mineEnabled) {
            CacheManager.MinemevCacheEntry cachedEntry = cacheManager.getMinemevCache(this.currentPage);
            if (!cachedEntry.getItems().isEmpty()) {
                System.out.println("Using cached Minemev data for page " + this.currentPage);
                if (this.serverMode == ServerMode.MINEMEV) {
                    ArrayList<SchematicInfo> converted = new ArrayList<SchematicInfo>();
                    for (MinemevPostInfo post : cachedEntry.getItems()) {
                        converted.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                    }
                    this.schematics = new ReferenceImmutableList(converted);
                    this.totalPages = cachedEntry.getTotalPages();
                    this.totalItems = cachedEntry.getTotalItems();
                    this.updateScrollbarDimensions();
                    System.out.println("Loaded " + this.schematics.size() + " Minemev items from cache for page " + this.currentPage);
                    return;
                }
            } else {
                System.out.println("Minemev cache entry exists but is empty for page " + this.currentPage + ", fetching from server...");
            }
        }
        if (this.activeRequestPage == this.currentPage && this.isLoading) {
            System.out.println("Already loading page " + this.currentPage + " - ignoring duplicate request");
            return;
        }
        System.out.println("No valid cache for page " + this.currentPage + ", fetching from server...");
        this.activeRequestPage = this.currentPage;
        this.lastRequestTime = currentTime;
        if (this.schematics.isEmpty()) {
            this.scrollOffset = 0;
        }
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        int requestedPage = this.currentPage;
        ReferenceImmutableList<SchematicInfo> previousSchematics = this.schematics;
        new Thread(() -> {
            try {
                if (this.activeRequestPage != requestedPage) {
                    System.out.println("Request for page " + requestedPage + " cancelled - now loading page " + this.activeRequestPage);
                    class_310.method_1551().execute(() -> {
                        this.isLoading = false;
                    });
                    return;
                }
                ArrayList<SchematicInfo> merged = new ArrayList<SchematicInfo>();
                int pagesChoc = 1;
                int pagesMine = 1;
                int totalCount = 0;
                if (this.serverMode == ServerMode.CHOCULATERIE) {
                    if (this.activeRequestPage != requestedPage) {
                        System.out.println("Choculaterie request for page " + requestedPage + " cancelled before API call");
                        class_310.method_1551().execute(() -> {
                            this.isLoading = false;
                        });
                        return;
                    }
                    LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(requestedPage, 15, this.showUnverified);
                    merged.addAll((Collection<SchematicInfo>)result.getItems());
                    pagesChoc = Math.max(1, result.getTotalPages());
                    totalCount = result.getTotalItems();
                    cacheManager.putSchematicCache(result);
                } else if (this.serverMode == ServerMode.MINEMEV) {
                    if (this.activeRequestPage != requestedPage) {
                        System.out.println("Minemev request for page " + requestedPage + " cancelled before API call");
                        class_310.method_1551().execute(() -> {
                            this.isLoading = false;
                        });
                        return;
                    }
                    MinemevHttpClient.MinemevSearchResult mres = MinemevHttpClient.searchPosts(null, null, null, "newest", requestedPage);
                    cacheManager.putMinemevCache(mres);
                    for (MinemevPostInfo post : mres.getPosts()) {
                        merged.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                    }
                    pagesMine = Math.max(1, mres.getTotalPages());
                    totalCount = Math.max(mres.getTotalResults(), merged.size());
                } else {
                    int chocPageSize = 10;
                    if (this.chocEnabled) {
                        if (this.activeRequestPage != requestedPage) {
                            System.out.println("BOTH mode Choculaterie request for page " + requestedPage + " cancelled");
                            class_310.method_1551().execute(() -> {
                                this.isLoading = false;
                            });
                            return;
                        }
                        System.out.println("Fetching page " + requestedPage + " from Choculaterie (10 items)...");
                        LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(requestedPage, chocPageSize, this.showUnverified);
                        merged.addAll((Collection<SchematicInfo>)result.getItems());
                        pagesChoc = Math.max(1, result.getTotalPages());
                        int chocTotal = result.getTotalItems();
                        totalCount += chocTotal;
                        cacheManager.putSchematicCache(result);
                    }
                    if (this.mineEnabled) {
                        if (this.activeRequestPage != requestedPage) {
                            System.out.println("BOTH mode Minemev request for page " + requestedPage + " cancelled");
                            class_310.method_1551().execute(() -> {
                                this.isLoading = false;
                            });
                            return;
                        }
                        System.out.println("Fetching page " + requestedPage + " from Minemev (10 items)...");
                        MinemevHttpClient.MinemevSearchResult mres = MinemevHttpClient.searchPosts(null, null, null, "newest", requestedPage);
                        cacheManager.putMinemevCache(mres);
                        for (MinemevPostInfo post : mres.getPosts()) {
                            merged.add(new SchematicInfo(post.getUuid(), post.getTitle(), post.getDescription(), 0, post.getDownloads(), post.getAuthor(), SchematicInfo.SourceServer.MINEMEV));
                        }
                        pagesMine = Math.max(1, mres.getTotalPages());
                        int mineTotal = Math.max(mres.getTotalResults(), mres.getPosts().size());
                        totalCount += mineTotal;
                    }
                }
                ReferenceImmutableList items = new ReferenceImmutableList(merged);
                int finalPages = this.serverMode == ServerMode.BOTH ? Math.max(pagesChoc, pagesMine) : (this.serverMode == ServerMode.CHOCULATERIE ? pagesChoc : pagesMine);
                int finalTotal = totalCount > 0 ? totalCount : items.size();
                class_310.method_1551().execute(() -> {
                    if (this.activeRequestPage != requestedPage || this.currentPage != requestedPage) {
                        System.out.println("Discarding results for page " + requestedPage + " - current page is " + this.currentPage + ", active request is " + this.activeRequestPage);
                        this.isLoading = false;
                        return;
                    }
                    this.schematics = items;
                    this.totalPages = finalPages;
                    this.totalItems = finalTotal;
                    this.scrollOffset = 0;
                    this.updateScrollbarDimensions();
                    this.isLoading = false;
                    this.activeRequestPage = -1;
                    System.out.println("Successfully loaded page " + requestedPage + " with " + items.size() + " items");
                    cacheManager.debugPrintCachedPages();
                });
            }
            catch (Exception e) {
                System.err.println("Error fetching page " + requestedPage + ": " + e.getMessage());
                e.printStackTrace();
                class_310.method_1551().execute(() -> {
                    this.isLoading = false;
                    if (this.activeRequestPage == requestedPage) {
                        this.activeRequestPage = -1;
                    }
                });
            }
        }).start();
    }

    private void performSearchForced() {
        cacheManager.clearSearchCache(this.searchTerm);
        LitematicHttpClient.clearCaches();
        this.performSearch();
    }

    private void loadSchematicsForced() {
        cacheManager.clearSchematicCache(this.currentPage);
        LitematicHttpClient.clearCaches();
        this.loadSchematics();
    }

    private void updateScrollbarDimensions() {
        this.totalContentHeight = this.schematics.size() * 40;
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.min(this.scrollOffset, this.totalContentHeight - this.scrollAreaHeight);
    }

    private void checkAndLogStateChanges() {
        String currentPaginationText = this.isSearchMode ? "Found " + this.totalItems + " results" : "Page " + this.currentPage + " of " + this.totalPages + " (" + this.totalItems + " total)";
        if (!currentPaginationText.equals(this.lastPaginationText)) {
            System.out.println("DEBUG PAGINATION CHANGE: '" + this.lastPaginationText + "' -> '" + currentPaginationText + "'");
            System.out.println("  currentPage: " + this.lastCurrentPage + " -> " + this.currentPage);
            System.out.println("  totalPages: " + this.lastTotalPages + " -> " + this.totalPages);
            System.out.println("  totalItems: " + this.lastTotalItems + " -> " + this.totalItems);
            System.out.println("  isSearchMode: " + this.isSearchMode + ", serverMode: " + String.valueOf((Object)this.serverMode));
            this.lastPaginationText = currentPaginationText;
            this.lastCurrentPage = this.currentPage;
            this.lastTotalPages = this.totalPages;
            this.lastTotalItems = this.totalItems;
        }
        boolean currentSchematicsEmpty = this.schematics.isEmpty();
        int currentSchematicsSize = this.schematics.size();
        if (currentSchematicsEmpty != this.lastSchematicsEmpty || this.isLoading != this.lastIsLoading || currentSchematicsSize != this.lastSchematicsSize) {
            System.out.println("DEBUG RENDER STATE CHANGE:");
            System.out.println("  schematics.isEmpty(): " + this.lastSchematicsEmpty + " -> " + currentSchematicsEmpty);
            System.out.println("  schematics.size(): " + this.lastSchematicsSize + " -> " + currentSchematicsSize);
            System.out.println("  isLoading: " + this.lastIsLoading + " -> " + this.isLoading);
            System.out.println("  isSearchMode: " + this.isSearchMode + ", serverMode: " + String.valueOf((Object)this.serverMode));
            if (currentSchematicsEmpty) {
                if (this.isLoading) {
                    System.out.println("  -> Will display: 'Loading...'");
                } else if (this.isSearchMode) {
                    System.out.println("  -> Will display: 'No results found for: " + this.lastSearchedTerm + "'");
                } else {
                    System.out.println("  -> Will display: 'No schematics found'");
                }
            } else {
                System.out.println("  -> Will display: " + currentSchematicsSize + " schematic items");
            }
            this.lastSchematicsEmpty = currentSchematicsEmpty;
            this.lastSchematicsSize = currentSchematicsSize;
            this.lastIsLoading = this.isLoading;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.checkAndLogStateChanges();
        this.handleHoverPreloading(mouseX, mouseY);
        this.handlePaginationHoverPreloading(mouseX, mouseY);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2 - this.searchField.method_25368() / 4, 10, -1);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), this.searchField.method_46426() - 15, this.searchField.method_46427() + 5, -5592406);
        String paginationText = this.isSearchMode ? "Found " + this.totalItems + " results" : "Page " + this.currentPage + " of " + this.totalPages + " (" + this.totalItems + " total)";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)paginationText), this.field_22789 / 2, 40, -1);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        if (this.schematics.isEmpty()) {
            if (this.isLoading) {
                int centerY = this.scrollAreaY + this.scrollAreaHeight / 2;
                this.drawLoadingAnimation(context, this.field_22789 / 2, centerY - 15);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), this.field_22789 / 2, centerY + 15, -1);
            } else if (this.isSearchMode) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("No results found for: " + this.lastSearchedTerm)), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, -1);
            } else {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No schematics found"), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, -1);
            }
        } else {
            int y = this.scrollAreaY - this.scrollOffset;
            for (int i = 0; i < this.schematics.size(); ++i) {
                SchematicInfo schematic = (SchematicInfo)this.schematics.get(i);
                if (y + 40 >= this.scrollAreaY && y <= this.scrollAreaY + this.scrollAreaHeight) {
                    this.renderSchematicItem(context, schematic, this.scrollAreaX, y, this.scrollAreaWidth, mouseX, mouseY, i);
                    context.method_25294(this.scrollAreaX, y + 40 - 5, this.scrollAreaX + this.scrollAreaWidth - 10, y + 40 - 4, 0x22FFFFFF);
                }
                y += 40;
            }
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        ToastManager.render(context, this.field_22789);
        if (this.showFileDropdown && !this.fileDropdownItems.isEmpty()) {
            this.renderFileDropdown(context, mouseX, mouseY);
        }
        if (this.showSourcesDropdown) {
            this.renderSourcesDropdown(context, mouseX, mouseY);
        }
    }

    private void drawLoadingAnimation(class_332 context, int centerX, int centerY) {
        int radius = 12;
        int segments = 8;
        int animationDuration = 1600;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.loadingStartTime;
        float rotation = (float)(elapsedTime % (long)animationDuration) / (float)animationDuration;
        for (int i = 0; i < segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments + (double)(rotation * 2.0f) * Math.PI);
            int x1 = centerX + (int)(Math.sin(angle) * (double)(radius - 3));
            int y1 = centerY + (int)(Math.cos(angle) * (double)(radius - 3));
            int x2 = centerX + (int)(Math.sin(angle) * (double)radius);
            int y2 = centerY + (int)(Math.cos(angle) * (double)radius);
            int alpha = 255 - i * 255 / segments;
            int color = 0xFFFFFFFF | alpha << 24;
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    private void renderSchematicItem(class_332 context, SchematicInfo schematic, int x, int y, int width, int mouseX, int mouseY, int index) {
        int textY;
        int maxTextWidth = width - 110;
        int textX = x + 10;
        int originalY = textY = y + 2;
        List titleLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)schematic.getName()), maxTextWidth);
        for (int i = 0; i < Math.min(titleLines.size(), 2); ++i) {
            if (i == 1 && titleLines.size() > 2) {
                Object lastLine = this.getPlainText((class_5481)titleLines.get(i));
                if (((String)lastLine).length() > 3) {
                    lastLine = ((String)lastLine).substring(0, ((String)lastLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)lastLine).method_30937(), textX, textY, -1, true);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)titleLines.get(i), textX, textY, -1, true);
            }
            textY += 10;
        }
        String description = schematic.getDescription().isEmpty() ? "No description" : schematic.getDescription();
        List descLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)description), maxTextWidth);
        if (!descLines.isEmpty()) {
            if (descLines.size() > 1) {
                Object firstLine = this.getPlainText((class_5481)descLines.get(0));
                if (((String)firstLine).length() > 3) {
                    firstLine = ((String)firstLine).substring(0, ((String)firstLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)firstLine).method_30937(), textX, textY, -5592406, false);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)descLines.get(0), textX, textY, -5592406, false);
            }
            textY += 10;
        }
        String authorText = "By: " + schematic.getUsername();
        context.method_51433(class_310.method_1551().field_1772, authorText, textX, textY, -2763307, false);
        int rightX = x + width - 50;
        int statsY = originalY;
        String downloadCountStr = String.valueOf(schematic.getDownloadCount());
        if (schematic.getSource() != SchematicInfo.SourceServer.MINEMEV) {
            String viewCountStr = String.valueOf(schematic.getViewCount());
            int maxNumberWidth = Math.max(class_310.method_1551().field_1772.method_1727(viewCountStr), class_310.method_1551().field_1772.method_1727(downloadCountStr));
            context.method_51433(class_310.method_1551().field_1772, viewCountStr, rightX - maxNumberWidth, statsY, -1, false);
            context.method_51433(class_310.method_1551().field_1772, " \ud83d\udc41", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(viewCountStr), statsY, -1, false);
            context.method_51433(class_310.method_1551().field_1772, downloadCountStr, rightX - maxNumberWidth, statsY += 10, -1, false);
            context.method_51433(class_310.method_1551().field_1772, " \u2b07", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(downloadCountStr), statsY, -1, false);
        } else {
            int numberWidth = class_310.method_1551().field_1772.method_1727(downloadCountStr);
            context.method_51433(class_310.method_1551().field_1772, downloadCountStr, rightX - numberWidth, statsY, -1, false);
            context.method_51433(class_310.method_1551().field_1772, " \u2b07", rightX - numberWidth + numberWidth, statsY, -1, false);
        }
        int buttonX = x + width - 30;
        int buttonY = originalY - 2;
        boolean isButtonHovered = mouseX >= buttonX && mouseX <= buttonX + 20 && mouseY >= buttonY && mouseY <= buttonY + 20;
        int buttonColor = isButtonHovered ? -1711276033 : 0x66FFFFFF;
        context.method_25294(buttonX, buttonY, buttonX + 20, buttonY + 20, buttonColor);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2b07"), buttonX + 10, buttonY + 6, -1);
    }

    private void onSourcesChanged() {
        SettingsManager.setSourcesEnabled(this.chocEnabled, this.mineEnabled);
        this.recalcServerMode();
        cacheManager.clearAllCache();
        this.currentPage = 1;
        if (this.isSearchMode) {
            this.performSearch();
        } else {
            this.loadSchematics();
        }
    }

    private void renderSourcesDropdown(class_332 context, int mouseX, int mouseY) {
        boolean hoverMine;
        boolean hoverChoc;
        int x1 = this.sourcesDropdownX;
        int y1 = this.sourcesDropdownY;
        int x2 = this.sourcesDropdownX + this.sourcesDropdownWidth;
        int y2 = this.sourcesDropdownY + this.sourcesDropdownHeight;
        context.method_25294(x1 - 1, y1 - 1, x2 + 1, y2 + 1, -1442840576);
        context.method_25294(x1, y1, x2, y2, -300937200);
        int itemH = 20;
        int cy = y1 + 4;
        boolean bl = hoverChoc = mouseX >= x1 && mouseX <= x2 && mouseY >= cy && mouseY <= cy + itemH;
        if (hoverChoc) {
            context.method_25294(x1, cy, x2, cy + itemH, 0x22FFFFFF);
        }
        this.drawCheckboxRow(context, x1 + 6, cy + 5, this.chocEnabled, "Choculaterie");
        int my = cy + itemH;
        boolean bl2 = hoverMine = mouseX >= x1 && mouseX <= x2 && mouseY >= my && mouseY <= my + itemH;
        if (hoverMine) {
            context.method_25294(x1, my, x2, my + itemH, 0x22FFFFFF);
        }
        this.drawCheckboxRow(context, x1 + 6, my + 5, this.mineEnabled, "Minemev");
    }

    private void drawCheckboxRow(class_332 ctx, int x, int y, boolean checked, String label) {
        int box = 10;
        int color = -1;
        ctx.method_25294(x, y, x + box, y + box, 0x33FFFFFF);
        if (checked) {
            ctx.method_25294(x + 2, y + 2, x + box - 2, y + box - 2, color);
        }
        ctx.method_51433(this.field_22793, label, x + box + 6, y + 1, -1, false);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (this.showSourcesDropdown) {
            int x1 = this.sourcesDropdownX;
            int y1 = this.sourcesDropdownY;
            int x2 = this.sourcesDropdownX + this.sourcesDropdownWidth;
            int y2 = this.sourcesDropdownY + this.sourcesDropdownHeight;
            if (mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
                if (button == 0) {
                    int relY = (int)(mouseY - (double)y1);
                    if (relY >= 4 && relY < 24) {
                        boolean newChoc;
                        boolean bl = newChoc = !this.chocEnabled;
                        if (!newChoc && !this.mineEnabled) {
                            ToastManager.addToast("At least one site must be selected", true);
                        } else {
                            this.chocEnabled = newChoc;
                            this.onSourcesChanged();
                        }
                        return true;
                    }
                    if (relY >= 24 && relY < 44) {
                        boolean newMine;
                        boolean bl = newMine = !this.mineEnabled;
                        if (!newMine && !this.chocEnabled) {
                            ToastManager.addToast("At least one site must be selected", true);
                        } else {
                            this.mineEnabled = newMine;
                            this.onSourcesChanged();
                        }
                        return true;
                    }
                }
                return true;
            }
            this.showSourcesDropdown = false;
        }
        if (this.showFileDropdown && this.handleDropdownClick(mouseX, mouseY, button)) {
            return true;
        }
        if (this.searchField.method_25370() && (mouseX < (double)this.searchField.method_46426() || mouseX > (double)(this.searchField.method_46426() + this.searchField.method_25368()) || mouseY < (double)this.searchField.method_46427() || mouseY > (double)(this.searchField.method_46427() + this.searchField.method_25364()))) {
            this.searchField.method_25365(false);
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                this.scrollDragOffset = (int)(mouseY - (double)this.scrollBarY);
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                return true;
            }
        }
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && !this.schematics.isEmpty()) {
            int index = (int)((mouseY - (double)this.scrollAreaY + (double)this.scrollOffset) / 40.0);
            if (index >= 0 && index < this.schematics.size()) {
                boolean isDouble;
                SchematicInfo schematic = (SchematicInfo)this.schematics.get(index);
                int buttonX = this.scrollAreaX + this.scrollAreaWidth - 30;
                int buttonY = this.scrollAreaY - this.scrollOffset + index * 40;
                if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 20) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20)) {
                    if (schematic.getSource() == SchematicInfo.SourceServer.MINEMEV) {
                        this.openMinemevFileDropdown(schematic, buttonX, buttonY + 20);
                        this.lastClickedIndex = -1;
                        this.lastClickTime = 0L;
                        return true;
                    }
                    this.handleDownload(schematic, buttonX, buttonY);
                    this.lastClickedIndex = -1;
                    this.lastClickTime = 0L;
                    return true;
                }
                boolean bl = isDouble = button == 0 && doubled;
                if (!isDouble) {
                    long now = System.currentTimeMillis();
                    isDouble = button == 0 && index == this.lastClickedIndex && now - this.lastClickTime <= 300L;
                    this.lastClickedIndex = index;
                    this.lastClickTime = now;
                }
                if (isDouble) {
                    NavigationState.getInstance().saveState(this.currentPage, this.totalPages, this.totalItems, this.isSearchMode, this.searchTerm, this.lastSearchedTerm, this.scrollOffset);
                    if (schematic.getSource() == SchematicInfo.SourceServer.MINEMEV) {
                        class_310.method_1551().method_1507((class_437)new MinemevDetailScreen(schematic.getId()));
                    } else {
                        class_310.method_1551().method_1507((class_437)new DetailScreen(schematic.getId()));
                    }
                    return true;
                }
            }
        } else {
            this.lastClickedIndex = -1;
            this.lastClickTime = 0L;
        }
        return super.method_25402(click, doubled);
    }

    private void openMinemevFileDropdown(SchematicInfo schematic, int anchorX, int anchorY) {
        this.showFileDropdown = false;
        this.fileDropdownItems = new ArrayList<MinemevFileInfo>();
        this.fileDropdownPostId = schematic.getId();
        this.fileDropdownBaseName = schematic.getName().replaceAll("[^a-zA-Z0-9.-]", "_");
        this.fileDropdownX = Math.min(anchorX, this.field_22789 - this.fileDropdownWidth - 10);
        this.fileDropdownY = anchorY;
        this.fileDropdownScroll = 0;
        new Thread(() -> {
            try {
                List<MinemevFileInfo> files = MinemevHttpClient.fetchPostFiles(schematic.getId());
                class_310.method_1551().execute(() -> {
                    if (files == null || files.isEmpty()) {
                        ToastManager.addToast("No files available for this post", true);
                        this.showFileDropdown = false;
                        return;
                    }
                    if (files.size() == 1) {
                        MinemevFileInfo only = (MinemevFileInfo)files.get(0);
                        String chosenName = this.sanitizeFileNameForSave(only.getFileName());
                        String schematicsPath = SettingsManager.getSchematicsPath();
                        File potentialFile = new File(schematicsPath + File.separator + chosenName + ".litematic");
                        if (potentialFile.exists()) {
                            ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + chosenName + ".litematic\" already exists. Replace it?")), confirmed -> {
                                if (confirmed.booleanValue()) {
                                    this.performMinemevFileDownload(only, chosenName);
                                }
                                class_310.method_1551().method_1507((class_437)this);
                            });
                            class_310.method_1551().method_1507((class_437)confirmationScreen);
                        } else {
                            this.performMinemevFileDownload(only, chosenName);
                        }
                        this.showFileDropdown = false;
                        return;
                    }
                    this.fileDropdownItems = files;
                    this.fileDropdownContentHeight = this.fileDropdownItems.size() * 18;
                    int maxHeight = Math.min(200, this.field_22790 - this.fileDropdownY - 20);
                    this.fileDropdownHeight = Math.min(this.fileDropdownContentHeight, maxHeight);
                    boolean bl = this.showFileDropdown = !this.fileDropdownItems.isEmpty();
                    if (!this.showFileDropdown) {
                        ToastManager.addToast("No files available for this post", true);
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> {
                    ToastManager.addToast("Failed to load files: " + e.getMessage(), true);
                    this.showFileDropdown = false;
                });
            }
        }).start();
    }

    private boolean handleDropdownClick(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.fileDropdownX || mouseX > (double)(this.fileDropdownX + this.fileDropdownWidth) || mouseY < (double)this.fileDropdownY || mouseY > (double)(this.fileDropdownY + this.fileDropdownHeight)) {
            this.showFileDropdown = false;
            return false;
        }
        if (button != 0) {
            return true;
        }
        int relativeY = (int)(mouseY - (double)this.fileDropdownY + (double)this.fileDropdownScroll);
        int index = relativeY / 18;
        if (index >= 0 && index < this.fileDropdownItems.size()) {
            MinemevFileInfo file = this.fileDropdownItems.get(index);
            String chosenName = this.sanitizeFileNameForSave(file.getFileName());
            String schematicsPath = SettingsManager.getSchematicsPath();
            File potentialFile = new File(schematicsPath + File.separator + chosenName + ".litematic");
            if (potentialFile.exists()) {
                ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + chosenName + ".litematic\" already exists. Replace it?")), confirmed -> {
                    if (confirmed.booleanValue()) {
                        this.performMinemevFileDownload(file, chosenName);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                class_310.method_1551().method_1507((class_437)confirmationScreen);
            } else {
                this.performMinemevFileDownload(file, chosenName);
            }
            this.showFileDropdown = false;
            return true;
        }
        return true;
    }

    private void renderFileDropdown(class_332 context, int mouseX, int mouseY) {
        int x1 = this.fileDropdownX;
        int y1 = this.fileDropdownY;
        int x2 = this.fileDropdownX + this.fileDropdownWidth;
        int y2 = this.fileDropdownY + this.fileDropdownHeight;
        context.method_25294(x1 - 1, y1 - 1, x2 + 1, y2 + 1, -1442840576);
        context.method_25294(x1, y1, x2, y2, -300937200);
        context.method_44379(x1, y1, x2, y2);
        int startIndex = Math.max(0, this.fileDropdownScroll / 18);
        int endIndex = Math.min(this.fileDropdownItems.size(), startIndex + this.fileDropdownHeight / 18 + 1);
        int drawY = y1 - this.fileDropdownScroll % 18;
        for (int i = startIndex; i < endIndex; ++i) {
            boolean hovered;
            MinemevFileInfo f = this.fileDropdownItems.get(i);
            int itemTop = drawY + (i - startIndex) * 18;
            boolean bl = hovered = mouseX >= x1 && mouseX <= x2 && mouseY >= itemTop && mouseY <= itemTop + 18;
            if (hovered) {
                context.method_25294(x1, itemTop, x2, itemTop + 18, 0x33FFFFFF);
            }
            String name = f.getFileName() != null && !f.getFileName().isEmpty() ? f.getFileName() : "Unnamed";
            String sizeStr = f.getFileSize() > 0L ? " \u2022 " + this.formatSize(f.getFileSize()) : "";
            String ver = this.joinArrayShort(f.getVersions());
            String line = name + sizeStr + (String)(ver.isEmpty() ? "" : " \u2022 " + ver);
            context.method_51433(this.field_22793, line, x1 + 6, itemTop + 4, -1, false);
        }
        context.method_44380();
        if (this.fileDropdownContentHeight > this.fileDropdownHeight) {
            int scrollBarWidth = 6;
            int barHeight = Math.max(20, this.fileDropdownHeight * this.fileDropdownHeight / this.fileDropdownContentHeight);
            int barX = x2 - scrollBarWidth - 2;
            int barY = y1 + (int)((float)this.fileDropdownScroll / (float)(this.fileDropdownContentHeight - this.fileDropdownHeight) * (float)(this.fileDropdownHeight - barHeight));
            context.method_25294(barX, y1, barX + scrollBarWidth, y2, 0x33FFFFFF);
            boolean isHovering = mouseX >= barX && mouseX <= barX + scrollBarWidth && mouseY >= barY && mouseY <= barY + barHeight;
            int color = isHovering ? -1 : -1426063361;
            context.method_25294(barX, barY, barX + scrollBarWidth, barY + barHeight, color);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.showFileDropdown && mouseX >= (double)this.fileDropdownX && mouseX <= (double)(this.fileDropdownX + this.fileDropdownWidth) && mouseY >= (double)this.fileDropdownY && mouseY <= (double)(this.fileDropdownY + this.fileDropdownHeight) && this.fileDropdownContentHeight > this.fileDropdownHeight) {
            int delta = (int)(-verticalAmount * 20.0);
            this.fileDropdownScroll = Math.max(0, Math.min(this.fileDropdownContentHeight - this.fileDropdownHeight, this.fileDropdownScroll + delta));
            return true;
        }
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(-verticalAmount * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.isScrolling && this.totalContentHeight > this.scrollAreaHeight) {
            int mouseY = (int)click.comp_4799();
            int newBarTop = mouseY - this.scrollDragOffset;
            int minBarTop = this.scrollAreaY;
            int maxBarTop = this.scrollAreaY + this.scrollAreaHeight - this.scrollBarHeight;
            newBarTop = Math.max(minBarTop, Math.min(maxBarTop, newBarTop));
            float percent = (float)(newBarTop - this.scrollAreaY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
            this.scrollOffset = (int)(percent * (float)(this.totalContentHeight - this.scrollAreaHeight));
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        if (this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(click);
    }

    private void performMinemevFileDownload(MinemevFileInfo file, String chosenName) {
        try {
            String relativePath;
            String filenameForResolver = file.getFileName() != null && !file.getFileName().isEmpty() ? file.getFileName() : chosenName + ".litematic";
            String postId = this.fileDropdownPostId != null ? this.fileDropdownPostId : "";
            String resolvedUrl = MinemevHttpClient.getDownloadUrl(postId, filenameForResolver, file.getDownloadUrl());
            String filePath = LitematicHttpClient.downloadFileFromUrl(resolvedUrl, chosenName);
            String schematicsPath = SettingsManager.getSchematicsPath();
            if (filePath.startsWith(schematicsPath)) {
                String pathAfterBase = filePath.substring(schematicsPath.length());
                if (pathAfterBase.startsWith(File.separator)) {
                    pathAfterBase = pathAfterBase.substring(File.separator.length());
                }
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + pathAfterBase.replace(File.separator, "/");
            } else {
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + chosenName + ".litematic";
            }
            this.setStatusMessage("Schematic downloaded to: " + relativePath, true);
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download: " + e.getMessage(), false);
        }
    }

    private String sanitizeFileNameForSave(String name) {
        String n = name == null || name.isEmpty() ? this.fileDropdownBaseName : name;
        if ((n = n.replaceAll("[^a-zA-Z0-9.-]", "_")).toLowerCase().endsWith(".litematic")) {
            n = n.substring(0, n.length() - ".litematic".length());
        }
        return n;
    }

    private String joinArrayShort(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        ArrayList<String> items = new ArrayList<String>();
        for (String s : arr) {
            String t;
            if (s == null || (t = s.trim()).isEmpty()) continue;
            items.add(t);
        }
        return String.join((CharSequence)", ", items);
    }

    private String formatSize(long bytes) {
        int idx;
        if (bytes <= 0L) {
            return "";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB"};
        double b = bytes;
        for (idx = 0; b >= 1024.0 && idx < units.length - 1; b /= 1024.0, ++idx) {
        }
        return String.format(Locale.ROOT, "%.1f %s", b, units[idx]);
    }

    private void handleHoverPreloading(int mouseX, int mouseY) {
        if (mouseX >= this.scrollAreaX && mouseX <= this.scrollAreaX + this.scrollAreaWidth && mouseY >= this.scrollAreaY && mouseY <= this.scrollAreaY + this.scrollAreaHeight && !this.schematics.isEmpty()) {
            int itemIndex = (mouseY - this.scrollAreaY + this.scrollOffset) / 40;
            if (itemIndex >= 0 && itemIndex < this.schematics.size()) {
                SchematicInfo hoveredSchematic = (SchematicInfo)this.schematics.get(itemIndex);
                if (itemIndex != this.hoveredItemIndex) {
                    this.hoveredItemIndex = itemIndex;
                    this.hoverStartTime = System.currentTimeMillis();
                    if (this.isPreloadingHoveredItem && !hoveredSchematic.getId().equals(this.currentlyPreloadingId)) {
                        System.out.println("Cancelled preload for " + this.currentlyPreloadingId + " - now hovering " + hoveredSchematic.getId());
                        this.currentlyPreloadingId = null;
                        this.isPreloadingHoveredItem = false;
                    }
                } else if (System.currentTimeMillis() - this.hoverStartTime >= 200L && !this.isPreloadingHoveredItem) {
                    if (hoveredSchematic.getSource() == SchematicInfo.SourceServer.CHOCULATERIE) {
                        if (!cacheManager.hasValidDetailCache(hoveredSchematic.getId(), 300000L)) {
                            this.startHoverPreload(hoveredSchematic);
                        }
                    } else if (!cacheManager.hasValidMinemevDetailCache(hoveredSchematic.getId(), 300000L)) {
                        this.startHoverPreloadMinemev(hoveredSchematic);
                    }
                }
            } else {
                this.resetHoverState();
            }
        } else {
            this.resetHoverState();
        }
    }

    private void startHoverPreloadMinemev(SchematicInfo schematic) {
        if (this.isPreloadingHoveredItem || schematic == null) {
            return;
        }
        if (schematic.getSource() != SchematicInfo.SourceServer.MINEMEV) {
            return;
        }
        String uuid = schematic.getId();
        if (cacheManager.hasValidMinemevDetailCache(uuid, 300000L)) {
            return;
        }
        this.isPreloadingHoveredItem = true;
        this.currentlyPreloadingId = uuid;
        System.out.println("Starting hover preload for Minemev post: " + schematic.getName() + " (UUID: " + uuid + ")");
        new Thread(() -> {
            try {
                if (!this.isPreloadingHoveredItem || !uuid.equals(this.currentlyPreloadingId)) {
                    System.out.println("Preload cancelled during fetch for Minemev " + uuid);
                    return;
                }
                MinemevPostDetailInfo detail = MinemevHttpClient.fetchPostDetails(uuid);
                class_310.method_1551().execute(() -> {
                    if (this.isPreloadingHoveredItem && uuid.equals(this.currentlyPreloadingId)) {
                        cacheManager.putMinemevDetailCache(uuid, detail, 300000L);
                        System.out.println("Successfully preloaded Minemev details for: " + detail.getTitle());
                    }
                    if (uuid.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during Minemev hover preload for " + uuid + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    if (uuid.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
        }).start();
    }

    private void startHoverPreload(SchematicInfo schematic) {
        if (this.isPreloadingHoveredItem || schematic == null) {
            return;
        }
        if (schematic.getSource() != SchematicInfo.SourceServer.CHOCULATERIE) {
            return;
        }
        String schematicId = schematic.getId();
        if (cacheManager.hasValidDetailCache(schematicId, 300000L)) {
            return;
        }
        this.isPreloadingHoveredItem = true;
        this.currentlyPreloadingId = schematicId;
        System.out.println("Starting hover preload for schematic: " + schematic.getName() + " (ID: " + schematicId + ")");
        new Thread(() -> {
            try {
                if (!this.isPreloadingHoveredItem || !schematicId.equals(this.currentlyPreloadingId)) {
                    System.out.println("Preload cancelled during fetch for " + schematicId);
                    return;
                }
                SchematicDetailInfo detailInfo = LitematicHttpClient.fetchSchematicDetail(schematicId);
                class_310.method_1551().execute(() -> {
                    if (this.isPreloadingHoveredItem && schematicId.equals(this.currentlyPreloadingId)) {
                        cacheManager.putDetailCache(schematicId, detailInfo, 300000L);
                        System.out.println("Successfully preloaded and cached details for: " + detailInfo.getName());
                    }
                    if (schematicId.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during hover preload for " + schematicId + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    if (schematicId.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
        }).start();
    }

    private void resetHoverState() {
        if (this.hoveredItemIndex != -1) {
            this.hoveredItemIndex = -1;
            this.hoverStartTime = 0L;
        }
    }

    private void handlePaginationHoverPreloading(int mouseX, int mouseY) {
        if (this.isSearchMode) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int paginationY = this.field_22790 - 30;
        int buttonWidth = 20;
        int buttonHeight = 20;
        boolean isHoveringAnyButton = false;
        int targetPage = -1;
        if (mouseX >= centerX - 100 && mouseX <= centerX - 100 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage > 1) {
                targetPage = this.currentPage - 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX + 80 && mouseX <= centerX + 80 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage < this.totalPages) {
                targetPage = this.currentPage + 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX - 125 && mouseX <= centerX - 125 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage > 1) {
                targetPage = 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX + 105 && mouseX <= centerX + 105 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight && this.currentPage < this.totalPages) {
            targetPage = this.totalPages;
            isHoveringAnyButton = true;
        }
        if (isHoveringAnyButton && targetPage != -1 && (!this.isPreloadingPagination || this.preloadingPageNumber != targetPage)) {
            boolean needsMinemevPreload;
            if (this.isPreloadingPagination) {
                System.out.println("Switching pagination preload from page " + this.preloadingPageNumber + " to " + targetPage);
            }
            boolean needsChoculateriePreload = this.chocEnabled && !cacheManager.hasValidSchematicCache(targetPage, 900000L);
            boolean bl = needsMinemevPreload = this.mineEnabled && !cacheManager.hasValidMinemevCache(targetPage, 900000L);
            if (needsChoculateriePreload || needsMinemevPreload) {
                this.startPaginationPreload(targetPage);
            }
        }
    }

    private void startPaginationPreload(int pageNumber) {
        if (pageNumber == this.currentPage) {
            return;
        }
        this.isPreloadingPagination = true;
        this.preloadingPageNumber = pageNumber;
        System.out.println("Starting instant pagination preload for page: " + pageNumber);
        new Thread(() -> {
            try {
                boolean needsMinemevPreload;
                if (!this.isPreloadingPagination || this.preloadingPageNumber != pageNumber) {
                    System.out.println("Pagination preload cancelled for page " + pageNumber);
                    return;
                }
                boolean needsChoculateriePreload = this.chocEnabled && !cacheManager.hasValidSchematicCache(pageNumber, 900000L);
                boolean bl = needsMinemevPreload = this.mineEnabled && !cacheManager.hasValidMinemevCache(pageNumber, 900000L);
                if (needsChoculateriePreload) {
                    if (!this.isPreloadingPagination || this.preloadingPageNumber != pageNumber) {
                        System.out.println("Choculaterie pagination preload cancelled for page " + pageNumber);
                        return;
                    }
                    System.out.println("Preloading Choculaterie data for page " + pageNumber);
                    LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(pageNumber, 15, this.showUnverified);
                    class_310.method_1551().execute(() -> {
                        if (this.isPreloadingPagination && this.preloadingPageNumber == pageNumber) {
                            cacheManager.putSchematicCache(result);
                            System.out.println("Successfully preloaded and cached Choculaterie page: " + pageNumber + " (" + result.getItems().size() + " items)");
                        } else {
                            System.out.println("Discarded Choculaterie pagination preload result for page " + pageNumber + " - cancelled");
                        }
                    });
                } else if (this.chocEnabled) {
                    System.out.println("Choculaterie page " + pageNumber + " already cached - skipping preload");
                }
                if (needsMinemevPreload) {
                    if (!this.isPreloadingPagination || this.preloadingPageNumber != pageNumber) {
                        System.out.println("Minemev pagination preload cancelled for page " + pageNumber);
                        return;
                    }
                    System.out.println("Preloading Minemev data for page " + pageNumber);
                    MinemevHttpClient.MinemevSearchResult mres = MinemevHttpClient.searchPosts(null, null, null, "newest", pageNumber);
                    class_310.method_1551().execute(() -> {
                        if (this.isPreloadingPagination && this.preloadingPageNumber == pageNumber) {
                            cacheManager.putMinemevCache(mres);
                            System.out.println("Successfully preloaded and cached Minemev page: " + pageNumber + " (" + mres.getPosts().size() + " items)");
                        } else {
                            System.out.println("Discarded Minemev pagination preload result for page " + pageNumber + " - cancelled");
                        }
                    });
                } else if (this.mineEnabled) {
                    System.out.println("Minemev page " + pageNumber + " already cached - skipping preload");
                }
                class_310.method_1551().execute(() -> {
                    if (this.preloadingPageNumber == pageNumber) {
                        this.isPreloadingPagination = false;
                        this.preloadingPageNumber = -1;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during pagination preload for page " + pageNumber + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    if (this.preloadingPageNumber == pageNumber) {
                        this.isPreloadingPagination = false;
                        this.preloadingPageNumber = -1;
                    }
                });
            }
        }).start();
    }

    private void handleDownload(SchematicInfo schematic, int anchorX, int anchorY) {
        try {
            String fileName = schematic.getName().replaceAll("[^a-zA-Z0-9.-]", "_");
            String savePath = SettingsManager.getSchematicsPath() + File.separator;
            File potentialFile = new File(savePath + fileName + ".litematic");
            if (potentialFile.exists()) {
                ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + fileName + ".litematic\" already exists. Do you want to replace it?")), confirmed -> {
                    if (confirmed.booleanValue()) {
                        this.downloadSchematic(schematic, fileName);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                class_310.method_1551().method_1507((class_437)confirmationScreen);
            } else {
                this.downloadSchematic(schematic, fileName);
            }
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    private void downloadSchematic(SchematicInfo schematic, String fileName) {
        try {
            String relativePath;
            String filePath;
            if (schematic.getSource() == SchematicInfo.SourceServer.MINEMEV) {
                String resolvedUrl;
                List<MinemevFileInfo> files = MinemevHttpClient.fetchPostFiles(schematic.getId());
                String chosenUrl = null;
                String chosenName = fileName;
                String resolverFileName = null;
                for (MinemevFileInfo f : files) {
                    String lower = f.getFileName() != null ? f.getFileName().toLowerCase() : "";
                    boolean isLite = "litematic".equalsIgnoreCase(f.getFileType()) || lower.endsWith(".litematic");
                    if (!isLite) continue;
                    chosenUrl = f.getDownloadUrl();
                    String string = resolverFileName = f.getFileName() != null && !f.getFileName().isEmpty() ? f.getFileName() : chosenName + ".litematic";
                    if (f.getFileName() == null || f.getFileName().isEmpty() || !(chosenName = f.getFileName().replaceAll("[^a-zA-Z0-9.-]", "_")).toLowerCase().endsWith(".litematic")) break;
                    chosenName = chosenName.substring(0, chosenName.length() - ".litematic".length());
                    break;
                }
                if (chosenUrl == null && !files.isEmpty()) {
                    MinemevFileInfo f = files.get(0);
                    chosenUrl = f.getDownloadUrl();
                    resolverFileName = f.getFileName() != null && !f.getFileName().isEmpty() ? f.getFileName() : chosenName + ".litematic";
                }
                if ((resolvedUrl = MinemevHttpClient.getDownloadUrl(schematic.getId(), resolverFileName != null ? resolverFileName : chosenName + ".litematic", chosenUrl)) == null || resolvedUrl.isEmpty()) {
                    throw new RuntimeException("No downloadable file found for this Minemev post");
                }
                filePath = LitematicHttpClient.downloadFileFromUrl(resolvedUrl, chosenName);
            } else {
                filePath = LitematicHttpClient.fetchAndDownloadSchematic(schematic.getId(), fileName);
            }
            String schematicsPath = SettingsManager.getSchematicsPath();
            if (filePath.startsWith(schematicsPath)) {
                String pathAfterBase = filePath.substring(schematicsPath.length());
                if (pathAfterBase.startsWith(File.separator)) {
                    pathAfterBase = pathAfterBase.substring(File.separator.length());
                }
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + pathAfterBase.replace(File.separator, "/");
            } else {
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + fileName + ".litematic";
            }
            this.setStatusMessage("Schematic downloaded to: " + relativePath, true);
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    private void setStatusMessage(String message, boolean isSuccess) {
        this.statusMessage = message;
        this.statusColor = isSuccess ? -11141291 : -43691;
        this.statusMessageDisplayTime = System.currentTimeMillis();
        ToastManager.addToast(message, !isSuccess);
    }

    private boolean hasActiveStatusMessage() {
        return this.statusMessage != null && System.currentTimeMillis() - this.statusMessageDisplayTime < 3000L;
    }

    private String getPlainText(class_5481 text) {
        StringBuilder sb = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            sb.appendCodePoint(codePoint);
            return true;
        });
        return sb.toString();
    }

    @Environment(value=EnvType.CLIENT)
    private static enum ServerMode {
        CHOCULATERIE,
        MINEMEV,
        BOTH;

    }
}

