/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.CacheManager;
import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.LitematicDownloaderScreen;
import com.choculaterie.gui.NavigationState;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.networking.LitematicHttpClient;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class DetailScreen
extends class_437 {
    private final String schematicId;
    private SchematicDetailInfo schematicDetail;
    private boolean isLoading = true;
    private String errorMessage = null;
    private class_2960 coverImageTexture = null;
    private int imageWidth = 0;
    private int imageHeight = 0;
    private boolean isImageLoading = false;
    private int descriptionScrollPos = 0;
    private class_4185 backButton;
    private class_4185 downloadButton;
    private class_437 confirmationScreen = null;
    private long loadingStartTime = 0L;
    private static CacheManager cacheManager = LitematicDownloaderScreen.getCacheManager();
    private static final long DETAIL_CACHE_DURATION_MS = 300000L;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;

    public DetailScreen(String schematicId) {
        super((class_2561)class_2561.method_43470((String)""));
        this.schematicId = schematicId;
    }

    protected void method_25426() {
        super.method_25426();
        this.backButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> {
            NavigationState navState = NavigationState.getInstance();
            if (navState.getSavedCurrentPage() > 0) {
                LitematicDownloaderScreen restoredScreen = new LitematicDownloaderScreen(true);
                class_310.method_1551().method_1507((class_437)restoredScreen);
            } else {
                class_310.method_1551().method_1507((class_437)new LitematicDownloaderScreen());
            }
        }).method_46434(10, 10, 20, 20).method_46431();
        this.method_37063((class_364)this.backButton);
        int padding = 20;
        int topMargin = 40;
        int leftSectionWidth = 256;
        this.downloadButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2b07"), button -> {
            if (this.schematicDetail != null) {
                try {
                    String fileName = this.schematicDetail.getName().replaceAll("[^a-zA-Z0-9.-]", "_");
                    String savePath = SettingsManager.getSchematicsPath() + File.separator;
                    File potentialFile = new File(savePath + fileName + ".litematic");
                    if (potentialFile.exists()) {
                        this.confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + fileName + ".litematic\" already exists. Do you want to replace it?")), confirmed -> {
                            if (confirmed.booleanValue()) {
                                this.downloadSchematic(fileName);
                            }
                            this.confirmationScreen = null;
                        });
                        class_310.method_1551().method_1507(this.confirmationScreen);
                    } else {
                        this.downloadSchematic(fileName);
                    }
                }
                catch (Exception e) {
                    this.setDownloadStatus("Failed to download schematic: " + e.getMessage(), false);
                }
            }
        }).method_46434(this.field_22789 - 30, 10, 20, 20).method_46431();
        this.downloadButton.field_22763 = false;
        this.method_37063((class_364)this.downloadButton);
        System.out.println("Loading schematic details for ID: " + this.schematicId);
        this.errorMessage = null;
        this.loadSchematicDetails();
    }

    private void loadSchematicDetails() {
        if (cacheManager.hasValidDetailCache(this.schematicId, 300000L)) {
            CacheManager.DetailCacheEntry cachedDetail = cacheManager.getDetailCache(this.schematicId);
            this.schematicDetail = cachedDetail.getDetail();
            this.isLoading = false;
            this.downloadButton.field_22763 = true;
            if (this.schematicDetail != null && this.schematicDetail.getCoverPicture() != null && !this.schematicDetail.getCoverPicture().isEmpty()) {
                System.out.println("Cover image available (from cache), loading...");
                this.loadCoverImage(this.schematicDetail.getCoverPicture());
            }
            System.out.println("Loaded schematic details from cache for ID: " + this.schematicId);
            return;
        }
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        new Thread(() -> {
            try {
                SchematicDetailInfo fetchedDetail = LitematicHttpClient.fetchSchematicDetail(this.schematicId);
                System.out.println("Fetched schematic details from server: " + (fetchedDetail != null));
                class_310.method_1551().execute(() -> {
                    this.schematicDetail = fetchedDetail;
                    this.isLoading = false;
                    if (this.schematicDetail != null) {
                        cacheManager.putDetailCache(this.schematicId, this.schematicDetail, 300000L);
                    }
                    this.downloadButton.field_22763 = true;
                    if (this.schematicDetail != null && this.schematicDetail.getCoverPicture() != null && !this.schematicDetail.getCoverPicture().isEmpty()) {
                        System.out.println("Cover image available, loading...");
                        this.loadCoverImage(this.schematicDetail.getCoverPicture());
                    } else {
                        System.out.println("No cover image available");
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> {
                    this.errorMessage = "Failed to load schematic details: " + e.getMessage();
                    this.isLoading = false;
                    System.err.println("Error loading schematic details: " + e.getMessage());
                    e.printStackTrace();
                });
            }
        }).start();
    }

    private void drawLoadingAnimation(class_332 context, int centerX, int centerY) {
        int radius = 12;
        int segments = 8;
        int animationDuration = 1600;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.loadingStartTime;
        float rotation = (float)(elapsedTime % (long)animationDuration) / (float)animationDuration;
        for (int i = 0; i < segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments);
            angle = (float)((double)angle + (double)(rotation * 2.0f) * Math.PI);
            int x1 = centerX + (int)(Math.sin(angle) * (double)(radius - 3));
            int y1 = centerY + (int)(Math.cos(angle) * (double)(radius - 3));
            int x2 = centerX + (int)(Math.sin(angle) * (double)radius);
            int y2 = centerY + (int)(Math.cos(angle) * (double)radius);
            int alpha = 255 - i * 255 / segments;
            int color = 0xFFFFFF | alpha << 24;
            context.method_25294(x1, y1, x2 + 1, y2 + 1, color);
        }
    }

    private void downloadSchematic(String fileName) {
        try {
            String relativePath;
            String filePath = LitematicHttpClient.fetchAndDownloadSchematic(this.schematicDetail.getId(), fileName);
            String schematicsPath = SettingsManager.getSchematicsPath();
            if (filePath.startsWith(schematicsPath)) {
                String pathAfterBase = filePath.substring(schematicsPath.length());
                if (pathAfterBase.startsWith(File.separator)) {
                    pathAfterBase = pathAfterBase.substring(File.separator.length());
                }
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + pathAfterBase.replace(File.separator, "/");
            } else {
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + fileName + ".litematic";
            }
            this.setDownloadStatus("Schematic downloaded to: " + relativePath, true);
        }
        catch (Exception e) {
            this.setDownloadStatus("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    private void loadCoverImage(String imageUrl) {
        if (imageUrl == null || imageUrl.trim().isEmpty()) {
            System.out.println("No cover image URL provided");
            this.coverImageTexture = null;
            return;
        }
        long IMAGE_CACHE_DURATION_MS = 300000L;
        try {
            CacheManager.ImageCacheEntry cached;
            if (cacheManager != null && cacheManager.hasValidImageCache(imageUrl, 300000L) && (cached = cacheManager.getImageCache(imageUrl)) != null && cached.getTextureId() != null) {
                this.coverImageTexture = cached.getTextureId();
                this.isImageLoading = false;
                System.out.println("Using cached image texture for URL: " + imageUrl);
                return;
            }
        }
        catch (Exception e) {
            System.err.println("Image cache check failed: " + e.getMessage());
        }
        System.out.println("Loading cover image from URL: " + imageUrl);
        this.isImageLoading = true;
        new Thread(() -> {
            try {
                String encodedUrl = this.encodeImageUrl(imageUrl);
                System.out.println("Encoded URL: " + encodedUrl);
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(encodedUrl)).GET().build();
                HttpResponse<byte[]> response = LitematicHttpClient.getClient().send(request, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() != 200) {
                    System.err.println("Failed to load image from URL: " + response.statusCode());
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Failed to load image: HTTP " + response.statusCode(), true);
                        this.createAndRegisterPlaceholder("HTTP " + response.statusCode());
                    });
                    return;
                }
                byte[] imageData = response.body();
                if (imageData.length == 0) {
                    System.err.println("Downloaded image data is empty");
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Image data is empty", true);
                        this.createAndRegisterPlaceholder("Image data is empty");
                    });
                    return;
                }
                if (imageData.length < 100) {
                    System.err.println("Image data too small, likely corrupted: " + imageData.length + " bytes");
                    class_310.method_1551().execute(() -> {
                        ToastManager.addToast("Image file too small (corrupted)", true);
                        this.createAndRegisterPlaceholder("Image data too small (corrupted)");
                    });
                    return;
                }
                String detectedFormat = this.detectImageFormat(imageData);
                System.out.println("Detected image format: " + detectedFormat);
                class_310.method_1551().execute(() -> {
                    block10: {
                        try {
                            class_1011 nativeImage;
                            String uniqueId = UUID.randomUUID().toString().replace("-", "");
                            this.coverImageTexture = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
                            try {
                                byte[] processed = this.convertImageToPng(imageData, detectedFormat);
                                nativeImage = class_1011.method_4309((InputStream)new ByteArrayInputStream(processed));
                                if (nativeImage.method_4307() <= 0 || nativeImage.method_4323() <= 0) {
                                    ToastManager.addToast("Image has invalid dimensions", true);
                                    nativeImage.close();
                                    nativeImage = this.createPlaceholderImage(256, 256, "Invalid dims");
                                } else if (nativeImage.method_4307() > 4096 || nativeImage.method_4323() > 4096) {
                                    ToastManager.addToast("Image too large", true);
                                    nativeImage.close();
                                    nativeImage = this.createPlaceholderImage(256, 256, "Too large");
                                }
                            }
                            catch (Exception e) {
                                ToastManager.addToast("Could not load " + detectedFormat + " image", true);
                                nativeImage = this.createPlaceholderImage(256, 256, "Unsupported");
                            }
                            if (nativeImage == null) break block10;
                            this.imageWidth = nativeImage.method_4307();
                            this.imageHeight = nativeImage.method_4323();
                            class_310.method_1551().method_1531().method_4616(this.coverImageTexture, (class_1044)new class_1043(() -> "cover_image", nativeImage));
                            try {
                                if (cacheManager != null) {
                                    cacheManager.putImageCache(imageUrl, this.coverImageTexture);
                                }
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception e) {
                            ToastManager.addToast("Failed to process image", true);
                            this.coverImageTexture = null;
                        }
                    }
                });
            }
            catch (Exception e) {
                class_310.method_1551().execute(() -> {
                    ToastManager.addToast("Failed to load image", true);
                    this.createAndRegisterPlaceholder("Download failed");
                });
            }
            finally {
                this.isImageLoading = false;
            }
        }).start();
    }

    private String detectImageFormat(byte[] imageData) {
        String startString;
        if (imageData.length < 12) {
            return "unknown";
        }
        if (imageData[0] == -119 && imageData[1] == 80 && imageData[2] == 78 && imageData[3] == 71) {
            return "png";
        }
        if (imageData[0] == -1 && imageData[1] == -40 && imageData[2] == -1) {
            return "jpeg";
        }
        if (imageData.length >= 6 && imageData[0] == 71 && imageData[1] == 73 && imageData[2] == 70) {
            return "gif";
        }
        if (imageData[0] == 66 && imageData[1] == 77) {
            return "bmp";
        }
        if (imageData.length >= 12 && imageData[0] == 82 && imageData[1] == 73 && imageData[2] == 70 && imageData[3] == 70 && imageData[8] == 87 && imageData[9] == 69 && imageData[10] == 66 && imageData[11] == 80) {
            return "webp";
        }
        if (imageData.length >= 4 && (imageData[0] == 73 && imageData[1] == 73 && imageData[2] == 42 && imageData[3] == 0 || imageData[0] == 77 && imageData[1] == 77 && imageData[2] == 0 && imageData[3] == 42)) {
            return "tiff";
        }
        if (imageData.length >= 4 && imageData[0] == 0 && imageData[1] == 0 && imageData[2] == 1 && imageData[3] == 0) {
            return "ico";
        }
        if (imageData.length >= 12 && imageData[4] == 102 && imageData[5] == 116 && imageData[6] == 121 && imageData[7] == 112 && imageData[8] == 97 && imageData[9] == 118 && imageData[10] == 105 && (imageData[11] == 102 || imageData[11] == 115)) {
            return "avif";
        }
        if (imageData.length >= 12 && imageData[4] == 102 && imageData[5] == 116 && imageData[6] == 121 && imageData[7] == 112 && (imageData[8] == 104 && imageData[9] == 101 && imageData[10] == 105 && imageData[11] == 99 || imageData[8] == 109 && imageData[9] == 105 && imageData[10] == 102 && imageData[11] == 49)) {
            return "heif";
        }
        if (imageData.length >= 5 && ((startString = new String(imageData, 0, Math.min(100, imageData.length)).toLowerCase()).contains("<svg") || startString.startsWith("<?xml") && startString.contains("svg"))) {
            return "svg";
        }
        return "unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] convertImageToPng(byte[] imageData, String format) throws Exception {
        if (format.equals("png") || format.equals("unknown")) {
            return imageData;
        }
        if (format.equals("svg")) {
            throw new Exception("SVG format is not supported for conversion");
        }
        if (format.equals("avif") || format.equals("heif")) {
            throw new Exception(format.toUpperCase() + " format is not supported by Java ImageIO");
        }
        try {
            BufferedImage convertedImage;
            BufferedImage bufferedImage;
            block28: {
                bufferedImage = null;
                try (ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));){
                    Iterator<ImageReader> autoReaders = ImageIO.getImageReaders(iis);
                    if (!autoReaders.hasNext()) break block28;
                    ImageReader reader = autoReaders.next();
                    try {
                        reader.setInput(iis, true, true);
                        bufferedImage = reader.read(0);
                    }
                    finally {
                        reader.dispose();
                    }
                }
                catch (Exception e) {
                    System.out.println("Auto-detect ImageIO read failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                try {
                    bufferedImage = ImageIO.read(new ByteArrayInputStream(imageData));
                }
                catch (Exception e) {
                    System.out.println("Standard ImageIO.read failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null && !format.equals("unknown")) {
                try {
                    Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(format.toUpperCase());
                    if (readers.hasNext()) {
                        ImageReader reader = readers.next();
                        ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(imageData));
                        reader.setInput(iis);
                        bufferedImage = reader.read(0);
                        reader.dispose();
                        iis.close();
                    }
                }
                catch (Exception e) {
                    System.out.println("Alternative ImageIO approach failed for " + format + ": " + e.getMessage());
                }
            }
            if (bufferedImage == null) {
                throw new Exception("Could not decode " + format + " image with any available reader");
            }
            if (bufferedImage.getType() != 1 && bufferedImage.getType() != 2) {
                convertedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                Graphics2D g2d = convertedImage.createGraphics();
                g2d.drawImage((Image)bufferedImage, 0, 0, null);
                g2d.dispose();
            } else {
                convertedImage = bufferedImage;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean success = ImageIO.write((RenderedImage)convertedImage, "PNG", baos);
            if (!success) {
                throw new Exception("Failed to write PNG output");
            }
            System.out.println("Successfully converted " + format + " to PNG format (" + bufferedImage.getWidth() + "x" + bufferedImage.getHeight() + ")");
            return baos.toByteArray();
        }
        catch (Exception e) {
            System.err.println("Failed to convert " + format + " image: " + e.getMessage());
            if (format.equals("svg") || format.equals("avif") || format.equals("heif")) {
                throw e;
            }
            return imageData;
        }
    }

    private String getSimpleErrorMessage(String fullError) {
        if (fullError.contains("Bad PNG Signature")) {
            return "Corrupted PNG file";
        }
        if (fullError.contains("JPEG")) {
            return "JPEG format issue";
        }
        if (fullError.contains("format")) {
            return "Unsupported format";
        }
        if (fullError.contains("signature") || fullError.contains("Signature")) {
            return "Corrupted file";
        }
        return fullError.length() > 30 ? "Image corrupted" : fullError;
    }

    private void createAndRegisterPlaceholder(String reason) {
        try {
            String uniqueId = UUID.randomUUID().toString().replace("-", "");
            this.coverImageTexture = class_2960.method_60655((String)"minecraft", (String)("textures/dynamic/" + uniqueId));
            class_1011 nativeImage = this.createPlaceholderImage(256, 256, reason);
            if (nativeImage != null) {
                this.imageWidth = nativeImage.method_4307();
                this.imageHeight = nativeImage.method_4323();
                class_310.method_1551().method_1531().method_4616(this.coverImageTexture, (class_1044)new class_1043(() -> "cover_image", nativeImage));
                System.out.println("Placeholder image created due to: " + reason + " (" + this.imageWidth + "x" + this.imageHeight + ")");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to create placeholder: " + e.getMessage());
            this.coverImageTexture = null;
        }
    }

    private class_1011 createPlaceholderImage(int width, int height, String reason) {
        try {
            class_1011 placeholder = new class_1011(class_1011.class_1012.field_4997, width, height, false);
            return placeholder;
        }
        catch (Exception e) {
            System.err.println("Failed to create placeholder image: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void setDownloadStatus(String message, boolean isSuccess) {
        ToastManager.addToast(message, !isSuccess);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 10, 0xFFFFFF);
        for (class_364 child : this.method_25396()) {
            class_4185 button;
            if (child instanceof class_4185 && ((button = (class_4185)child) == this.backButton || button == this.downloadButton) || !(child instanceof class_4068)) continue;
            class_4068 drawable = (class_4068)child;
            drawable.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.isLoading) {
            int centerY = this.field_22790 / 2;
            this.drawLoadingAnimation(context, this.field_22789 / 2, centerY - 15);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), this.field_22789 / 2, centerY + 15, -1);
        } else if (this.errorMessage != null) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage), this.field_22789 / 2, this.field_22790 / 2, -1);
        } else if (this.schematicDetail != null) {
            int descBoxHeight;
            int descBoxWidth;
            String publishDate;
            String username;
            int padding = 20;
            int leftSectionWidth = 256;
            int rightSectionX = leftSectionWidth + padding * 2;
            int contentWidth = this.field_22789 - rightSectionX - padding;
            int topMargin = 40;
            if (this.coverImageTexture != null) {
                context.method_25290(class_10799.field_56883, this.coverImageTexture, padding, topMargin, 0.0f, 0.0f, leftSectionWidth, leftSectionWidth, leftSectionWidth, leftSectionWidth);
            } else if (this.isImageLoading) {
                int centerX = padding + leftSectionWidth / 2;
                int centerY = topMargin + leftSectionWidth / 2;
                this.drawLoadingAnimation(context, centerX, centerY);
            } else {
                context.method_25294(padding, topMargin, padding + leftSectionWidth, topMargin + leftSectionWidth, 0x33FFFFFF);
                String noImageText = "No Image";
                int textWidth = this.field_22793.method_1727(noImageText);
                int textX = padding + (leftSectionWidth - textWidth) / 2;
                int textY = topMargin + leftSectionWidth / 2 - 4;
                context.method_51433(this.field_22793, noImageText, textX, textY, -5592406, false);
            }
            int y = topMargin;
            String name = this.schematicDetail.getName();
            if (name != null) {
                context.method_51433(this.field_22793, name, rightSectionX, y, -1, true);
                y += 15;
            }
            if ((username = this.schematicDetail.getUsername()) != null) {
                context.method_51433(this.field_22793, "By: " + username, rightSectionX, y, -2763307, false);
                y += 15;
            }
            if ((publishDate = this.schematicDetail.getPublishDate()) != null) {
                String formattedDate = publishDate.split("T")[0];
                context.method_51433(this.field_22793, "Published: " + formattedDate, rightSectionX, y, -2763307, false);
                y += 20;
            }
            int statsY = y;
            int statsSpacing = contentWidth / 3;
            context.method_51433(this.field_22793, "Views: " + this.schematicDetail.getViewCount(), rightSectionX, statsY, -2763307, false);
            context.method_51433(this.field_22793, "Downloads: " + this.schematicDetail.getDownloadCount(), rightSectionX + statsSpacing, statsY, -2763307, false);
            context.method_51433(this.field_22793, "Description:", rightSectionX, y += 25, -1, true);
            this.scrollAreaX = rightSectionX;
            this.scrollAreaY = y += 15;
            this.scrollAreaWidth = descBoxWidth = contentWidth;
            this.scrollAreaHeight = descBoxHeight = this.field_22790 - y - padding;
            String description = this.schematicDetail.getDescription() != null && !this.schematicDetail.getDescription().isEmpty() ? this.schematicDetail.getDescription() : "No description available";
            description = description.replace("\r", "");
            description = description.replaceAll("[ \\t]+", " ").trim();
            context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
            int textY = this.scrollAreaY - this.descriptionScrollPos;
            int reservedRightPx = 10;
            int wrapWidth = Math.max(10, this.scrollAreaWidth - reservedRightPx);
            List lines = this.field_22793.method_1728((class_5348)class_2561.method_43470((String)description), wrapWidth);
            this.totalContentHeight = lines.size() * 10;
            for (class_5481 line : lines) {
                context.method_51430(this.field_22793, line, this.scrollAreaX, textY, -1, false);
                textY += 10;
            }
            context.method_44380();
            if (this.totalContentHeight > this.scrollAreaHeight) {
                int scrollBarWidth = 6;
                this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
                this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth - scrollBarWidth - 2;
                this.scrollBarY = this.scrollAreaY + (int)((float)this.descriptionScrollPos / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
                context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
                boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
                int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
                context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
            }
        }
        if (this.backButton != null) {
            this.backButton.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.downloadButton != null) {
            this.downloadButton.method_25394(context, mouseX, mouseY, delta);
        }
        ToastManager.render(context, this.field_22789);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                int denom = Math.max(1, this.scrollAreaHeight);
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)denom;
                this.descriptionScrollPos = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.descriptionScrollPos = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.descriptionScrollPos));
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseY = click.comp_4799();
        if (this.isScrolling) {
            int currentMouseY = (int)mouseY;
            if (currentMouseY != this.lastMouseY) {
                int denom = Math.max(1, this.scrollAreaHeight - this.scrollBarHeight);
                float dragPercentage = (float)(currentMouseY - this.lastMouseY) / (float)denom;
                int scrollAmount = (int)(dragPercentage * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.descriptionScrollPos = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.descriptionScrollPos + scrollAmount));
                this.lastMouseY = currentMouseY;
            }
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(click);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            double amount = verticalAmount != 0.0 ? verticalAmount : horizontalAmount;
            int scrollAmount = (int)(-amount * 20.0);
            this.descriptionScrollPos = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.descriptionScrollPos + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private String encodeImageUrl(String url) {
        try {
            URL parsedUrl = new URL(url);
            String encodedPath = URLEncoder.encode(parsedUrl.getPath(), "UTF-8").replace("%2F", "/").replace("+", "%20");
            return parsedUrl.getProtocol() + "://" + parsedUrl.getHost() + (String)(parsedUrl.getPort() != -1 ? ":" + parsedUrl.getPort() : "") + encodedPath;
        }
        catch (Exception e) {
            System.err.println("Failed to encode URL, using original: " + e.getMessage());
            return url.replace(" ", "%20");
        }
    }
}

