/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.networking;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.models.SchematicCreateDTO;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class LitematicHttpClient {
    private static final String BASE_URL = "https://choculaterie.com/api/LitematicDownloaderModAPI";
    private static final Gson gson = new Gson();
    private static final HttpClient client;
    private static final long PAGINATED_CACHE_TTL_MS = 900000L;
    private static final long SEARCH_CACHE_TTL_MS = 60000L;
    private static final long DETAIL_CACHE_TTL_MS = 600000L;
    private static final Map<String, CacheEntry<PaginatedResult>> paginatedCache;
    private static final Map<String, CacheEntry<List<SchematicInfo>>> searchCache;
    private static final Map<String, CacheEntry<SchematicDetailInfo>> detailCache;

    public static void clearCaches() {
        paginatedCache.clear();
        searchCache.clear();
        detailCache.clear();
    }

    public static PaginatedResult fetchSchematicsPaginated(int page, int pageSize) {
        return LitematicHttpClient.fetchSchematicsPaginated(page, pageSize, false);
    }

    public static PaginatedResult fetchSchematicsPaginated(int page, int pageSize, boolean showUnverified) {
        ArrayList<SchematicInfo> schematicItems = new ArrayList<SchematicInfo>();
        PaginatedResult result = new PaginatedResult(schematicItems, 0, 0, 0);
        String cacheKey = "paginated:" + page + ":" + pageSize + ":" + showUnverified;
        CacheEntry<PaginatedResult> cached = paginatedCache.get(cacheKey);
        if (cached != null && System.currentTimeMillis() - cached.timestamp < 900000L) {
            return (PaginatedResult)cached.value;
        }
        try {
            JsonObject jsonResponse;
            String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/GetPaginatedFtp?page=" + page + "&pageSize=" + pageSize + "&showUnverified=" + showUnverified;
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
            System.out.println("Pagination API Request URL: " + url);
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            System.out.println("Pagination API Response Status: " + response.statusCode());
            System.out.println("Pagination API Response Body: " + response.body());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematics: " + response.statusCode());
            }
            if (response.body() == null || response.body().trim().isEmpty()) {
                System.out.println("Empty response body");
                return result;
            }
            try {
                jsonResponse = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            }
            catch (Exception e) {
                System.err.println("Failed to parse JSON response as object: " + e.getMessage());
                System.err.println("Response body: " + response.body());
                return result;
            }
            if (jsonResponse == null) {
                System.err.println("JsonObject is null");
                return result;
            }
            JsonArray schematicsArray = null;
            if (jsonResponse.has("schematics")) {
                schematicsArray = jsonResponse.getAsJsonArray("schematics");
            }
            if (schematicsArray == null) {
                System.err.println("Schematics array is null or missing");
                return result;
            }
            for (int i = 0; i < schematicsArray.size(); ++i) {
                try {
                    JsonObject json = schematicsArray.get(i).getAsJsonObject();
                    SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                    schematicItems.add(schematic);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error parsing schematic item " + i + ": " + e.getMessage());
                }
            }
            int totalPages = jsonResponse.has("totalPages") ? jsonResponse.get("totalPages").getAsInt() : 1;
            int currentPage = jsonResponse.has("currentPage") ? jsonResponse.get("currentPage").getAsInt() : 1;
            int totalCount = jsonResponse.has("totalCount") ? jsonResponse.get("totalCount").getAsInt() : schematicItems.size();
            result = new PaginatedResult(schematicItems, totalPages, currentPage, totalCount);
            paginatedCache.put(cacheKey, new CacheEntry<PaginatedResult>(result, System.currentTimeMillis()));
            return result;
        }
        catch (Exception e) {
            System.err.println("Error in fetchSchematicsPaginated: " + e.getMessage());
            e.printStackTrace();
            return result;
        }
    }

    public static List<SchematicInfo> searchSchematics(String query) {
        ArrayList<SchematicInfo> schematics = new ArrayList<SchematicInfo>();
        String searchKey = "search:" + (query == null ? "" : query.trim().toLowerCase());
        CacheEntry<List<SchematicInfo>> cachedSearch = searchCache.get(searchKey);
        if (cachedSearch != null && System.currentTimeMillis() - cachedSearch.timestamp < 60000L) {
            return (List)cachedSearch.value;
        }
        String queryToEncode = query == null ? "" : query;
        String encodedQuery = URLEncoder.encode(queryToEncode, StandardCharsets.UTF_8);
        String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/Search?query=" + encodedQuery;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().build();
        HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
        System.out.println("Search API Response Status: " + response.statusCode());
        System.out.println("Search API Response Body: " + response.body());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to search schematics: " + response.statusCode());
        }
        if (response.body() == null || response.body().trim().isEmpty()) {
            System.out.println("Empty search response body");
            return schematics;
        }
        try {
            JsonObject jsonResponse = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            if (jsonResponse != null && jsonResponse.has("schematics")) {
                JsonArray schematicsArray = jsonResponse.getAsJsonArray("schematics");
                for (int i = 0; i < schematicsArray.size(); ++i) {
                    try {
                        JsonObject json = schematicsArray.get(i).getAsJsonObject();
                        SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                        schematics.add(schematic);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Error parsing search result item " + i + ": " + e.getMessage());
                    }
                }
                searchCache.put(searchKey, new CacheEntry<ArrayList<SchematicInfo>>(schematics, System.currentTimeMillis()));
                return schematics;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to parse as paginated object, trying direct array: " + e.getMessage());
        }
        try {
            JsonArray jsonArray = (JsonArray)gson.fromJson(response.body(), JsonArray.class);
            if (jsonArray == null) {
                System.err.println("Search JsonArray is null");
                return schematics;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                try {
                    JsonObject json = jsonArray.get(i).getAsJsonObject();
                    SchematicInfo schematic = new SchematicInfo(json.has("id") ? json.get("id").getAsString() : "", json.has("name") ? json.get("name").getAsString() : "Unknown", json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.has("viewCount") ? json.get("viewCount").getAsInt() : 0, json.has("downloadCount") ? json.get("downloadCount").getAsInt() : 0, json.has("username") ? json.get("username").getAsString() : "Unknown");
                    schematics.add(schematic);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Error parsing search result item " + i + ": " + e.getMessage());
                }
            }
            searchCache.put(searchKey, new CacheEntry<ArrayList<SchematicInfo>>(schematics, System.currentTimeMillis()));
            return schematics;
        }
        catch (Exception e) {
            try {
                System.err.println("Failed to parse search response as array: " + e.getMessage());
                return schematics;
            }
            catch (Exception e2) {
                System.err.println("Error in searchSchematics: " + e2.getMessage());
                e2.printStackTrace();
                return schematics;
            }
        }
    }

    public static SchematicDetailInfo fetchSchematicDetail(String id) {
        String detailKey = "detail:" + (id == null ? "" : id);
        CacheEntry<SchematicDetailInfo> cachedDetail = detailCache.get(detailKey);
        if (cachedDetail != null && System.currentTimeMillis() - cachedDetail.timestamp < 600000L) {
            return (SchematicDetailInfo)cachedDetail.value;
        }
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/Getbyid/" + id)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic details: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            SchematicDetailInfo detail = new SchematicDetailInfo(json.get("id").getAsString(), json.get("name").getAsString(), json.has("description") && !json.get("description").isJsonNull() ? json.get("description").getAsString() : "", json.get("viewCount").getAsInt(), json.get("downloadCount").getAsInt(), json.has("coverPicture") && !json.get("coverPicture").isJsonNull() ? json.get("coverPicture").getAsString() : "", json.get("username").getAsString(), json.get("publishDate").getAsString());
            detailCache.put(detailKey, new CacheEntry<SchematicDetailInfo>(detail, System.currentTimeMillis()));
            return detail;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to fetch schematic detail", e);
        }
    }

    public static String downloadFileFromUrl(String downloadUrl, String fileName) {
        try {
            String normalized;
            if (downloadUrl == null || downloadUrl.trim().isEmpty()) {
                throw new IllegalArgumentException("Empty download URL");
            }
            String savePath = SettingsManager.getSchematicsPath() + File.separator;
            File directory = new File(savePath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String filePath = savePath + fileName + ".litematic";
            String encodedUrl = normalized = LitematicHttpClient.normalizeExternalUrl(downloadUrl);
            try {
                URL urlObj = new URL(normalized);
                String path = urlObj.getPath();
                String query = urlObj.getQuery();
                String ref = urlObj.getRef();
                if (path != null) {
                    path = path.replace(" ", "%20");
                }
                if (query != null) {
                    query = query.replace(" ", "%20");
                }
                StringBuilder rebuilt = new StringBuilder();
                rebuilt.append(urlObj.getProtocol()).append("://");
                rebuilt.append(urlObj.getHost());
                if (urlObj.getPort() != -1) {
                    rebuilt.append(":").append(urlObj.getPort());
                }
                if (path != null) {
                    rebuilt.append(path);
                }
                if (query != null) {
                    rebuilt.append("?").append(query);
                }
                if (ref != null) {
                    rebuilt.append("#").append(ref);
                }
                encodedUrl = rebuilt.toString();
            }
            catch (Exception e) {
                encodedUrl = normalized.replace(" ", "%20");
            }
            URI uri = URI.create(encodedUrl);
            if (uri.getScheme() == null || uri.getScheme().isEmpty()) {
                throw new IllegalArgumentException("URI with undefined scheme: " + encodedUrl);
            }
            HttpRequest request = HttpRequest.newBuilder().uri(uri).GET().build();
            HttpResponse<byte[]> response = client.send(request, HttpResponse.BodyHandlers.ofByteArray());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to download file from URL: " + response.statusCode());
            }
            try (FileOutputStream fos = new FileOutputStream(filePath);){
                fos.write(response.body());
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download file: " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static String downloadSchematic(String base64Data, String fileName) {
        try {
            String savePath = SettingsManager.getSchematicsPath() + File.separator;
            File directory = new File(savePath);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            String filePath = savePath + fileName + ".litematic";
            byte[] decodedData = Base64.getDecoder().decode(base64Data);
            try (FileOutputStream fos = new FileOutputStream(filePath);){
                fos.write(decodedData);
            }
            return filePath;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static String fetchAndDownloadSchematic(String id, String fileName) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/GetLitematicFiles/" + id)).GET().build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to fetch schematic file: " + response.statusCode());
            }
            JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
            if (json.has("files") && json.getAsJsonArray("files").size() > 0) {
                JsonObject firstFile = json.getAsJsonArray("files").get(0).getAsJsonObject();
                if (firstFile.has("url")) {
                    String downloadUrl = firstFile.get("url").getAsString();
                    return LitematicHttpClient.downloadFileFromUrl(downloadUrl, fileName);
                }
                throw new RuntimeException("No download URL found in response");
            }
            throw new RuntimeException("No schematic file found");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to download schematic: " + e.getMessage(), e);
        }
    }

    public static void uploadLitematicFile(File file, UploadCallback callback) {
        new Thread(() -> {
            try {
                String boundary = "Boundary-" + System.currentTimeMillis();
                byte[] fileBytes = Files.readAllBytes(file.toPath());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(("--" + boundary + "\r\n").getBytes());
                baos.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
                baos.write("Content-Type: application/octet-stream\r\n\r\n".getBytes());
                baos.write(fileBytes);
                baos.write("\r\n".getBytes());
                baos.write(("--" + boundary + "--\r\n").getBytes());
                byte[] requestBody = baos.toByteArray();
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/upload")).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                if (response.statusCode() == 200) {
                    JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                    String shortUrl = json.get("shortUrl").getAsString();
                    class_310.method_1551().execute(() -> {
                        class_310.method_1551().field_1774.method_1455(shortUrl);
                        callback.onSuccess(shortUrl);
                    });
                } else {
                    class_310.method_1551().execute(() -> callback.onError("Upload failed: " + response.statusCode() + " " + (String)response.body()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                class_310.method_1551().execute(() -> callback.onError("Upload failed: " + e.getMessage()));
            }
        }).start();
    }

    public static void createSchematic(SchematicCreateDTO schematicDto, String apiKey, CreateSchematicCallback callback) {
        new Thread(() -> {
            block22: {
                try {
                    File litematicFile;
                    int i;
                    String boundary = "Boundary-" + System.currentTimeMillis();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    System.out.println("=== HTTP CLIENT DEBUG START ===");
                    System.out.println("Creating multipart request with boundary: " + boundary);
                    System.out.println("DTO contents:");
                    System.out.println("  - Name: " + schematicDto.getName());
                    System.out.println("  - Description: " + schematicDto.getDescription());
                    System.out.println("  - SchematicsPictureFiles: " + schematicDto.getSchematicsPictureFiles().size() + " files");
                    for (i = 0; i < schematicDto.getSchematicsPictureFiles().size(); ++i) {
                        File file = schematicDto.getSchematicsPictureFiles().get(i);
                        System.out.println("    [" + i + "] " + file.getName() + " (" + file.length() + " bytes)");
                    }
                    System.out.println("  - LitematicFiles: " + schematicDto.getLitematicFiles().size() + " files");
                    for (i = 0; i < schematicDto.getLitematicFiles().size(); ++i) {
                        litematicFile = schematicDto.getLitematicFiles().get(i);
                        System.out.println("    [" + i + "] " + litematicFile.getName() + " (" + litematicFile.length() + " bytes)");
                    }
                    System.out.println("  - CoverImageIndex: " + schematicDto.getCoverImageIndex());
                    System.out.println("  - Tags: " + schematicDto.getTags());
                    System.out.println("  - DownloadLinkMediaFire: " + schematicDto.getDownloadLinkMediaFire());
                    System.out.println("  - YoutubeLink: " + schematicDto.getYoutubeLink());
                    System.out.println("Adding form fields to multipart request...");
                    LitematicHttpClient.addFormField(baos, boundary, "Name", schematicDto.getName());
                    System.out.println("  Added Name field: " + schematicDto.getName());
                    LitematicHttpClient.addFormField(baos, boundary, "Description", schematicDto.getDescription() != null ? schematicDto.getDescription() : "");
                    System.out.println("  Added Description field: " + (schematicDto.getDescription() != null ? schematicDto.getDescription() : ""));
                    if (schematicDto.getDownloadLinkMediaFire() != null) {
                        LitematicHttpClient.addFormField(baos, boundary, "DownloadLinkMediaFire", schematicDto.getDownloadLinkMediaFire());
                        System.out.println("  Added DownloadLinkMediaFire field: " + schematicDto.getDownloadLinkMediaFire());
                    }
                    if (schematicDto.getYoutubeLink() != null) {
                        LitematicHttpClient.addFormField(baos, boundary, "YoutubeLink", schematicDto.getYoutubeLink());
                        System.out.println("  Added YoutubeLink field: " + schematicDto.getYoutubeLink());
                    }
                    if (schematicDto.getTags() != null) {
                        LitematicHttpClient.addFormField(baos, boundary, "Tags", schematicDto.getTags());
                        System.out.println("  Added Tags field: " + schematicDto.getTags());
                    }
                    if (schematicDto.getCoverImageIndex() != null) {
                        LitematicHttpClient.addFormField(baos, boundary, "CoverImageIndex", schematicDto.getCoverImageIndex().toString());
                        System.out.println("  Added CoverImageIndex field: " + schematicDto.getCoverImageIndex().toString());
                    }
                    System.out.println("Adding picture files to multipart request...");
                    for (i = 0; i < schematicDto.getSchematicsPictureFiles().size(); ++i) {
                        File pictureFile = schematicDto.getSchematicsPictureFiles().get(i);
                        System.out.println("  Adding picture file [" + i + "]: " + pictureFile.getName() + " (" + pictureFile.length() + " bytes)");
                        LitematicHttpClient.addFileField(baos, boundary, "SchematicsPictureFiles", pictureFile);
                    }
                    System.out.println("Adding litematic files to multipart request...");
                    for (i = 0; i < schematicDto.getLitematicFiles().size(); ++i) {
                        litematicFile = schematicDto.getLitematicFiles().get(i);
                        System.out.println("  Adding litematic file [" + i + "]: " + litematicFile.getName() + " (" + litematicFile.length() + " bytes)");
                        LitematicHttpClient.addFileField(baos, boundary, "LitematicFiles", litematicFile);
                    }
                    baos.write(("--" + boundary + "--\r\n").getBytes());
                    byte[] requestBody = baos.toByteArray();
                    System.out.println("Final multipart request size: " + requestBody.length + " bytes");
                    System.out.println("=== HTTP CLIENT DEBUG END ===");
                    HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://choculaterie.com/api/LitematicDownloaderModAPI/CreateSchematic")).header("Content-Type", "multipart/form-data; boundary=" + boundary).header("X-API-Key", apiKey).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
                    HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                    System.out.println("Server response status: " + response.statusCode());
                    System.out.println("Server response body: " + response.body());
                    System.out.println("Server response headers: " + String.valueOf(response.headers().map()));
                    if (response.statusCode() == 201) {
                        JsonObject json = (JsonObject)gson.fromJson(response.body(), JsonObject.class);
                        class_310.method_1551().execute(() -> callback.onSuccess(json));
                        break block22;
                    }
                    Object errorMessage = "Creation failed: " + response.statusCode();
                    String responseBody = response.body();
                    try {
                        if (responseBody != null && !responseBody.trim().isEmpty()) {
                            if (responseBody.trim().startsWith("{")) {
                                JsonObject errorJson = (JsonObject)gson.fromJson(responseBody, JsonObject.class);
                                if (errorJson.has("error")) {
                                    errorMessage = errorJson.get("error").getAsString();
                                }
                                if (errorJson.has("message")) {
                                    errorMessage = (String)errorMessage + " - " + errorJson.get("message").getAsString();
                                }
                                if (errorJson.has("details")) {
                                    errorMessage = (String)errorMessage + " - " + errorJson.get("details").getAsString();
                                }
                                if (errorJson.has("errors")) {
                                    errorMessage = (String)errorMessage + " - " + errorJson.get("errors").toString();
                                }
                            } else {
                                errorMessage = (String)errorMessage + " - " + responseBody;
                            }
                        } else {
                            errorMessage = (String)errorMessage + " - No response body";
                        }
                        if (response.statusCode() == 400) {
                            errorMessage = (String)errorMessage + " (Bad Request - check required fields, file formats, or data validation)";
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Failed to parse error response: " + e.getMessage());
                        errorMessage = (String)errorMessage + " - Raw response: " + responseBody;
                    }
                    System.err.println("Publishing failed with detailed error: " + (String)errorMessage);
                    String finalErrorMessage = errorMessage;
                    class_310.method_1551().execute(() -> callback.onError(finalErrorMessage));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    class_310.method_1551().execute(() -> callback.onError("Creation failed: " + e.getMessage()));
                }
            }
        }).start();
    }

    private static void addFormField(ByteArrayOutputStream baos, String boundary, String name, String value) throws Exception {
        baos.write(("--" + boundary + "\r\n").getBytes());
        baos.write(("Content-Disposition: form-data; name=\"" + name + "\"\r\n").getBytes());
        baos.write("\r\n".getBytes());
        baos.write(value.getBytes(StandardCharsets.UTF_8));
        baos.write("\r\n".getBytes());
    }

    private static void addFileField(ByteArrayOutputStream baos, String boundary, String fieldName, File file) throws Exception {
        byte[] fileBytes = Files.readAllBytes(file.toPath());
        baos.write(("--" + boundary + "\r\n").getBytes());
        baos.write(("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + file.getName() + "\"\r\n").getBytes());
        String contentType = "application/octet-stream";
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            contentType = "image/jpeg";
        } else if (fileName.endsWith(".png")) {
            contentType = "image/png";
        } else if (fileName.endsWith(".litematic")) {
            contentType = "application/octet-stream";
        }
        baos.write(("Content-Type: " + contentType + "\r\n").getBytes());
        baos.write("\r\n".getBytes());
        baos.write(fileBytes);
        baos.write("\r\n".getBytes());
    }

    public static HttpClient getClient() {
        return client;
    }

    private static String normalizeExternalUrl(String url) {
        if (url == null) {
            return "";
        }
        String u = url.trim();
        if (u.isEmpty()) {
            return u;
        }
        if (u.startsWith("http://") || u.startsWith("https://")) {
            return u;
        }
        if (u.startsWith("//")) {
            return "https:" + u;
        }
        if (u.startsWith("/")) {
            return "https://www.minemev.com" + u;
        }
        if (u.matches("[A-Za-z0-9.-]+\\.[A-Za-z]{2,}.*")) {
            return "https://" + u;
        }
        return u;
    }

    static {
        paginatedCache = new ConcurrentHashMap<String, CacheEntry<PaginatedResult>>();
        searchCache = new ConcurrentHashMap<String, CacheEntry<List<SchematicInfo>>>();
        detailCache = new ConcurrentHashMap<String, CacheEntry<SchematicDetailInfo>>();
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            client = HttpClient.newBuilder().sslContext(sslContext).followRedirects(HttpClient.Redirect.ALWAYS).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize HttpClient with custom SSL context", e);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PaginatedResult {
        private final ReferenceImmutableList<SchematicInfo> items;
        private final int totalPages;
        private final int currentPage;
        private final int totalItems;

        public PaginatedResult(ArrayList<SchematicInfo> items, int totalPages, int currentPage, int totalItems) {
            this.items = new ReferenceImmutableList(items);
            this.totalPages = totalPages;
            this.currentPage = currentPage;
            this.totalItems = totalItems;
        }

        public ReferenceImmutableList<SchematicInfo> getItems() {
            return this.items;
        }

        public int getTotalPages() {
            return this.totalPages;
        }

        public int getCurrentPage() {
            return this.currentPage;
        }

        public int getTotalItems() {
            return this.totalItems;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static class CacheEntry<T> {
        final T value;
        final long timestamp;

        CacheEntry(T value, long timestamp) {
            this.value = value;
            this.timestamp = timestamp;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface UploadCallback {
        public void onSuccess(String var1);

        public void onError(String var1);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface CreateSchematicCallback {
        public void onSuccess(JsonObject var1);

        public void onError(String var1);
    }
}

