/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import java.io.File;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class RenameItemSceen
extends class_437 {
    private final class_437 parent;
    private final File fileToRename;
    private final Consumer<Boolean> callback;
    private class_342 nameField;
    private String originalFileName;
    private String errorMessage = null;
    private long errorDisplayTime = 0L;

    public RenameItemSceen(class_437 parent, File fileToRename, Consumer<Boolean> callback) {
        super((class_2561)class_2561.method_43470((String)"Rename Item"));
        this.parent = parent;
        this.fileToRename = fileToRename;
        this.callback = callback;
        this.originalFileName = fileToRename.getName();
    }

    protected void method_25426() {
        int buttonWidth = 100;
        int spacing = 10;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Confirm"), button -> this.renameFile()).method_46434(this.field_22789 / 2 - buttonWidth - spacing / 2, this.field_22790 / 2 + 40, buttonWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> {
            class_310.method_1551().method_1507(this.parent);
            this.callback.accept(false);
        }).method_46434(this.field_22789 / 2 + spacing / 2, this.field_22790 / 2 + 40, buttonWidth, 20).method_46431());
        int fieldWidth = 300;
        this.nameField = new class_342(this.field_22793, (this.field_22789 - fieldWidth) / 2, this.field_22790 / 2 - 10, fieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.nameField.method_1852(this.originalFileName);
        this.nameField.method_1880(255);
        if (this.fileToRename.isDirectory() || !this.originalFileName.contains(".")) {
            this.nameField.method_1875(0);
            this.nameField.method_1884(this.originalFileName.length());
        } else {
            this.nameField.method_1875(0);
            this.nameField.method_1884(this.originalFileName.lastIndexOf(46));
        }
        this.nameField.method_1852(this.fileToRename.getName());
        this.nameField.method_25365(true);
        this.method_37063((class_364)this.nameField);
        this.method_25395((class_364)this.nameField);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Enter a new name:"), this.field_22789 / 2, this.field_22790 / 2 - 30, -3355444);
        String typeInfo = this.fileToRename.isDirectory() ? "Folder" : "File";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)typeInfo), this.field_22789 / 2, this.field_22790 / 2 - 45, -5592406);
        if (this.errorMessage != null && System.currentTimeMillis() - this.errorDisplayTime < 3000L) {
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.errorMessage), this.field_22789 / 2, this.field_22790 / 2 + 15, -43691);
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            this.renameFile();
            return true;
        }
        if (keyCode == 256) {
            class_310.method_1551().method_1507(this.parent);
            this.callback.accept(false);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void renameFile() {
        String newName = this.nameField.method_1882().trim();
        if (newName.isEmpty()) {
            this.showError("Name cannot be empty");
            return;
        }
        if (newName.contains("/") || newName.contains("\\") || newName.contains(":") || newName.contains("*") || newName.contains("?") || newName.contains("\"") || newName.contains("<") || newName.contains(">") || newName.contains("|")) {
            this.showError("Invalid characters in name");
            return;
        }
        if (newName.equals(this.originalFileName)) {
            class_310.method_1551().method_1507(this.parent);
            this.callback.accept(false);
            return;
        }
        File newFile = new File(this.fileToRename.getParentFile(), newName);
        if (newFile.exists()) {
            this.showError("A file with this name already exists");
            return;
        }
        boolean success = this.fileToRename.renameTo(newFile);
        if (success) {
            class_310.method_1551().method_1507(this.parent);
            this.callback.accept(true);
        } else {
            this.showError("Failed to rename file");
        }
    }

    private void showError(String message) {
        this.errorMessage = message;
        this.errorDisplayTime = System.currentTimeMillis();
    }
}

