/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.CacheManager;
import com.choculaterie.gui.ConfirmationScreen;
import com.choculaterie.gui.DetailScreen;
import com.choculaterie.gui.FileManagerScreen;
import com.choculaterie.gui.NavigationState;
import com.choculaterie.gui.SettingsScreen;
import com.choculaterie.gui.ToastManager;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.choculaterie.networking.LitematicHttpClient;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class LitematicDownloaderScreen
extends class_437 {
    private ReferenceImmutableList<SchematicInfo> schematics = new ReferenceImmutableList(new ArrayList());
    private class_342 searchField;
    private String searchTerm = "";
    private boolean isSearchMode = false;
    private int currentPage = 1;
    private int totalPages = 1;
    private int totalItems = 0;
    private final int pageSize = 15;
    private boolean showUnverified = false;
    private static final CacheManager cacheManager = new CacheManager();
    private static final long CACHE_DURATION_MS = 900000L;
    private static final long DETAIL_CACHE_DURATION_MS = 300000L;
    private volatile int activeRequestPage = -1;
    private volatile long lastRequestTime = 0L;
    private static final long MIN_REQUEST_INTERVAL_MS = 100L;
    private int scrollOffset = 0;
    private final int itemHeight = 40;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;
    private int scrollDragOffset = 0;
    private String statusMessage = null;
    private int statusColor = -1;
    private long statusMessageDisplayTime = 0L;
    private static final long STATUS_MESSAGE_DURATION = 3000L;
    private int lastClickedIndex = -1;
    private long lastClickTime = 0L;
    private boolean isLoading = false;
    private long loadingStartTime = 0L;
    private long lastSearchTime = 0L;
    private static final long SEARCH_DEBOUNCE_MS = 500L;
    private String lastSearchedTerm = "";
    private int hoveredItemIndex = -1;
    private long hoverStartTime = 0L;
    private static final long HOVER_DELAY_MS = 200L;
    private boolean isPreloadingHoveredItem = false;
    @Nullable
    private String currentlyPreloadingId = null;
    private boolean isPreloadingPagination = false;
    private int preloadingPageNumber = -1;

    public static CacheManager getCacheManager() {
        return cacheManager;
    }

    public LitematicDownloaderScreen() {
        super((class_2561)class_2561.method_43470((String)""));
    }

    public LitematicDownloaderScreen(boolean restoreState) {
        super((class_2561)class_2561.method_43470((String)""));
        if (restoreState) {
            // empty if block
        }
    }

    public void restoreNavigationState(int currentPage, int totalPages, int totalItems, boolean isSearchMode, String searchTerm, String lastSearchedTerm, int scrollOffset) {
        this.currentPage = currentPage;
        this.totalPages = totalPages;
        this.totalItems = totalItems;
        this.isSearchMode = isSearchMode;
        this.searchTerm = searchTerm;
        this.lastSearchedTerm = lastSearchedTerm;
        this.scrollOffset = scrollOffset;
        System.out.println("Restored navigation state in screen: page=" + currentPage + ", scroll=" + scrollOffset);
    }

    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1"), button -> class_310.method_1551().method_1507((class_437)new FileManagerScreen(this))).method_46434(this.field_22789 - 65, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2699"), button -> class_310.method_1551().method_1507((class_437)new SettingsScreen(this, changed -> {
            if (changed.booleanValue()) {
                this.loadSchematics();
            }
        }))).method_46434(this.field_22789 - 90, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd04"), button -> {
            cacheManager.clearAllCache();
            System.out.println("Cleared all cache - forcing fresh data load");
            if (this.isSearchMode) {
                this.performSearch();
            } else {
                this.loadSchematics();
            }
        }).method_46434(this.field_22789 - 40, 10, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.showUnverified ? "\u2713" : "\u2717")), button -> {
            this.showUnverified = !this.showUnverified;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.showUnverified ? "\u2713" : "\u2717")));
            cacheManager.clearAllCache();
            this.currentPage = 1;
            if (this.isSearchMode) {
                this.performSearch();
            } else {
                this.loadSchematics();
            }
        }).method_46434(this.field_22789 - 115, 10, 20, 20).method_46431());
        int contentWidth = Math.min(600, this.field_22789 - 80);
        this.scrollAreaX = (this.field_22789 - contentWidth) / 2;
        this.scrollAreaY = 70;
        this.scrollAreaWidth = contentWidth;
        this.scrollAreaHeight = this.field_22790 - this.scrollAreaY - 40;
        int searchFieldWidth = 200;
        this.searchField = new class_342(this.field_22793, (this.field_22789 - searchFieldWidth) / 2, 10, searchFieldWidth, 20, (class_2561)class_2561.method_43470((String)""));
        this.searchField.method_1880(50);
        this.searchField.method_47404((class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_1863(text -> {
            this.searchTerm = text.trim();
        });
        this.method_25429((class_364)this.searchField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2715"), button -> {
            this.searchField.method_1852("");
            this.isSearchMode = false;
            this.currentPage = 1;
            this.loadSchematics();
        }).method_46434((this.field_22789 + searchFieldWidth) / 2 + 5, 10, 20, 20).method_46431());
        this.setupPaginationControls();
        this.updateScrollbarDimensions();
        NavigationState navState = NavigationState.getInstance();
        if (this instanceof LitematicDownloaderScreen && navState.getSavedCurrentPage() > 0) {
            navState.restoreState(this);
            if (this.isSearchMode && !this.searchTerm.isEmpty()) {
                this.searchField.method_1852(this.searchTerm);
            }
        }
        this.loadSchematics();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String text;
        if (this.searchField.method_25370() && keyCode == 257 && !(text = this.searchField.method_1882().trim()).isEmpty()) {
            this.searchTerm = text;
            this.lastSearchedTerm = text;
            this.isSearchMode = true;
            this.currentPage = 1;
            this.performSearch();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private void setupPaginationControls() {
        int centerX = this.field_22789 / 2;
        int paginationY = this.field_22790 - 30;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25c0"), button -> {
            if (this.currentPage > 1) {
                --this.currentPage;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX - 100, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u25b6"), button -> {
            if (this.currentPage < this.totalPages) {
                ++this.currentPage;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX + 80, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23ee"), button -> {
            if (this.currentPage > 1) {
                this.currentPage = 1;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX - 125, paginationY, 20, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u23ed"), button -> {
            if (this.currentPage < this.totalPages) {
                this.currentPage = this.totalPages;
                if (this.isSearchMode) {
                    this.performSearch();
                } else {
                    this.loadSchematics();
                }
            }
        }).method_46434(centerX + 105, paginationY, 20, 20).method_46431());
    }

    private void performSearch() {
        if (this.searchTerm.isEmpty()) {
            return;
        }
        if (cacheManager.hasValidSearchCache(this.searchTerm, 900000L)) {
            this.schematics = cacheManager.getSearchCache(this.searchTerm).getItems();
            this.totalPages = 1;
            this.totalItems = this.schematics.size();
            this.updateScrollbarDimensions();
            return;
        }
        this.schematics = new ReferenceImmutableList(new ArrayList());
        this.updateScrollbarDimensions();
        this.scrollOffset = 0;
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        new Thread(() -> {
            ReferenceImmutableList searchResults = new ReferenceImmutableList(LitematicHttpClient.searchSchematics(this.searchTerm));
            class_310.method_1551().execute(() -> {
                this.schematics = searchResults;
                this.totalPages = 1;
                this.totalItems = searchResults.size();
                cacheManager.putSearchCache(this.searchTerm, (ReferenceImmutableList<SchematicInfo>)searchResults);
                this.updateScrollbarDimensions();
                this.isLoading = false;
            });
        }).start();
    }

    private void performSearchForced() {
        cacheManager.clearSearchCache(this.searchTerm);
        this.performSearch();
    }

    private void loadSchematics() {
        System.out.println("=== loadSchematics() called for page " + this.currentPage + " ===");
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastRequestTime < 100L) {
            System.out.println("Request throttled - too soon after last request");
            return;
        }
        if (this.activeRequestPage != -1 && this.activeRequestPage != this.currentPage) {
            System.out.println("Ignoring request for page " + this.currentPage + " - already loading page " + this.activeRequestPage);
            return;
        }
        cacheManager.debugPrintCachedPages();
        if (cacheManager.hasValidSchematicCache(this.currentPage, 900000L)) {
            System.out.println("Using cached data for page " + this.currentPage);
            CacheManager.SchematicCacheEntry cachedEntry = cacheManager.getSchematicCache(this.currentPage);
            this.schematics = cachedEntry.getItems();
            this.totalPages = cachedEntry.getTotalPages();
            this.totalItems = cachedEntry.getTotalItems();
            this.updateScrollbarDimensions();
            System.out.println("Loaded " + this.schematics.size() + " items from cache for page " + this.currentPage);
            return;
        }
        if (this.activeRequestPage == this.currentPage && this.isLoading) {
            System.out.println("Already loading page " + this.currentPage + " - ignoring duplicate request");
            return;
        }
        System.out.println("No valid cache for page " + this.currentPage + ", fetching from server...");
        this.activeRequestPage = this.currentPage;
        this.lastRequestTime = currentTime;
        this.schematics = new ReferenceImmutableList(new ArrayList());
        this.updateScrollbarDimensions();
        this.scrollOffset = 0;
        this.isLoading = true;
        this.loadingStartTime = System.currentTimeMillis();
        int requestedPage = this.currentPage;
        new Thread(() -> {
            try {
                System.out.println("Fetching page " + requestedPage + " from server...");
                LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(requestedPage, 15, this.showUnverified);
                class_310.method_1551().execute(() -> {
                    if (this.activeRequestPage != requestedPage) {
                        System.out.println("Discarding response for page " + requestedPage + " - user navigated to page " + this.activeRequestPage);
                        if (this.isLoading && this.activeRequestPage == -1) {
                            this.isLoading = false;
                            System.out.println("Cleared loading state after discarding response");
                        }
                        return;
                    }
                    if (this.currentPage != requestedPage) {
                        System.out.println("Discarding response for page " + requestedPage + " - current page is now " + this.currentPage);
                        this.activeRequestPage = -1;
                        this.isLoading = false;
                        System.out.println("Cleared loading state after page change");
                        if (cacheManager.hasValidSchematicCache(this.currentPage, 900000L)) {
                            System.out.println("Loading cached data for current page " + this.currentPage + " after discarding response");
                            CacheManager.SchematicCacheEntry cachedEntry = cacheManager.getSchematicCache(this.currentPage);
                            this.schematics = cachedEntry.getItems();
                            this.totalPages = cachedEntry.getTotalPages();
                            this.totalItems = cachedEntry.getTotalItems();
                            this.updateScrollbarDimensions();
                            System.out.println("Restored " + this.schematics.size() + " items from cache for current page " + this.currentPage);
                        } else if (!cacheManager.hasValidSchematicCache(this.currentPage, 900000L)) {
                            System.out.println("Current page " + this.currentPage + " needs loading - starting request");
                            new Thread(() -> {
                                try {
                                    Thread.sleep(50L);
                                    class_310.method_1551().execute(this::loadSchematics);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }).start();
                        }
                        return;
                    }
                    System.out.println("Server response received for page " + requestedPage + ": " + result.getItems().size() + " items");
                    this.schematics = result.getItems();
                    this.totalPages = result.getTotalPages();
                    this.totalItems = result.getTotalItems();
                    try {
                        cacheManager.putSchematicCache(result);
                        System.out.println("Successfully cached page " + requestedPage);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to cache page " + requestedPage + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                    this.updateScrollbarDimensions();
                    this.isLoading = false;
                    this.activeRequestPage = -1;
                    cacheManager.debugPrintCachedPages();
                });
            }
            catch (Exception e) {
                System.err.println("Error fetching page " + requestedPage + ": " + e.getMessage());
                e.printStackTrace();
                class_310.method_1551().execute(() -> {
                    this.isLoading = false;
                    this.activeRequestPage = -1;
                });
            }
        }).start();
    }

    private void loadSchematicsForced() {
        cacheManager.clearSchematicCache(this.currentPage);
        this.loadSchematics();
    }

    private void updateScrollbarDimensions() {
        this.totalContentHeight = this.schematics.size() * 40;
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.min(this.scrollOffset, this.totalContentHeight - this.scrollAreaHeight);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.handleHoverPreloading(mouseX, mouseY);
        this.handlePaginationHoverPreloading(mouseX, mouseY);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2 - this.searchField.method_25368() / 4, 10, -1);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)"\ud83d\udd0d"), this.searchField.method_46426() - 15, this.searchField.method_46427() + 5, -5592406);
        String paginationText = this.isSearchMode ? "Found " + this.totalItems + " results" : "Page " + this.currentPage + " of " + this.totalPages + " (" + this.totalItems + " total)";
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)paginationText), this.field_22789 / 2, 40, -1);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        if (this.schematics.isEmpty()) {
            if (this.isLoading) {
                int centerY = this.scrollAreaY + this.scrollAreaHeight / 2;
                this.drawLoadingAnimation(context, this.field_22789 / 2, centerY - 15);
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Loading..."), this.field_22789 / 2, centerY + 15, -1);
            } else if (this.isSearchMode) {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("No results found for: " + this.lastSearchedTerm)), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, -1);
            } else {
                context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"No schematics found"), this.field_22789 / 2, this.scrollAreaY + this.scrollAreaHeight / 2, -1);
            }
        } else {
            int y = this.scrollAreaY - this.scrollOffset;
            for (int i = 0; i < this.schematics.size(); ++i) {
                SchematicInfo schematic = (SchematicInfo)this.schematics.get(i);
                if (y + 40 >= this.scrollAreaY && y <= this.scrollAreaY + this.scrollAreaHeight) {
                    this.renderSchematicItem(context, schematic, this.scrollAreaX, y, this.scrollAreaWidth, mouseX, mouseY, i);
                    context.method_25294(this.scrollAreaX, y + 40 - 5, this.scrollAreaX + this.scrollAreaWidth - 10, y + 40 - 4, 0x22FFFFFF);
                }
                y += 40;
            }
        }
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        if (this.hasActiveStatusMessage()) {
            int messageWidth = this.field_22793.method_1727(this.statusMessage) + 20;
            int messageHeight = 20;
            int messageX = (this.field_22789 - messageWidth) / 2;
            int messageY = this.field_22790 / 2 - 10;
            context.method_25294(messageX, messageY, messageX + messageWidth, messageY + messageHeight, Integer.MIN_VALUE);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)this.statusMessage), this.field_22789 / 2, this.field_22790 / 2 - 4, this.statusColor);
        }
        ToastManager.render(context, this.field_22789);
    }

    private void drawLoadingAnimation(class_332 context, int centerX, int centerY) {
        int radius = 12;
        int segments = 8;
        int animationDuration = 1600;
        long currentTime = System.currentTimeMillis();
        long elapsedTime = currentTime - this.loadingStartTime;
        float rotation = (float)(elapsedTime % (long)animationDuration) / (float)animationDuration;
        for (int i = 0; i < segments; ++i) {
            float angle = (float)((double)(i * 2) * Math.PI / (double)segments + (double)(rotation * 2.0f) * Math.PI);
            int x1 = centerX + (int)(Math.sin(angle) * (double)(radius - 3));
            int y1 = centerY + (int)(Math.cos(angle) * (double)(radius - 3));
            int x2 = centerX + (int)(Math.sin(angle) * (double)radius);
            int y2 = centerY + (int)(Math.cos(angle) * (double)radius);
            int alpha = 255 - i * 255 / segments;
            int color = 0xFFFFFFFF | alpha << 24;
            context.method_25294(x1, y1, x2, y2, color);
        }
    }

    private void renderSchematicItem(class_332 context, SchematicInfo schematic, int x, int y, int width, int mouseX, int mouseY, int index) {
        int textY;
        int maxTextWidth = width - 110;
        int textX = x + 10;
        int originalY = textY = y + 2;
        List titleLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)schematic.getName()), maxTextWidth);
        for (int i = 0; i < Math.min(titleLines.size(), 2); ++i) {
            if (i == 1 && titleLines.size() > 2) {
                Object lastLine = this.getPlainText((class_5481)titleLines.get(i));
                if (((String)lastLine).length() > 3) {
                    lastLine = ((String)lastLine).substring(0, ((String)lastLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)lastLine).method_30937(), textX, textY, -1, true);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)titleLines.get(i), textX, textY, -1, true);
            }
            textY += 10;
        }
        String description = schematic.getDescription().isEmpty() ? "No description" : schematic.getDescription();
        List descLines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43470((String)description), maxTextWidth);
        if (!descLines.isEmpty()) {
            if (descLines.size() > 1) {
                Object firstLine = this.getPlainText((class_5481)descLines.get(0));
                if (((String)firstLine).length() > 3) {
                    firstLine = ((String)firstLine).substring(0, ((String)firstLine).length() - 3) + "...";
                }
                context.method_51430(class_310.method_1551().field_1772, class_2561.method_43470((String)firstLine).method_30937(), textX, textY, -5592406, false);
            } else {
                context.method_51430(class_310.method_1551().field_1772, (class_5481)descLines.get(0), textX, textY, -5592406, false);
            }
            textY += 10;
        }
        String authorText = "By: " + schematic.getUsername();
        context.method_51433(class_310.method_1551().field_1772, authorText, textX, textY, -2763307, false);
        int rightX = x + width - 50;
        int statsY = originalY;
        String viewCountStr = String.valueOf(schematic.getViewCount());
        String downloadCountStr = String.valueOf(schematic.getDownloadCount());
        int maxNumberWidth = Math.max(class_310.method_1551().field_1772.method_1727(viewCountStr), class_310.method_1551().field_1772.method_1727(downloadCountStr));
        context.method_51433(class_310.method_1551().field_1772, viewCountStr, rightX - maxNumberWidth, statsY, -1, false);
        context.method_51433(class_310.method_1551().field_1772, " \ud83d\udc41", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(viewCountStr), statsY, -1, false);
        context.method_51433(class_310.method_1551().field_1772, downloadCountStr, rightX - maxNumberWidth, statsY += 10, -1, false);
        context.method_51433(class_310.method_1551().field_1772, " \u2b07", rightX - maxNumberWidth + class_310.method_1551().field_1772.method_1727(downloadCountStr), statsY, -1, false);
        int buttonX = x + width - 30;
        int buttonY = originalY - 2;
        boolean isButtonHovered = mouseX >= buttonX && mouseX <= buttonX + 20 && mouseY >= buttonY && mouseY <= buttonY + 20;
        int buttonColor = isButtonHovered ? -1711276033 : 0x66FFFFFF;
        context.method_25294(buttonX, buttonY, buttonX + 20, buttonY + 20, buttonColor);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"\u2b07"), buttonX + 10, buttonY + 6, -1);
    }

    private String getPlainText(class_5481 text) {
        StringBuilder sb = new StringBuilder();
        text.accept((index, style, codePoint) -> {
            sb.appendCodePoint(codePoint);
            return true;
        });
        return sb.toString();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int index;
        if (this.searchField.method_25370() && (mouseX < (double)this.searchField.method_46426() || mouseX > (double)(this.searchField.method_46426() + this.searchField.method_25368()) || mouseY < (double)this.searchField.method_46427() || mouseY > (double)(this.searchField.method_46427() + this.searchField.method_25364()))) {
            this.searchField.method_25365(false);
        }
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                this.scrollDragOffset = (int)(mouseY - (double)this.scrollBarY);
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                return true;
            }
        }
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && (index = (int)((mouseY - (double)this.scrollAreaY + (double)this.scrollOffset) / 40.0)) >= 0 && index < this.schematics.size()) {
            SchematicInfo schematic = (SchematicInfo)this.schematics.get(index);
            int buttonX = this.scrollAreaX + this.scrollAreaWidth - 30;
            int buttonY = this.scrollAreaY - this.scrollOffset + index * 40 + 5;
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + 20) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 20)) {
                this.handleDownload(schematic);
                return true;
            }
            if (button == 0) {
                long currentTime = System.currentTimeMillis();
                if (index == this.lastClickedIndex && currentTime - this.lastClickTime < 500L) {
                    NavigationState.getInstance().saveState(this.currentPage, this.totalPages, this.totalItems, this.isSearchMode, this.searchTerm, this.lastSearchedTerm, this.scrollOffset);
                    class_310.method_1551().method_1507((class_437)new DetailScreen(schematic.getId()));
                    return true;
                }
                this.lastClickedIndex = index;
                this.lastClickTime = currentTime;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void handleDownload(SchematicInfo schematic) {
        try {
            String fileName = schematic.getName().replaceAll("[^a-zA-Z0-9.-]", "_");
            String savePath = SettingsManager.getSchematicsPath() + File.separator;
            File potentialFile = new File(savePath + fileName + ".litematic");
            if (potentialFile.exists()) {
                ConfirmationScreen confirmationScreen = new ConfirmationScreen((class_2561)class_2561.method_43470((String)"File already exists"), (class_2561)class_2561.method_43470((String)("The file \"" + fileName + ".litematic\" already exists. Do you want to replace it?")), confirmed -> {
                    if (confirmed.booleanValue()) {
                        this.downloadSchematic(schematic, fileName);
                    }
                    class_310.method_1551().method_1507((class_437)this);
                });
                class_310.method_1551().method_1507((class_437)confirmationScreen);
            } else {
                this.downloadSchematic(schematic, fileName);
            }
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    private void downloadSchematic(SchematicInfo schematic, String fileName) {
        try {
            String relativePath;
            String filePath = LitematicHttpClient.fetchAndDownloadSchematic(schematic.getId(), fileName);
            String schematicsPath = SettingsManager.getSchematicsPath();
            if (filePath.startsWith(schematicsPath)) {
                String pathAfterBase = filePath.substring(schematicsPath.length());
                if (pathAfterBase.startsWith(File.separator)) {
                    pathAfterBase = pathAfterBase.substring(File.separator.length());
                }
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + pathAfterBase.replace(File.separator, "/");
            } else {
                String folderName = new File(schematicsPath).getName();
                relativePath = folderName + "/" + fileName + ".litematic";
            }
            this.setStatusMessage("Schematic downloaded to: " + relativePath, true);
        }
        catch (Exception e) {
            this.setStatusMessage("Failed to download schematic: " + e.getMessage(), false);
        }
    }

    public void setStatusMessage(String message, boolean isSuccess) {
        ToastManager.addToast(message, !isSuccess);
    }

    public boolean hasActiveStatusMessage() {
        return this.statusMessage != null && System.currentTimeMillis() - this.statusMessageDisplayTime < 3000L;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isScrolling) {
            float dragPosition = (float)(mouseY - (double)this.scrollDragOffset - (double)this.scrollAreaY) / (float)(this.scrollAreaHeight - this.scrollBarHeight);
            this.scrollOffset = (int)(dragPosition * (float)(this.totalContentHeight - this.scrollAreaHeight));
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(-verticalAmount * 20.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void handleHoverPreloading(int mouseX, int mouseY) {
        if (mouseX >= this.scrollAreaX && mouseX <= this.scrollAreaX + this.scrollAreaWidth && mouseY >= this.scrollAreaY && mouseY <= this.scrollAreaY + this.scrollAreaHeight && !this.schematics.isEmpty()) {
            int itemIndex = (mouseY - this.scrollAreaY + this.scrollOffset) / 40;
            if (itemIndex >= 0 && itemIndex < this.schematics.size()) {
                SchematicInfo hoveredSchematic = (SchematicInfo)this.schematics.get(itemIndex);
                if (itemIndex != this.hoveredItemIndex) {
                    this.hoveredItemIndex = itemIndex;
                    this.hoverStartTime = System.currentTimeMillis();
                    if (this.isPreloadingHoveredItem && !hoveredSchematic.getId().equals(this.currentlyPreloadingId)) {
                        System.out.println("Cancelled preload for " + this.currentlyPreloadingId + " - now hovering " + hoveredSchematic.getId());
                        this.currentlyPreloadingId = null;
                        this.isPreloadingHoveredItem = false;
                    }
                } else if (System.currentTimeMillis() - this.hoverStartTime >= 200L && !this.isPreloadingHoveredItem && !cacheManager.hasValidDetailCache(hoveredSchematic.getId(), 300000L)) {
                    this.startHoverPreload(hoveredSchematic);
                }
            } else {
                this.resetHoverState();
            }
        } else {
            this.resetHoverState();
        }
    }

    private void startHoverPreload(SchematicInfo schematic) {
        if (this.isPreloadingHoveredItem || schematic == null) {
            return;
        }
        String schematicId = schematic.getId();
        if (cacheManager.hasValidDetailCache(schematicId, 300000L)) {
            System.out.println("Skipping preload for " + schematicId + " - already cached");
            return;
        }
        this.isPreloadingHoveredItem = true;
        this.currentlyPreloadingId = schematicId;
        System.out.println("Starting hover preload for schematic: " + schematic.getName() + " (ID: " + schematicId + ")");
        new Thread(() -> {
            try {
                if (!this.isPreloadingHoveredItem || !schematicId.equals(this.currentlyPreloadingId)) {
                    System.out.println("Preload cancelled during fetch for " + schematicId);
                    return;
                }
                SchematicDetailInfo detailInfo = LitematicHttpClient.fetchSchematicDetail(schematicId);
                class_310.method_1551().execute(() -> {
                    if (this.isPreloadingHoveredItem && schematicId.equals(this.currentlyPreloadingId)) {
                        cacheManager.putDetailCache(schematicId, detailInfo, 300000L);
                        System.out.println("Successfully preloaded and cached details for: " + detailInfo.getName());
                    } else {
                        System.out.println("Discarded preload result for " + schematicId + " - user moved away");
                    }
                    if (schematicId.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during hover preload for " + schematicId + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    if (schematicId.equals(this.currentlyPreloadingId)) {
                        this.isPreloadingHoveredItem = false;
                        this.currentlyPreloadingId = null;
                    }
                });
            }
        }).start();
    }

    private void resetHoverState() {
        if (this.hoveredItemIndex != -1) {
            this.hoveredItemIndex = -1;
            this.hoverStartTime = 0L;
        }
    }

    private void handlePaginationHoverPreloading(int mouseX, int mouseY) {
        if (this.isSearchMode) {
            return;
        }
        int centerX = this.field_22789 / 2;
        int paginationY = this.field_22790 - 30;
        int buttonWidth = 20;
        int buttonHeight = 20;
        boolean isHoveringAnyButton = false;
        int targetPage = -1;
        if (mouseX >= centerX - 100 && mouseX <= centerX - 100 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage > 1) {
                targetPage = this.currentPage - 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX + 80 && mouseX <= centerX + 80 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage < this.totalPages) {
                targetPage = this.currentPage + 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX - 125 && mouseX <= centerX - 125 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight) {
            if (this.currentPage > 1) {
                targetPage = 1;
                isHoveringAnyButton = true;
            }
        } else if (mouseX >= centerX + 105 && mouseX <= centerX + 105 + buttonWidth && mouseY >= paginationY && mouseY <= paginationY + buttonHeight && this.currentPage < this.totalPages) {
            targetPage = this.totalPages;
            isHoveringAnyButton = true;
        }
        if (isHoveringAnyButton && targetPage != -1 && (!this.isPreloadingPagination || this.preloadingPageNumber != targetPage)) {
            if (this.isPreloadingPagination) {
                System.out.println("Switching pagination preload from page " + this.preloadingPageNumber + " to " + targetPage);
            }
            if (!cacheManager.hasValidSchematicCache(targetPage, 900000L)) {
                this.startPaginationPreload(targetPage);
            } else {
                System.out.println("Page " + targetPage + " already cached - no preload needed");
            }
        }
    }

    private void startPaginationPreload(int pageNumber) {
        if (pageNumber == this.currentPage) {
            return;
        }
        this.isPreloadingPagination = true;
        this.preloadingPageNumber = pageNumber;
        System.out.println("Starting instant pagination preload for page: " + pageNumber);
        new Thread(() -> {
            try {
                if (!this.isPreloadingPagination || this.preloadingPageNumber != pageNumber) {
                    System.out.println("Pagination preload cancelled for page " + pageNumber);
                    return;
                }
                LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(pageNumber, 15, this.showUnverified);
                class_310.method_1551().execute(() -> {
                    if (this.isPreloadingPagination && this.preloadingPageNumber == pageNumber) {
                        cacheManager.putSchematicCache(result);
                        System.out.println("Successfully preloaded and cached page: " + pageNumber + " (" + result.getItems().size() + " items)");
                    } else {
                        System.out.println("Discarded pagination preload result for page " + pageNumber + " - cancelled");
                    }
                    if (this.preloadingPageNumber == pageNumber) {
                        this.isPreloadingPagination = false;
                        this.preloadingPageNumber = -1;
                    }
                });
            }
            catch (Exception e) {
                System.err.println("Error during pagination preload for page " + pageNumber + ": " + e.getMessage());
                class_310.method_1551().execute(() -> {
                    if (this.preloadingPageNumber == pageNumber) {
                        this.isPreloadingPagination = false;
                        this.preloadingPageNumber = -1;
                    }
                });
            }
        }).start();
    }
}

