/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.gui.LitematicDownloaderScreen;
import com.choculaterie.models.SchematicDetailInfo;
import com.choculaterie.models.SchematicInfo;
import com.choculaterie.networking.LitematicHttpClient;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class CacheManager {
    private final Map<Integer, SchematicCacheEntry> schematicCache = new HashMap<Integer, SchematicCacheEntry>();
    private final Map<String, SearchCacheEntry> searchCache = new HashMap<String, SearchCacheEntry>();
    private final Map<String, DetailCacheEntry> detailCache = new HashMap<String, DetailCacheEntry>();
    private static boolean hasPreloaded = false;
    private static boolean isPreloading = false;

    public static void initializeAtGameStartup() {
        if (hasPreloaded || isPreloading) {
            return;
        }
        System.out.println("Initializing schematic cache system at game startup...");
        CompletableFuture.runAsync(() -> {
            try {
                isPreloading = true;
                CacheManager staticCacheManager = LitematicDownloaderScreen.getCacheManager();
                LitematicHttpClient.PaginatedResult result = LitematicHttpClient.fetchSchematicsPaginated(1, 15);
                if (class_310.method_1551() != null) {
                    class_310.method_1551().execute(() -> {
                        staticCacheManager.putSchematicCache(result);
                        System.out.println("Pre-cached page 1 with " + result.getItems().size() + " items (Total pages: " + result.getTotalPages() + ")");
                    });
                }
                hasPreloaded = true;
                isPreloading = false;
                System.out.println("Background cache pre-loading completed successfully!");
            }
            catch (Exception e) {
                isPreloading = false;
                System.err.println("Error during background pre-loading: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void preloadInitialData() {
        if (hasPreloaded || isPreloading) {
            return;
        }
        CacheManager.initializeAtGameStartup();
    }

    public boolean hasValidSchematicCache(int page, long maxAge) {
        SchematicCacheEntry entry = this.schematicCache.get(page);
        return entry != null && !entry.isExpired(maxAge);
    }

    public SchematicCacheEntry getSchematicCache(int page) {
        return this.schematicCache.get(page);
    }

    public void putSchematicCache(LitematicHttpClient.PaginatedResult result) {
        SchematicCacheEntry cache = new SchematicCacheEntry(result);
        int page = cache.getCurrentPage();
        this.schematicCache.put(page, cache);
        System.out.println("Cached schematics page " + page + " (" + result.getItems().size() + " items)");
        SchematicCacheEntry verifyEntry = this.schematicCache.get(page);
        if (verifyEntry != null) {
            System.out.println("Cache verification: Page " + page + " now has " + verifyEntry.getItems().size() + " items");
        }
    }

    public void clearSchematicCache(int page) {
        this.schematicCache.remove(page);
        System.out.println("Cleared schematic cache for page " + page);
    }

    public boolean hasValidSearchCache(String searchTerm, long maxAge) {
        SearchCacheEntry entry = this.searchCache.get(searchTerm.toLowerCase());
        return entry != null && !entry.isExpired(maxAge);
    }

    public SearchCacheEntry getSearchCache(String searchTerm) {
        return this.searchCache.get(searchTerm.toLowerCase());
    }

    public void putSearchCache(String searchTerm, ReferenceImmutableList<SchematicInfo> items) {
        this.searchCache.put(searchTerm.toLowerCase(), new SearchCacheEntry(items, searchTerm));
        System.out.println("Cached search results for '" + searchTerm + "' (" + items.size() + " results)");
    }

    public void clearSearchCache(String searchTerm) {
        this.searchCache.remove(searchTerm.toLowerCase());
        System.out.println("Cleared search cache for '" + searchTerm + "'");
    }

    public boolean hasValidDetailCache(String schematicId, long maxAge) {
        DetailCacheEntry entry = this.detailCache.get(schematicId);
        return entry != null && !entry.isExpired(maxAge);
    }

    public DetailCacheEntry getDetailCache(String schematicId) {
        return this.detailCache.get(schematicId);
    }

    public void putDetailCache(String schematicId, SchematicDetailInfo detail, long maxAge) {
        this.detailCache.put(schematicId, new DetailCacheEntry(detail));
        System.out.println("Cached detail for schematic " + schematicId);
    }

    public void clearDetailCache(String schematicId) {
        this.detailCache.remove(schematicId);
        System.out.println("Cleared detail cache for " + schematicId);
    }

    public void clearAllCache() {
        this.schematicCache.clear();
        this.searchCache.clear();
        this.detailCache.clear();
        System.out.println("Cleared ALL cache entries");
    }

    public void clearAllSchematicCache() {
        this.schematicCache.clear();
        System.out.println("Cleared ALL schematic page cache entries");
    }

    public String getCacheStats() {
        return String.format("Cache: %d pages, %d searches, %d details", this.schematicCache.size(), this.searchCache.size(), this.detailCache.size());
    }

    public String getCacheStatsDetailed() {
        StringBuilder stats = new StringBuilder();
        stats.append(String.format("Cache: %d pages, %d searches, %d details\n", this.schematicCache.size(), this.searchCache.size(), this.detailCache.size()));
        if (!this.schematicCache.isEmpty()) {
            stats.append("Cached pages: ");
            for (Integer page : this.schematicCache.keySet()) {
                SchematicCacheEntry entry = this.schematicCache.get(page);
                long ageMs = System.currentTimeMillis() - entry.timestamp;
                long ageMinutes = ageMs / 60000L;
                stats.append(String.format("%d(%dm old), ", page, ageMinutes));
            }
            stats.setLength(stats.length() - 2);
        }
        return stats.toString();
    }

    public boolean isPageCached(int page) {
        boolean cached = this.schematicCache.containsKey(page);
        System.out.println("Page " + page + " cache check: " + (cached ? "CACHED" : "NOT CACHED"));
        return cached;
    }

    public void debugPrintCachedPages() {
        System.out.println("=== DEBUG: Current cached pages ===");
        if (this.schematicCache.isEmpty()) {
            System.out.println("No pages cached");
        } else {
            for (Map.Entry<Integer, SchematicCacheEntry> entry : this.schematicCache.entrySet()) {
                int page = entry.getKey();
                SchematicCacheEntry cacheEntry = entry.getValue();
                long ageMs = System.currentTimeMillis() - cacheEntry.timestamp;
                long ageMinutes = ageMs / 60000L;
                boolean expired = cacheEntry.isExpired(900000L);
                System.out.println(String.format("Page %d: %d items, %d minutes old, %s", page, cacheEntry.result.getItems().size(), ageMinutes, expired ? "EXPIRED" : "VALID"));
            }
        }
        System.out.println("=== END DEBUG ===");
    }

    @Environment(value=EnvType.CLIENT)
    public static class SchematicCacheEntry {
        private final LitematicHttpClient.PaginatedResult result;
        private final long timestamp;

        public SchematicCacheEntry(LitematicHttpClient.PaginatedResult result) {
            this.result = result;
            this.timestamp = System.currentTimeMillis();
        }

        public ReferenceImmutableList<SchematicInfo> getItems() {
            return this.result.getItems();
        }

        public int getTotalPages() {
            return this.result.getTotalPages();
        }

        public int getTotalItems() {
            return this.result.getTotalItems();
        }

        public int getCurrentPage() {
            return this.result.getCurrentPage();
        }

        public boolean isExpired(long maxAge) {
            return System.currentTimeMillis() - this.timestamp > maxAge;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class SearchCacheEntry {
        private final ReferenceImmutableList<SchematicInfo> items;
        private final String searchTerm;
        private final long timestamp;

        public SearchCacheEntry(ReferenceImmutableList<SchematicInfo> items, String searchTerm) {
            this.items = items;
            this.searchTerm = searchTerm;
            this.timestamp = System.currentTimeMillis();
        }

        public ReferenceImmutableList<SchematicInfo> getItems() {
            return this.items;
        }

        public String getSearchTerm() {
            return this.searchTerm;
        }

        public boolean isExpired(long maxAge) {
            return System.currentTimeMillis() - this.timestamp > maxAge;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DetailCacheEntry {
        private final SchematicDetailInfo detail;
        private final long timestamp;

        public DetailCacheEntry(SchematicDetailInfo detail) {
            this.detail = detail;
            this.timestamp = System.currentTimeMillis();
        }

        public SchematicDetailInfo getDetail() {
            return this.detail;
        }

        public boolean isExpired(long maxAge) {
            return System.currentTimeMillis() - this.timestamp > maxAge;
        }
    }
}

