/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class SettingsManager {
    private static final String SETTINGS_FILE = "config/litematic-downloader-settings.json";
    private static final String KEY_FILE = "config/.ld-key";
    private static Settings settings;
    private static final Gson gson;
    private static SecretKey encryptionKey;

    public static Settings getSettings() {
        if (settings == null) {
            SettingsManager.loadSettings();
        }
        return settings;
    }

    public static void loadSettings() {
        block9: {
            try {
                File settingsFile;
                File configDir = new File(class_310.method_1551().field_1697, "config");
                if (!configDir.exists()) {
                    configDir.mkdirs();
                }
                if (!(settingsFile = new File(class_310.method_1551().field_1697, SETTINGS_FILE)).exists()) break block9;
                try (FileReader reader = new FileReader(settingsFile);){
                    settings = (Settings)gson.fromJson((Reader)reader, Settings.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (settings == null) {
            settings = new Settings();
        }
    }

    public static void saveSettings() {
        try {
            File configDir = new File(class_310.method_1551().field_1697, "config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            File settingsFile = new File(class_310.method_1551().field_1697, SETTINGS_FILE);
            try (FileWriter writer = new FileWriter(settingsFile);){
                gson.toJson((Object)settings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getSchematicsPath() {
        Settings settings = SettingsManager.getSettings();
        if (settings.useCustomPath && !settings.customSchematicsPath.isEmpty()) {
            return settings.customSchematicsPath;
        }
        return SettingsManager.getDefaultSchematicsPath();
    }

    public static String getDefaultSchematicsPath() {
        try {
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                return new File(gameDir, "schematics").getAbsolutePath();
            }
            boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
            String homeDir = System.getProperty("user.home");
            if (isDevelopment) {
                return homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "schematics";
            }
            return homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "schematics";
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.getProperty("user.home") + File.separator + "schematics";
        }
    }

    public static void setCustomPath(String path, boolean useCustom) {
        Settings settings = SettingsManager.getSettings();
        settings.customSchematicsPath = path;
        settings.useCustomPath = useCustom;
        SettingsManager.saveSettings();
    }

    public static String getImagesPath() {
        Settings settings = SettingsManager.getSettings();
        if (settings.useCustomImagesPath && !settings.customImagesPath.isEmpty()) {
            return settings.customImagesPath;
        }
        return SettingsManager.getDefaultImagesPath();
    }

    public static String getDefaultImagesPath() {
        try {
            File gameDir = class_310.method_1551().field_1697;
            if (gameDir != null) {
                return new File(gameDir, "screenshots").getAbsolutePath();
            }
            boolean isDevelopment = System.getProperty("dev.env", "false").equals("true");
            String homeDir = System.getProperty("user.home");
            if (isDevelopment) {
                return homeDir + File.separator + "Downloads" + File.separator + "litematic-downloader-template-1.21.4" + File.separator + "run" + File.separator + "screenshots";
            }
            return homeDir + File.separator + "AppData" + File.separator + "Roaming" + File.separator + ".minecraft" + File.separator + "screenshots";
        }
        catch (Exception e) {
            e.printStackTrace();
            return System.getProperty("user.home") + File.separator + "Pictures";
        }
    }

    public static void setCustomImagesPath(String path, boolean useCustom) {
        Settings settings = SettingsManager.getSettings();
        settings.customImagesPath = path;
        settings.useCustomImagesPath = useCustom;
        SettingsManager.saveSettings();
    }

    public static String getApiToken() {
        Settings settings = SettingsManager.getSettings();
        if (settings.encryptedApiToken == null || settings.encryptedApiToken.isEmpty()) {
            return "";
        }
        try {
            return SettingsManager.decryptToken(settings.encryptedApiToken);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void setApiToken(String token) {
        Settings settings = SettingsManager.getSettings();
        if (token == null || token.trim().isEmpty()) {
            settings.encryptedApiToken = "";
        } else {
            try {
                settings.encryptedApiToken = SettingsManager.encryptToken(token.trim());
            }
            catch (Exception e) {
                e.printStackTrace();
                settings.encryptedApiToken = "";
            }
        }
        SettingsManager.saveSettings();
    }

    public static void clearApiToken() {
        SettingsManager.setApiToken("");
    }

    public static boolean hasApiToken() {
        Settings settings = SettingsManager.getSettings();
        return settings.encryptedApiToken != null && !settings.encryptedApiToken.isEmpty();
    }

    private static SecretKey getEncryptionKey() {
        if (encryptionKey != null) {
            return encryptionKey;
        }
        try {
            File keyFile;
            File configDir = new File(class_310.method_1551().field_1697, "config");
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            if ((keyFile = new File(class_310.method_1551().field_1697, KEY_FILE)).exists()) {
                byte[] keyBytes = Files.readAllBytes(keyFile.toPath());
                encryptionKey = new SecretKeySpec(keyBytes, "AES");
            } else {
                KeyGenerator keyGen = KeyGenerator.getInstance("AES");
                keyGen.init(256, new SecureRandom());
                encryptionKey = keyGen.generateKey();
                Files.write(keyFile.toPath(), encryptionKey.getEncoded(), new OpenOption[0]);
                if (System.getProperty("os.name").toLowerCase().contains("win")) {
                    try {
                        Runtime.getRuntime().exec("attrib +H \"" + keyFile.getAbsolutePath() + "\"");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return encryptionKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            String fallbackKey = "LitematicDownloader2024!@#$%^&*";
            return new SecretKeySpec(fallbackKey.substring(0, 32).getBytes(), "AES");
        }
    }

    private static String encryptToken(String token) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, SettingsManager.getEncryptionKey());
        byte[] encryptedBytes = cipher.doFinal(token.getBytes());
        return Base64.getEncoder().encodeToString(encryptedBytes);
    }

    private static String decryptToken(String encryptedToken) throws Exception {
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, SettingsManager.getEncryptionKey());
        byte[] decryptedBytes = cipher.doFinal(Base64.getDecoder().decode(encryptedToken));
        return new String(decryptedBytes);
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
    }

    @Environment(value=EnvType.CLIENT)
    public static class Settings {
        public String customSchematicsPath = "";
        public boolean useCustomPath = false;
        public String encryptedApiToken = "";
        public String customImagesPath = "";
        public boolean useCustomImagesPath = false;
    }
}

